/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.brk.BreakpointsTableModel;
import org.zaproxy.zap.extension.brk.ExtensionBreak;

public class BreakpointsPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "breakpoints";
    private ExtensionBreak extension;
    private JPanel panelCommand = null;
    private JLabel jLabel = null;
    private JScrollPane jScrollPane = null;
    private JXTable breakpointsTable = null;
    private BreakpointsTableModel model = new BreakpointsTableModel();
    private static final String BRK_TABLE = "brk.table";
    private static final String PREF_COLUMN_WIDTH = "column.width";
    private final Preferences preferences;
    private final String prefnzPrefix = this.getClass().getSimpleName() + ".";
    private static Logger log = Logger.getLogger(BreakpointsPanel.class);

    public BreakpointsPanel(ExtensionBreak extension) {
        this.extension = extension;
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(474, 251);
        this.setName(Constant.messages.getString("brk.panel.title"));
        this.setIcon(new ImageIcon(BreakpointsPanel.class.getResource("/resource/icon/16/101.png")));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200 | 0x40, false));
        this.setMnemonic(Constant.messages.getChar("brk.panel.mnemonic"));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName(Constant.messages.getString("brk.panel.title"));
            this.jLabel = this.getJLabel();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText(" ");
        }
        return this.jLabel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)this.getBreakpoints());
        }
        return this.jScrollPane;
    }

    protected JXTable getBreakpoints() {
        if (this.breakpointsTable == null) {
            this.breakpointsTable = new JXTable((TableModel)this.model);
            this.breakpointsTable.setColumnSelectionAllowed(false);
            this.breakpointsTable.setCellSelectionEnabled(false);
            this.breakpointsTable.setRowSelectionAllowed(true);
            this.breakpointsTable.setColumnControlVisible(true);
            this.breakpointsTable.getColumnModel().getColumn(0).setPreferredWidth(this.restoreColumnWidth(BRK_TABLE, 100));
            this.breakpointsTable.getColumnModel().getColumn(0).addPropertyChangeListener(new ColumnResizedListener(BRK_TABLE));
            this.breakpointsTable.getColumnModel().getColumn(0).setMaxWidth(250);
            this.breakpointsTable.getTableHeader().setReorderingAllowed(false);
            this.breakpointsTable.setName(PANEL_NAME);
            this.breakpointsTable.setDoubleBuffered(true);
            this.breakpointsTable.setSelectionMode(0);
            this.breakpointsTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                private void showPopupMenuIfTriggered(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        int row = BreakpointsPanel.this.breakpointsTable.rowAtPoint(e.getPoint());
                        if (row < 0 || !BreakpointsPanel.this.breakpointsTable.getSelectionModel().isSelectedIndex(row)) {
                            BreakpointsPanel.this.breakpointsTable.getSelectionModel().clearSelection();
                            if (row >= 0) {
                                BreakpointsPanel.this.breakpointsTable.getSelectionModel().setSelectionInterval(row, row);
                            }
                        }
                        View.getSingleton().getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                        BreakpointsPanel.this.extension.editUiSelectedBreakpoint();
                    }
                }
            });
        }
        return this.breakpointsTable;
    }

    public BreakpointMessageInterface getSelectedBreakpoint() {
        int selectedRow = this.breakpointsTable.getSelectedRow();
        if (selectedRow != -1) {
            return this.model.getBreakpointAtRow(selectedRow);
        }
        return null;
    }

    private void selectRowAndEnsureVisible(int row) {
        if (row != -1) {
            this.breakpointsTable.getSelectionModel().setSelectionInterval(row, row);
            this.breakpointsTable.scrollRectToVisible(this.breakpointsTable.getCellRect(row, 0, true));
        }
    }

    private void addBreakpointModel(BreakpointMessageInterface breakpoint) {
        this.model.addBreakpoint(breakpoint);
        this.selectRowAndEnsureVisible(this.model.getLastAffectedRow());
    }

    void addBreakpoint(final BreakpointMessageInterface breakpoint) {
        if (EventQueue.isDispatchThread()) {
            this.addBreakpointModel(breakpoint);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BreakpointsPanel.this.addBreakpointModel(breakpoint);
                }
            });
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void editBreakpointModel(BreakpointMessageInterface oldBreakpoint, BreakpointMessageInterface newBreakpoint) {
        this.model.editBreakpoint(oldBreakpoint, newBreakpoint);
        this.selectRowAndEnsureVisible(this.model.getLastAffectedRow());
    }

    void editBreakpoint(final BreakpointMessageInterface oldBreakpoint, final BreakpointMessageInterface newBreakpoint) {
        if (EventQueue.isDispatchThread()) {
            this.editBreakpointModel(oldBreakpoint, newBreakpoint);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BreakpointsPanel.this.editBreakpointModel(oldBreakpoint, newBreakpoint);
                }
            });
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void removeBreakpointModel(BreakpointMessageInterface breakpoint) {
        this.model.removeBreakpoint(breakpoint);
    }

    public void removeBreakpoint(final BreakpointMessageInterface breakpoint) {
        if (EventQueue.isDispatchThread()) {
            this.removeBreakpointModel(breakpoint);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BreakpointsPanel.this.removeBreakpointModel(breakpoint);
                }
            });
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void saveColumnWidth(String prefix, int width) {
        if (width > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving preference " + this.prefnzPrefix + prefix + "." + PREF_COLUMN_WIDTH + "=" + width));
            }
            this.preferences.put(this.prefnzPrefix + prefix + "." + PREF_COLUMN_WIDTH, Integer.toString(width));
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException e) {
                log.error((Object)"Error while saving the preferences", (Throwable)e);
            }
        }
    }

    private int restoreColumnWidth(String prefix, int fallback) {
        int result = fallback;
        String sizestr = this.preferences.get(this.prefnzPrefix + prefix + "." + PREF_COLUMN_WIDTH, null);
        if (sizestr != null) {
            int width = 0;
            try {
                width = Integer.parseInt(sizestr.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (width > 0) {
                result = width;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring preference " + this.prefnzPrefix + prefix + "." + PREF_COLUMN_WIDTH + "=" + width));
                }
            }
        }
        return result;
    }

    private final class ColumnResizedListener
    implements PropertyChangeListener {
        private final String prefix;

        public ColumnResizedListener(String prefix) {
            assert (prefix != null);
            this.prefix = prefix;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TableColumn column = (TableColumn)evt.getSource();
            if (column != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(BreakpointsPanel.this.prefnzPrefix + this.prefix + "." + BreakpointsPanel.PREF_COLUMN_WIDTH + "=" + column.getWidth()));
                }
                BreakpointsPanel.this.saveColumnWidth(this.prefix, column.getWidth());
            }
        }
    }
}

