/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.history.PopupMenuExportURLs;

public class PopupMenuExportSelectedURLs
extends PopupMenuExportURLs {
    private static final long serialVersionUID = -4426560452505908380L;
    private static Logger LOG = Logger.getLogger(PopupMenuExportSelectedURLs.class);

    public PopupMenuExportSelectedURLs(String menuItem, Extension extension) {
        super(menuItem, extension);
    }

    @Override
    protected void performAction() {
        File file = super.getOutputFile();
        if (file == null) {
            return;
        }
        JTree siteTree = this.extension.getView().getSiteTreePanel().getTreeSite();
        super.writeURLs(file, this.getOutputSet(siteTree.getSelectionPaths()));
    }

    private SortedSet<String> getOutputSet(TreePath[] startingPoints) {
        JTree siteTree = this.extension.getView().getSiteTreePanel().getTreeSite();
        ArrayList<TreePath> startingPts = new ArrayList<TreePath>();
        if (ArrayUtils.isEmpty((Object[])startingPoints)) {
            startingPts.add(new TreePath(siteTree.getModel().getRoot()));
        } else {
            startingPts.addAll(Arrays.asList(startingPoints));
        }
        TreeSet<String> outputSet = new TreeSet<String>();
        for (TreePath aPath : startingPts) {
            Enumeration<TreeNode> en = ((SiteNode)aPath.getLastPathComponent()).preorderEnumeration();
            while (en.hasMoreElements()) {
                HistoryReference nodeHR;
                SiteNode node = (SiteNode)en.nextElement();
                if (node.isRoot() || (nodeHR = node.getHistoryReference()) == null || HistoryReference.getTemporaryTypes().contains(nodeHR.getHistoryType())) continue;
                outputSet.add(nodeHR.getURI().toString());
            }
        }
        return outputSet;
    }
}

