// Generated by gmmproc 2.54.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_CLOCKUTILS_H
#define _GSTREAMERMM_CLOCKUTILS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstclock.h>
#include <gstreamermmconfig.h>


namespace Gst
{

/** A data type to hold a time, measured in nanoseconds.
 */
typedef GstClockTime ClockTime;

/** A data type to hold a timedifference, measured in nanoseconds.
 */
typedef GstClockTimeDiff ClockTimeDiff;

/** A constant to define an undefined clock time.
 */
extern GSTREAMERMM_API const ClockTime CLOCK_TIME_NONE;

/** A constant that defines one GStreamer second.
 */
extern GSTREAMERMM_API const ClockTime SECOND;

/** A constant that defines one GStreamer millisecond.
 */
extern GSTREAMERMM_API const ClockTime MILLI_SECOND;

/** A constant that defines one GStreamer microsecond.
 */
extern GSTREAMERMM_API const ClockTime MICRO_SECOND;

/** A constant that defines one GStreamer nanosecond.
 */
extern GSTREAMERMM_API const ClockTime NANO_SECOND;

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var ClockEntryType CLOCK_ENTRY_SINGLE
 * A single shot timeout.
 * 
 *  @var ClockEntryType CLOCK_ENTRY_PERIODIC
 * A periodic timeout request.
 * 
 *  @enum ClockEntryType
 * 
 * The type of the clock entry
 *
 * @ingroup gstreamermmEnums
 */
enum ClockEntryType
{
  CLOCK_ENTRY_SINGLE,
  CLOCK_ENTRY_PERIODIC
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::ClockEntryType> : public Glib::Value_Enum<Gst::ClockEntryType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var ClockReturn CLOCK_OK
 * The operation succeeded.
 * 
 *  @var ClockReturn CLOCK_EARLY
 * The operation was scheduled too late.
 * 
 *  @var ClockReturn CLOCK_UNSCHEDULED
 * The clockID was unscheduled.
 * 
 *  @var ClockReturn CLOCK_BUSY
 * The ClockID is busy.
 * 
 *  @var ClockReturn CLOCK_BADTIME
 * A bad time was provided to a function.
 * 
 *  @var ClockReturn CLOCK_ERROR
 * An error occurred.
 * 
 *  @var ClockReturn CLOCK_UNSUPPORTED
 * Operation is not supported.
 * 
 *  @var ClockReturn CLOCK_DONE
 * The ClockID is done waiting.
 * 
 *  @enum ClockReturn
 * 
 * The return value of a clock operation.
 *
 * @ingroup gstreamermmEnums
 */
enum ClockReturn
{
  CLOCK_OK,
  CLOCK_EARLY,
  CLOCK_UNSCHEDULED,
  CLOCK_BUSY,
  CLOCK_BADTIME,
  CLOCK_ERROR,
  CLOCK_UNSUPPORTED,
  CLOCK_DONE
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::ClockReturn> : public Glib::Value_Enum<Gst::ClockReturn>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var ClockFlags CLOCK_FLAG_CAN_DO_SINGLE_SYNC
 * Clock can do a single sync timeout request.
 * 
 *  @var ClockFlags CLOCK_FLAG_CAN_DO_SINGLE_ASYNC
 * Clock can do a single async timeout request.
 * 
 *  @var ClockFlags CLOCK_FLAG_CAN_DO_PERIODIC_SYNC
 * Clock can do sync periodic timeout requests.
 * 
 *  @var ClockFlags CLOCK_FLAG_CAN_DO_PERIODIC_ASYNC
 * Clock can do async periodic timeout callbacks.
 * 
 *  @var ClockFlags CLOCK_FLAG_CAN_SET_RESOLUTION
 * Clock's resolution can be changed.
 * 
 *  @var ClockFlags CLOCK_FLAG_CAN_SET_MASTER
 * Clock can be slaved to a master clock.
 * 
 *  @var ClockFlags CLOCK_FLAG_NEEDS_STARTUP_SYNC
 * Clock needs to be synced before it can be used
 * (Since 1.6).
 * 
 *  @var ClockFlags CLOCK_FLAG_LAST
 * Subclasses can add additional flags starting from this flag.
 * 
 *  @enum ClockFlags
 * 
 * The capabilities of this clock
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%ClockFlags operator|(ClockFlags, ClockFlags)</tt><br>
 * <tt>%ClockFlags operator&(ClockFlags, ClockFlags)</tt><br>
 * <tt>%ClockFlags operator^(ClockFlags, ClockFlags)</tt><br>
 * <tt>%ClockFlags operator~(ClockFlags)</tt><br>
 * <tt>%ClockFlags& operator|=(ClockFlags&, ClockFlags)</tt><br>
 * <tt>%ClockFlags& operator&=(ClockFlags&, ClockFlags)</tt><br>
 * <tt>%ClockFlags& operator^=(ClockFlags&, ClockFlags)</tt><br>
 */
enum ClockFlags
{
  CLOCK_FLAG_CAN_DO_SINGLE_SYNC = (GST_OBJECT_FLAG_LAST << 0),
  CLOCK_FLAG_CAN_DO_SINGLE_ASYNC = (GST_OBJECT_FLAG_LAST << 1),
  CLOCK_FLAG_CAN_DO_PERIODIC_SYNC = (GST_OBJECT_FLAG_LAST << 2),
  CLOCK_FLAG_CAN_DO_PERIODIC_ASYNC = (GST_OBJECT_FLAG_LAST << 3),
  CLOCK_FLAG_CAN_SET_RESOLUTION = (GST_OBJECT_FLAG_LAST << 4),
  CLOCK_FLAG_CAN_SET_MASTER = (GST_OBJECT_FLAG_LAST << 5),
  CLOCK_FLAG_NEEDS_STARTUP_SYNC = (GST_OBJECT_FLAG_LAST << 6),
  CLOCK_FLAG_LAST = (GST_OBJECT_FLAG_LAST << 8)
};

/** @ingroup gstreamermmEnums */
inline ClockFlags operator|(ClockFlags lhs, ClockFlags rhs)
  { return static_cast<ClockFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline ClockFlags operator&(ClockFlags lhs, ClockFlags rhs)
  { return static_cast<ClockFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline ClockFlags operator^(ClockFlags lhs, ClockFlags rhs)
  { return static_cast<ClockFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline ClockFlags operator~(ClockFlags flags)
  { return static_cast<ClockFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline ClockFlags& operator|=(ClockFlags& lhs, ClockFlags rhs)
  { return (lhs = static_cast<ClockFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline ClockFlags& operator&=(ClockFlags& lhs, ClockFlags rhs)
  { return (lhs = static_cast<ClockFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline ClockFlags& operator^=(ClockFlags& lhs, ClockFlags rhs)
  { return (lhs = static_cast<ClockFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::ClockFlags> : public Glib::Value_Flags<Gst::ClockFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


/** Gets the hour component of Gst::ClockTime.
 * @param time The Gst::ClockTime to parse.
 * @return The hour component of the Gst::ClockTime.
 */
guint get_hours(Gst::ClockTime time);

/** Gets the minute component of Gst::ClockTime.
 * @param time The Gst::ClockTime to parse.
 * @return The minute component of the Gst::ClockTime.
 */
guint get_minutes(Gst::ClockTime time);

/** Gets the seconds component of Gst::ClockTime.
 * @param time The Gst::ClockTime to parse.
 * @return The seconds component of the Gst::ClockTime.
 */
guint get_seconds(Gst::ClockTime time);

/** Gets the milliseconds component of Gst::ClockTime.
 * @param time The Gst::ClockTime to parse.
 * @return The milliseconds component of the Gst::ClockTime.
 */
guint get_milliseconds(Gst::ClockTime time);

/** Gets the microseconds component of Gst::ClockTime.
 * @param time The Gst::ClockTime to parse.
 * @return The microseconds component of the Gst::ClockTime.
 */
guint get_microseconds(Gst::ClockTime time);

/** Gets the nanoseconds component of Gst::ClockTime.
 * @param time The Gst::ClockTime to parse.
 * @return The nanoseconds component of the Gst::ClockTime.
 */
guint get_nanoseconds(Gst::ClockTime time);

/** Gets the fractional component (milli, micro and nano seconds) of
 * Gst::ClockTime.
 * @param time The Gst::ClockTime to parse.
 * @return The fractional component of the Gst::ClockTime.
 */
guint get_fractional_seconds(Gst::ClockTime time);

}


#endif /* _GSTREAMERMM_CLOCKUTILS_H */

