/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.fileTypes.DirectoryFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.FileIconKey;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create("iconDeferrer:projectWasEverInitialized");
    private static final NullableFunction<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = key -> {
        VirtualFile file2 = key.getFile();
        int flags = IconUtil.filterFileIconFlags(file2, key.getFlags());
        Project project = key.getProject();
        if (!file2.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
            return null;
        }
        Icon providersIcon = IconUtil.getProvidersIcon(file2, flags, project);
        Icon icon = providersIcon != null ? providersIcon : IconUtil.getBaseIcon(file2);
        boolean dumb = project != null && DumbService.getInstance(project).isDumb();
        for (FileIconPatcher patcher : IconUtil.getPatchers()) {
            if (dumb && !DumbService.isDumbAware(patcher)) continue;
            icon = patcher.patchIcon(icon, file2, flags & 0xFFFFFFFD, project);
        }
        if (file2.is(VFileProperty.SYMLINK)) {
            icon = new LayeredIcon(icon, PlatformIcons.SYMLINK_ICON);
        }
        if (!(!BitUtil.isSet(flags, 2) || file2.isWritable() && WritingAccessProvider.isPotentiallyWritable(file2, project))) {
            icon = new LayeredIcon(icon, PlatformIcons.LOCKED_ICON);
        }
        Iconable.LastComputedIcon.put(file2, icon, flags);
        return icon;
    };

    private static boolean wasEverInitialized(@NotNull Project project) {
        Boolean was;
        if (project == null) {
            IconUtil.$$$reportNull$$$0(0);
        }
        if ((was = project.getUserData(PROJECT_WAS_EVER_INITIALIZED)) == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, true);
            } else {
                was = false;
            }
        }
        return was;
    }

    private static int filterFileIconFlags(VirtualFile file2, int flags) {
        UserDataHolder fileTypeDataHolder = ObjectUtils.tryCast(file2.getFileType(), UserDataHolder.class);
        int fileTypeFlagIgnoreMask = Iconable.ICON_FLAG_IGNORE_MASK.get(fileTypeDataHolder, 0);
        int flagIgnoreMask = Iconable.ICON_FLAG_IGNORE_MASK.get(file2, fileTypeFlagIgnoreMask);
        return flags & ~flagIgnoreMask;
    }

    public static Icon getIcon(@NotNull VirtualFile file2, int flags, @Nullable Project project) {
        Icon lastIcon;
        if (file2 == null) {
            IconUtil.$$$reportNull$$$0(11);
        }
        Icon base = (lastIcon = Iconable.LastComputedIcon.get(file2, flags)) != null ? lastIcon : IconUtil.getBaseIcon(file2);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file2, project, flags), ICON_NULLABLE_FUNCTION);
    }

    private static Icon getBaseIcon(VirtualFile vFile) {
        Icon icon = TypePresentationService.getService().getIcon(vFile);
        if (icon != null) {
            return icon;
        }
        FileType fileType = vFile.getFileType();
        if (vFile.isDirectory() && vFile.isInLocalFileSystem() && !(fileType instanceof DirectoryFileType)) {
            return PlatformIcons.FOLDER_ICON;
        }
        return fileType.getIcon();
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file2, int flags, Project project) {
        if (file2 == null) {
            IconUtil.$$$reportNull$$$0(12);
        }
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file2, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @NotNull
    private static List<FileIconProvider> getProviders() {
        List list2 = FileIconProviderHolder.myProviders;
        if (list2 == null) {
            IconUtil.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    private static List<FileIconPatcher> getPatchers() {
        List list2 = FileIconPatcherHolder.ourPatchers;
        if (list2 == null) {
            IconUtil.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public static Icon getAddIcon() {
        Icon icon = AllIcons.General.Add;
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(21);
        }
        return icon;
    }

    @NotNull
    public static Icon getRemoveIcon() {
        Icon icon = AllIcons.General.Remove;
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(22);
        }
        return icon;
    }

    @NotNull
    public static Icon getEditIcon() {
        Icon icon = AllIcons.Actions.Edit;
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(25);
        }
        return icon;
    }

    @NotNull
    public static Icon getAnalyzeIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("analyze.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(34);
        }
        return icon;
    }

    @NotNull
    private static Icon getToolbarDecoratorIcon(@NotNull String name) {
        if (name == null) {
            IconUtil.$$$reportNull$$$0(38);
        }
        Icon icon = IconLoader.getIcon(IconUtil.getToolbarDecoratorIconsFolder() + name);
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(39);
        }
        return icon;
    }

    @NotNull
    private static String getToolbarDecoratorIconsFolder() {
        String string = "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
        if (string == null) {
            IconUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public static Icon scale(final @NotNull Icon source, double _scale) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(44);
        }
        final double scale = Math.min(32.0, Math.max(0.1, _scale));
        Icon icon = new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    g2d.translate(x, y);
                    AffineTransform transform2 = AffineTransform.getScaleInstance(scale, scale);
                    transform2.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform2);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    source.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return (int)((double)source.getIconWidth() * scale);
            }

            @Override
            public int getIconHeight() {
                return (int)((double)source.getIconHeight() * scale);
            }
        };
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(45);
        }
        return icon;
    }

    @NotNull
    public static Icon scale(@NotNull Icon icon, @Nullable Component ancestor, float scale) {
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(46);
        }
        if (icon instanceof ScalableIcon) {
            if (icon instanceof JBUI.ScaleContextAware) {
                ((JBUI.ScaleContextAware)((Object)icon)).updateScaleContext(ancestor != null ? JBUI.ScaleContext.create(ancestor) : null);
            }
            Icon icon2 = ((ScalableIcon)icon).scale(scale);
            if (icon2 == null) {
                IconUtil.$$$reportNull$$$0(47);
            }
            return icon2;
        }
        Icon icon3 = IconUtil.scale(icon, scale);
        if (icon3 == null) {
            IconUtil.$$$reportNull$$$0(48);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 19: 
            case 20: 
            case 37: 
            case 46: 
            case 49: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/IconUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIconPath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 44: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 52: 
            case 55: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "img";
                break;
            }
            case 76: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/IconUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cropIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "flip";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyIcon";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyIconLike";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddIcon";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoveIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveUpIcon";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveDownIcon";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditIcon";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddClassIcon";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddPatternIcon";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddJiraPatternIcon";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddYouTrackPatternIcon";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddBlankLineIcon";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddPackageIcon";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddLinkIcon";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddFolderIcon";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyzeIcon";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarDecoratorIcon";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarDecoratorIconsFolder";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualSizedIcons";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "toSize";
                break;
            }
            case 45: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleByFont";
                break;
            }
            case 53: 
            case 56: 
            case 59: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "colorize";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "desaturate";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "brighter";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "darker";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIcon";
                break;
            }
            case 73: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageIcon";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "textToIcon";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "addText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wasEverInitialized";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cropIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "flip";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersIcon";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyIconLike";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toImage";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "paintInCenterOf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getToolbarDecoratorIcon";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getEqualSizedIcons";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "scaleByFont";
                break;
            }
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "colorize";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "desaturate";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "brighter";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "darker";
                break;
            }
            case 69: 
            case 70: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "filterIcon";
                break;
            }
            case 72: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createImageIcon";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "textToIcon";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 81: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileIconPatcherHolder {
        private static final List<FileIconPatcher> ourPatchers = FileIconPatcher.EP_NAME.getExtensionList();
    }

    private static class FileIconProviderHolder {
        private static final List<FileIconProvider> myProviders = FileIconProvider.EP_NAME.getExtensionList();
    }
}

