/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.interpretation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.interpretation.CallsEffectInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConditionInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConditionalEffectInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConstantValuesInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.EffectDeclarationInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ReturnsEffectInterpreter;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESComponents;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.Functor;
import org.jetbrains.kotlin.contracts.model.functors.SubstitutingFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0017\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "", "components", "Lorg/jetbrains/kotlin/contracts/model/ESComponents;", "(Lorg/jetbrains/kotlin/contracts/model/ESComponents;)V", "getComponents", "()Lorg/jetbrains/kotlin/contracts/model/ESComponents;", "conditionInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionInterpreter;", "conditionalEffectInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionalEffectInterpreter;", "constantsInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConstantValuesInterpreter;", "effectsInterpreters", "", "Lorg/jetbrains/kotlin/contracts/interpretation/EffectDeclarationInterpreter;", "convertContractDescriptorToFunctor", "Lorg/jetbrains/kotlin/contracts/model/Functor;", "contractDescription", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "interpretCondition", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "booleanExpression", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "interpretCondition$resolution", "interpretConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "interpretConstant$resolution", "interpretEffect", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "effectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "interpretEffect$resolution", "interpretVariable", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "variableReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "interpretVariable$resolution", "resolution"})
public final class ContractInterpretationDispatcher {
    private final ConstantValuesInterpreter constantsInterpreter;
    private final ConditionInterpreter conditionInterpreter;
    private final ConditionalEffectInterpreter conditionalEffectInterpreter;
    private final List<EffectDeclarationInterpreter> effectsInterpreters;
    @NotNull
    private final ESComponents components;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Functor convertContractDescriptorToFunctor(@NotNull ContractDescription contractDescription) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(contractDescription, "contractDescription");
        Iterable $this$map$iv = contractDescription.getEffects();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ESEffect eSEffect;
            void effect;
            EffectDeclaration effectDeclaration = (EffectDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (effect instanceof ConditionalEffectDeclaration) {
                ConditionalEffect conditionalEffect = this.conditionalEffectInterpreter.interpret((ConditionalEffectDeclaration)effect);
                if (conditionalEffect == null) {
                    return null;
                }
                eSEffect = conditionalEffect;
            } else {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.effectsInterpreters;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ESEffect eSEffect2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    EffectDeclarationInterpreter it = (EffectDeclarationInterpreter)element$iv$iv;
                    boolean bl3 = false;
                    if (it.tryInterpret((EffectDeclaration)effect) == null) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    ESEffect it$iv$iv = eSEffect2;
                    boolean bl6 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                eSEffect = (ESEffect)CollectionsKt.singleOrNull((List)destination$iv$iv2);
                if (eSEffect == null) {
                    return null;
                }
            }
            ESEffect eSEffect3 = eSEffect;
            collection.add(eSEffect3);
        }
        List resultingClauses = (List)destination$iv$iv;
        return new SubstitutingFunctor(this.components, resultingClauses, contractDescription.getOwnerFunction());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ESEffect interpretEffect$resolution(@NotNull EffectDeclaration effectDeclaration) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(effectDeclaration, "effectDeclaration");
        Iterable $this$mapNotNull$iv = this.effectsInterpreters;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ESEffect eSEffect;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            EffectDeclarationInterpreter it = (EffectDeclarationInterpreter)element$iv$iv;
            boolean bl2 = false;
            if (it.tryInterpret(effectDeclaration) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ESEffect it$iv$iv = eSEffect;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedFunctors = (List)destination$iv$iv;
        return (ESEffect)CollectionsKt.singleOrNull(convertedFunctors);
    }

    @Nullable
    public final ESConstant interpretConstant$resolution(@NotNull ConstantReference constantReference) {
        Intrinsics.checkParameterIsNotNull(constantReference, "constantReference");
        return this.constantsInterpreter.interpretConstant(constantReference, this.components.getConstants());
    }

    @Nullable
    public final ESExpression interpretCondition$resolution(@NotNull BooleanExpression booleanExpression) {
        Intrinsics.checkParameterIsNotNull(booleanExpression, "booleanExpression");
        return (ESExpression)booleanExpression.accept(this.conditionInterpreter, Unit.INSTANCE);
    }

    @Nullable
    public final ESVariable interpretVariable$resolution(@NotNull VariableReference variableReference) {
        Intrinsics.checkParameterIsNotNull(variableReference, "variableReference");
        return new ESVariable(variableReference.getDescriptor());
    }

    @NotNull
    public final ESComponents getComponents() {
        return this.components;
    }

    public ContractInterpretationDispatcher(@NotNull ESComponents components2) {
        Intrinsics.checkParameterIsNotNull(components2, "components");
        this.components = components2;
        this.constantsInterpreter = new ConstantValuesInterpreter();
        this.conditionInterpreter = new ConditionInterpreter(this);
        this.conditionalEffectInterpreter = new ConditionalEffectInterpreter(this);
        this.effectsInterpreters = CollectionsKt.listOf(new ReturnsEffectInterpreter(this), new CallsEffectInterpreter(this));
    }
}

