/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.security.policyeditor.PermissionActions;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.util.logging.OutputController;

public class TemporaryPermissions {
    private static final Pattern expandablePattern = Pattern.compile("\\$\\{([a-zA-Z0-9\\.}]+)*\\}");

    public static Collection<Permission> getPermissions(PolicyEditorPermissions ... editorPermissions) {
        return TemporaryPermissions.getPermissions(Arrays.asList(editorPermissions));
    }

    public static Collection<Permission> getPermissions(Collection<PolicyEditorPermissions> editorPermissions) {
        HashSet<Permission> col = new HashSet<Permission>();
        for (PolicyEditorPermissions editorPerm : editorPermissions) {
            col.add(TemporaryPermissions.getPermission(editorPerm));
        }
        return Collections.unmodifiableCollection(col);
    }

    public static Collection<Permission> getPermissions(PolicyEditorPermissions.Group permissionsGroup) {
        return TemporaryPermissions.getPermissions(permissionsGroup.getPermissions());
    }

    public static Permission getPermission(PolicyEditorPermissions editorPermission) {
        try {
            Permission perm;
            Class<?> clazz = Class.forName(editorPermission.getType().type);
            String target = editorPermission.getTarget().target;
            Matcher m = expandablePattern.matcher(target);
            while (m.find()) {
                String s = m.group(1);
                String p = System.getProperty(s);
                p = p.replace("\\", "\\\\");
                target = m.replaceFirst(p);
                m = expandablePattern.matcher(target);
            }
            if (editorPermission.getActions().equals((Object)PermissionActions.NONE)) {
                Constructor<?> ctor = clazz.getDeclaredConstructor(String.class);
                ctor.setAccessible(true);
                perm = (Permission)ctor.newInstance(target);
            } else {
                Constructor<?> ctor = clazz.getDeclaredConstructor(String.class, String.class);
                ctor.setAccessible(true);
                perm = (Permission)ctor.newInstance(target, TemporaryPermissions.collectionToString(editorPermission.getActions().getActions()));
            }
            return perm;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            OutputController.getLogger().log(e);
            return null;
        }
    }

    private static String collectionToString(Collection<String> col) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String str : col) {
            sb.append(str);
            if (count < col.size() - 1) {
                sb.append(",");
            }
            ++count;
        }
        return sb.toString();
    }
}

