/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pt extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Moscou",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Moscou",
               "",
               "Hor\u00e1rio de Moscou",
               "",
            };
        final String[] Pakistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Paquist\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Paquist\u00e3o",
               "",
               "Hor\u00e1rio do Paquist\u00e3o",
               "",
            };
        final String[] Magadan = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Magadan",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Magadan",
               "",
               "Hor\u00e1rio de Magadan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Central",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Europa Central",
               "",
               "Hor\u00e1rio da Europa Central",
               "",
            };
        final String[] Acre = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Acre",
               "ACT",
               "Hor\u00e1rio de Ver\u00e3o do Acre",
               "ACST",
               "Hor\u00e1rio do Acre",
               "ACT",
            };
        final String[] America_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Leste",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Leste",
               "",
               "Hor\u00e1rio do Leste",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Lord Howe",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Lord Howe",
               "",
               "Hor\u00e1rio de Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Nova Zel\u00e2ndia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Nova Zel\u00e2ndia",
               "",
               "Hor\u00e1rio da Nova Zel\u00e2ndia",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hor\u00e1rio do Oceano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Yakutsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Yakutsk",
               "",
               "Hor\u00e1rio de Yakutsk",
               "",
            };
        final String[] East_Timor = new String[] {
               "Hor\u00e1rio do Timor-Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Hor\u00e1rio de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Oriental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Europa Oriental",
               "",
               "Hor\u00e1rio da Europa Oriental",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Argentina Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Argentina Ocidental",
               "",
               "Hor\u00e1rio da Argentina Ocidental",
               "",
            };
        final String[] Ponape = new String[] {
               "Hor\u00e1rio de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Hor\u00e1rio da Bol\u00edvia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Saint Pierre e Miquelon",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Saint Pierre e Miquelon",
               "",
               "Hor\u00e1rio de Saint Pierre e Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "Hor\u00e1rio da Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Ecaterimburgo",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Ecaterimburgo",
               "",
               "Hor\u00e1rio de Ecaterimburgo",
               "",
            };
        final String[] Maldives = new String[] {
               "Hor\u00e1rio das Ilhas Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Hor\u00e1rio do Taiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Hor\u00e1rio de Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Hor\u00e1rio da \u00c1frica do Sul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Hor\u00e1rio de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Uzbequist\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Uzbequist\u00e3o",
               "",
               "Hor\u00e1rio do Uzbequist\u00e3o",
               "",
            };
        final String[] Mongolia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Ulan Bator",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Ulan Bator",
               "",
               "Hor\u00e1rio de Ulan Bator",
               "",
            };
        final String[] America_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o Central",
               "",
               "Hor\u00e1rio de Ver\u00e3o Central",
               "",
               "Hor\u00e1rio Central",
               "",
            };
        final String[] Niue = new String[] {
               "Hor\u00e1rio de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Hor\u00e1rio das Ilhas Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Ilhas Malvinas",
               "",
               "Hor\u00e1rio de Ver\u00e3o das Ilhas Malvinas",
               "",
               "Hor\u00e1rio das Ilhas Malvinas",
               "",
            };
        final String[] Bhutan = new String[] {
               "Hor\u00e1rio do But\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Apia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Apia",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Apia",
               "",
               "Hor\u00e1rio de Apia",
               "",
            };
        final String[] Nauru = new String[] {
               "Hor\u00e1rio de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hor\u00e1rio do Casaquist\u00e3o Ocidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Hor\u00e1rio da Ilha Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "Hor\u00e1rio de Reuni\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Hor\u00e1rio das Ilhas Coco",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Chatham",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Chatham",
               "",
               "Hor\u00e1rio de Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "Hor\u00e1rio de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Argentina",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Argentina",
               "",
               "Hor\u00e1rio da Argentina",
               "",
            };
        final String[] Gambier = new String[] {
               "Hor\u00e1rio de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Hor\u00e1rio de Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Hor\u00e1rio da Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hor\u00e1rio das Ilhas F\u00eanix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Cabo Verde",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Cabo Verde",
               "",
               "Hor\u00e1rio de Cabo Verde",
               "",
            };
        final String[] Norfolk = new String[] {
               "Hor\u00e1rio da Ilha Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Samoa",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Samoa",
               "",
               "Hor\u00e1rio de Samoa",
               "",
            };
        final String[] Davis = new String[] {
               "Hor\u00e1rio de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Cuba",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Cuba",
               "",
               "Hor\u00e1rio de Cuba",
               "",
            };
        final String[] GMT = new String[] {
               "Hor\u00e1rio do Meridiano de Greenwich",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Filipinas",
               "",
               "Hor\u00e1rio de Ver\u00e3o das Filipinas",
               "",
               "Hor\u00e1rio das Filipinas",
               "",
            };
        final String[] French_Southern = new String[] {
               "Hor\u00e1rio da Ant\u00e1rtida e do Sul da Fran\u00e7a",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Nova Caled\u00f4nia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Nova Caled\u00f4nia",
               "",
               "Hor\u00e1rio da Nova Caled\u00f4nia",
               "",
            };
        final String[] Brunei = new String[] {
               "Hor\u00e1rio de Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Ir\u00e3",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Ir\u00e3",
               "",
               "Hor\u00e1rio do Ir\u00e3",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Hor\u00e1rio do Tajiquist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Tonga",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Tonga",
               "",
               "Hor\u00e1rio de Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Bangladesh",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Bangladesh",
               "",
               "Hor\u00e1rio de Bangladesh",
               "",
            };
        final String[] Peru = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Peru",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Peru",
               "",
               "Hor\u00e1rio do Peru",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Groel\u00e2ndia Oriental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Groel\u00e2ndia Oriental",
               "",
               "Hor\u00e1rio da Groel\u00e2ndia Oriental",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Hor\u00e1rio do Quirguist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Col\u00f4mbia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Col\u00f4mbia",
               "",
               "Hor\u00e1rio da Col\u00f4mbia",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Hor\u00e1rio da Guiana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Oriental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Oriental",
               "",
               "Hor\u00e1rio da Austr\u00e1lia Oriental",
               "",
            };
        final String[] Chile = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Chile",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Chile",
               "",
               "Hor\u00e1rio do Chile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Gilberto",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Irkutsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Irkutsk",
               "",
               "Hor\u00e1rio de Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ge\u00f3rgia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ge\u00f3rgia",
               "",
               "Hor\u00e1rio da Ge\u00f3rgia",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Choibalsan",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Choibalsan",
               "",
               "Hor\u00e1rio de Choibalsan",
               "",
            };
        final String[] China = new String[] {
               "Hor\u00e1rio Padr\u00e3o da China",
               "",
               "Hor\u00e1rio de Ver\u00e3o da China",
               "",
               "Hor\u00e1rio da China",
               "",
            };
        final String[] Armenia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Arm\u00eania",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Arm\u00eania",
               "",
               "Hor\u00e1rio da Arm\u00eania",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Hor\u00e1rio da \u00c1frica Central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Jap\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Jap\u00e3o",
               "",
               "Hor\u00e1rio do Jap\u00e3o",
               "",
            };
        final String[] Taipei = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Taipei",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Taipei",
               "",
               "Hor\u00e1rio de Taipei",
               "",
            };
        final String[] Hovd = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Hovd",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Hovd",
               "",
               "Hor\u00e1rio de Hovd",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Centro-Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Centro-Ocidental",
               "",
               "Hor\u00e1rio da Austr\u00e1lia Centro-Ocidental",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Sacalina",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Sacalina",
               "",
               "Hor\u00e1rio de Sacalina",
               "",
            };
        final String[] Paraguay = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Paraguai",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Paraguai",
               "",
               "Hor\u00e1rio do Paraguai",
               "",
            };
        final String[] Malaysia = new String[] {
               "Hor\u00e1rio da Mal\u00e1sia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Maur\u00edcio",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Maur\u00edcio",
               "",
               "Hor\u00e1rio de Maur\u00edcio",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Hor\u00e1rio da \u00c1frica Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Hor\u00e1rio das Ilhas Salom\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Terra Nova",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Terra Nova",
               "",
               "Hor\u00e1rio da Terra Nova",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Hor\u00e1rio do Afeganist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Hong Kong",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Hong Kong",
               "",
               "Hor\u00e1rio de Hong Kong",
               "",
            };
        final String[] Atlantic = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Atl\u00e2ntico",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Atl\u00e2ntico",
               "",
               "Hor\u00e1rio do Atl\u00e2ntico",
               "",
            };
        final String[] Israel = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Israel",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Israel",
               "",
               "Hor\u00e1rio de Israel",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Omsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Omsk",
               "",
               "Hor\u00e1rio de Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "Hor\u00e1rio de Seicheles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Uruguai",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Uruguai",
               "",
               "Hor\u00e1rio do Uruguai",
               "",
            };
        final String[] Nepal = new String[] {
               "Hor\u00e1rio do Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Hor\u00e1rio de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Vanuatu",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Vanuatu",
               "",
               "Hor\u00e1rio de Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Novosibirsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Novosibirsk",
               "",
               "Hor\u00e1rio de Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Cingapura",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Hor\u00e1rio Padr\u00e3o dos A\u00e7ores",
               "",
               "Hor\u00e1rio de Ver\u00e3o dos A\u00e7ores",
               "",
               "Hor\u00e1rio dos A\u00e7ores",
               "",
            };
        final String[] Suriname = new String[] {
               "Hor\u00e1rio do Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Krasnoyarsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Krasnoyarsk",
               "",
               "Hor\u00e1rio de Krasnoyarsk",
               "",
            };
        final String[] Myanmar = new String[] {
               "Hor\u00e1rio de Mianmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Amazonas",
               "AMT",
               "Hor\u00e1rio de Ver\u00e3o do Amazonas",
               "AMST",
               "Hor\u00e1rio do Amazonas",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hor\u00e1rio do Casaquist\u00e3o Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Fiji",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Fiji",
               "",
               "Hor\u00e1rio de Fiji",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hor\u00e1rio de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Hor\u00e1rio de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Hor\u00e1rio da Ilha Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "",
               "Hor\u00e1rio do Hava\u00ed e Ilhas Aleutas",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Central",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Central",
               "",
               "Hor\u00e1rio da Austr\u00e1lia Central",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Pac\u00edfico",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Pac\u00edfico",
               "",
               "Hor\u00e1rio do Pac\u00edfico",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Turcomenist\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Turcomenist\u00e3o",
               "",
               "Hor\u00e1rio do Turcomenist\u00e3o",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Europa Ocidental",
               "",
               "Hor\u00e1rio da Europa Ocidental",
               "",
            };
        final String[] Guyana = new String[] {
               "Hor\u00e1rio da Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Hor\u00e1rio de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Hor\u00e1rio de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Hor\u00e1rio de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Arzeibaij\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Arzeibaij\u00e3o",
               "",
               "Hor\u00e1rio do Arzeibaij\u00e3o",
               "",
            };
        final String[] Mawson = new String[] {
               "Hor\u00e1rio de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Pac\u00edfico Mexicano",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Pac\u00edfico Mexicano",
               "",
               "Hor\u00e1rio do Pac\u00edfico Mexicano",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da \u00c1frica Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da \u00c1frica Ocidental",
               "",
               "Hor\u00e1rio da \u00c1frica Ocidental",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hor\u00e1rio da Ge\u00f3rgia do Sul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Noroeste do M\u00e9xico",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Noroeste do M\u00e9xico",
               "",
               "Hor\u00e1rio do Noroeste do M\u00e9xico",
               "",
            };
        final String[] Easter = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ilha de P\u00e1scoa",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ilha de P\u00e1scoa",
               "",
               "Hor\u00e1rio da Ilha de P\u00e1scoa",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Hor\u00e1rio de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Groenl\u00e2ndia Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Groenl\u00e2ndia Ocidental",
               "",
               "Hor\u00e1rio da Groenl\u00e2ndia Ocidental",
               "",
            };
        final String[] Ecuador = new String[] {
               "Hor\u00e1rio do Equador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Hor\u00e1rio do Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Coreia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Coreia",
               "",
               "Hor\u00e1rio da Coreia",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Ocidental",
               "",
               "Hor\u00e1rio da Austr\u00e1lia Ocidental",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Ocidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Montanhas",
               "",
               "Hor\u00e1rio de Ver\u00e3o das Montanhas",
               "",
               "Hor\u00e1rio das Montanhas",
               "",
            };
        final String[] Marquesas = new String[] {
               "Hor\u00e1rio das Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ar\u00e1bia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ar\u00e1bia",
               "",
               "Hor\u00e1rio da Ar\u00e1bia",
               "",
            };
        final String[] Alaska = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Alasca",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Alasca",
               "",
               "Hor\u00e1rio do Alasca",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Vladivostok",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Vladivostok",
               "",
               "Hor\u00e1rio de Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "Hor\u00e1rio de Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Hor\u00e1rio de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hor\u00e1rio de Papua Nova Guin\u00e9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Fernando de Noronha",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Fernando de Noronha",
               "",
               "Hor\u00e1rio de Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Bras\u00edlia",
               "BRT",
               "Hor\u00e1rio de Ver\u00e3o de Bras\u00edlia",
               "BRST",
               "Hor\u00e1rio de Bras\u00edlia",
               "BRT",
            };
        final String[] Anadyr = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Anadyr",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Anadyr",
               "",
               "Hor\u00e1rio de Anadyr",
               "",
            };
        final String[] Samara = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Samara",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Samara",
               "",
               "Hor\u00e1rio de Samara",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Hor\u00e1rio de Pyongyang",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hor\u00e1rio Padr\u00e3o da \u00cdndia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Ilhas Cook",
               "",
               "Meio Hor\u00e1rio de Ver\u00e3o das Ilhas Cook",
               "",
               "Hor\u00e1rio das Ilhas Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.Asia/Katmandu", "Catmandu" },
            { "timezone.excity.America/Antigua", "Ant\u00edgua" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marquesas" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota do Norte" },
            { "timezone.excity.Pacific/Fiji", "Fiji" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Duchambe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Londres" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "HST", Hawaii_Aleutian },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Santa L\u00facia" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berlim" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota do Norte" },
            { "timezone.excity.America/Cayenne", "Caiena" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevid\u00e9u" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Ge\u00f3rgia do Sul" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madri" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Asia/Hebron", "Hebrom" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Carachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salen, Dakota do Norte" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Zurique" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "Nova York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Etc/Unknown", "Cidade desconhecida" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhgorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Argel" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Cartum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e3" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "",
                    "Hor\u00e1rio Padr\u00e3o da Irlanda",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conacri" },
            { "timezone.excity.Asia/Jakarta", "Jacarta" },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Santa Helena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgo" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "timezone.excity.Europe/Isle_of_Man", "Ilha de Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guiana" },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Paris" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapeste" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinque" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogad\u00edscio" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia de Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuwait" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moscou" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nair\u00f3bi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "T\u00f3quio" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Joanesburgo" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "MST", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Atlantic/Azores", "A\u00e7ores" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aqtau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Pacific/Tarawa", "Taraua" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Assun\u00e7\u00e3o" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "Hor\u00e1rio Universal Coordenado",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reiquiavique" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Africa/Djibouti", "Djibuti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Tashkent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Xangai" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "\u00c1pia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Ilha de P\u00e1scoa" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Can\u00e1rias" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Yerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Cairo" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Vars\u00f3via" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vaticano" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monr\u00f3via" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beirute" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagd\u00e1" },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guaiaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "S\u00e3o Vicente" },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Europe/Monaco", "M\u00f4naco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edpoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Europe/Bucharest", "Bucareste" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "Africa/Djibouti", Africa_Eastern },
            { "EST", America_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Man\u00e1gua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jerusal\u00e9m" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riade" },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teer\u00e3" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.America/St_Kitts", "S\u00e3o Crist\u00f3v\u00e3o" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Mac\u00e1\u00e7ar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Ecaterimburgo" },
            { "timezone.excity.Europe/Sofia", "S\u00f3fia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrac\u00e3" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Porto Pr\u00edncipe" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Cidade do M\u00e9xico" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporizhia" },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Fernando de Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sacalina" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Qyzylorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Maur\u00edcio" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Barthelemy", "S\u00e3o Bartolomeu" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indian\u00e1polis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istambul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "T\u00fanis" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Cingapura" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nic\u00f3sia" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Atlantic/Faeroe", "Ilhas Faroe" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Asgabate" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "Reuni\u00e3o" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Asia/Aden", "Adem" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Thimphu", "Timphu" },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lampur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterd\u00e3" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Am\u00e3" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Bruxelas" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Comores" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
        };
        return data;
    }
}
