/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "throwErrorFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "ir.backend.common"})
public final class LateinitLowering
implements FileLoweringPass {
    private final IrSimpleFunction throwErrorFunction;
    @NotNull
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ LateinitLowering this$0;

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration) {
                Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                if (declaration.isLateinit() && Intrinsics.areEqual(declaration.getOrigin(), IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) ^ true) {
                    IrField irField = declaration.getBackingField();
                    if (irField == null) {
                        Intrinsics.throwNpe();
                    }
                    IrSimpleFunction irSimpleFunction = declaration.getGetter();
                    if (irSimpleFunction == null) {
                        Intrinsics.throwNpe();
                    }
                    this.transformGetter(irField, irSimpleFunction);
                }
                return declaration;
            }

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration) {
                Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                if (!declaration.isLateinit()) {
                    return declaration;
                }
                IrVariable irVariable = declaration;
                boolean bl = false;
                boolean bl2 = false;
                IrVariable $this$run = irVariable;
                boolean bl3 = false;
                $this$run.setInitializer(IrConstImpl.Companion.constNull($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType()));
                return declaration;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                if (!(irValueDeclaration instanceof IrVariable)) {
                    irValueDeclaration = null;
                }
                IrVariable irVariable = (IrVariable)irValueDeclaration;
                if (irVariable == null) {
                    return expression2;
                }
                IrVariable irVar = irVariable;
                if (!irVar.isLateinit()) {
                    return expression2;
                }
                IrDeclarationParent irDeclarationParent = irVar.getParent();
                if (irDeclarationParent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
                }
                IrSymbolOwner parent2 = (IrSymbolOwner)((Object)irDeclarationParent);
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), parent2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
                boolean bl = false;
                boolean bl2 = false;
                DeclarationIrBuilder $this$run = declarationIrBuilder;
                boolean bl3 = false;
                IrBuilderWithScope irBuilderWithScope = $this$run;
                IrType irType = expression2.getType();
                IrExpression irExpression = ExpressionHelpersKt.irEqualsNull($this$run, ExpressionHelpersKt.irGet($this$run, irVar));
                IrBuilderWithScope irBuilderWithScope2 = $this$run;
                String string = irVar.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull(string, "irVar.name.asString()");
                return ExpressionHelpersKt.irIfThenElse(irBuilderWithScope, irType, irExpression, LateinitLowering.access$throwUninitializedPropertyAccessException(this.this$0, irBuilderWithScope2, string), ExpressionHelpersKt.irGet($this$run, irVar));
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                if (Intrinsics.areEqual(expression2.getSymbol(), this.this$0.getContext().getIr().getSymbols().getLateinitIsInitializedPropertyGetter()) ^ true) {
                    return expression2;
                }
                IrExpression irExpression = expression2.getExtensionReceiver();
                if (irExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrPropertyReference");
                }
                IrPropertyReference receiver2 = (IrPropertyReference)irExpression;
                Object object = receiver2.getGetter();
                IrProperty irProperty = object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = IrUtilsKt.resolveFakeOverride((IrSimpleFunction)object)) != null ? object.getCorrespondingProperty() : null;
                if (irProperty == null) {
                    Intrinsics.throwNpe();
                }
                Object object2 = irProperty;
                boolean bl = false;
                boolean bl2 = false;
                IrProperty it = object2;
                boolean bl3 = false;
                boolean bl4 = it.isLateinit();
                boolean bl5 = false;
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl7 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrProperty property = object2;
                object2 = expression2;
                bl = false;
                bl2 = false;
                Object $this$run = object2;
                boolean bl8 = false;
                object2 = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), $this$run.getSymbol(), $this$run.getStartOffset(), $this$run.getEndOffset());
                bl = false;
                bl2 = false;
                $this$run = object2;
                boolean bl9 = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$run;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$run;
                IrExpression irExpression2 = receiver2.getDispatchReceiver();
                IrField irField = property.getBackingField();
                if (irField == null) {
                    Intrinsics.throwNpe();
                }
                return ExpressionHelpersKt.irNotEquals(irBuilderWithScope, ExpressionHelpersKt.irGetField(irBuilderWithScope2, irExpression2, irField), ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$run));
            }

            private final void transformGetter(IrField backingField2, IrFunction getter2) {
                IrGetValueImpl irGetValueImpl;
                DeclarationIrBuilder irBuilder;
                IrType type2 = backingField2.getType();
                boolean bl = !IrTypePredicatesKt.isPrimitiveType(type2);
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-LateinitLowering$lower$1$transformGetter$22 = false;
                    String $i$a$-assert-LateinitLowering$lower$1$transformGetter$22 = "'lateinit' modifier is not allowed on primitive types";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LateinitLowering$lower$1$transformGetter$22));
                }
                int startOffset = getter2.getStartOffset();
                int endOffset = getter2.getEndOffset();
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), getter2.getSymbol(), startOffset, endOffset);
                boolean bl3 = false;
                boolean bl4 = false;
                DeclarationIrBuilder $this$run = declarationIrBuilder;
                boolean bl5 = false;
                IrBlockBodyImpl body = new IrBlockBodyImpl(startOffset, endOffset);
                Scope scope = $this$run.getScope();
                IrBuilderWithScope irBuilderWithScope = $this$run;
                IrValueParameter irValueParameter = getter2.getDispatchReceiverParameter();
                if (irValueParameter != null) {
                    IrValueParameter irValueParameter2 = irValueParameter;
                    IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                    Scope scope2 = scope;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    IrValueParameter it = irValueParameter2;
                    boolean bl8 = false;
                    IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($this$run, it);
                    scope = scope2;
                    irBuilderWithScope = irBuilderWithScope2;
                    irGetValueImpl = irGetValueImpl2;
                } else {
                    irGetValueImpl = null;
                }
                IrVariable resultVar = Scope.createTemporaryVariable$default(scope, ExpressionHelpersKt.irGetField(irBuilderWithScope, irGetValueImpl, backingField2), null, false, null, null, null, 62, null);
                resultVar.setParent(getter2);
                body.getStatements().add(resultVar);
                IrBuilderWithScope irBuilderWithScope3 = $this$run;
                IrType irType = $this$run.getContext().getIrBuiltIns().getNothingType();
                IrExpression irExpression = ExpressionHelpersKt.irNotEquals($this$run, ExpressionHelpersKt.irGet($this$run, resultVar), ExpressionHelpersKt.irNull($this$run));
                IrExpression irExpression2 = ExpressionHelpersKt.irReturn($this$run, ExpressionHelpersKt.irGet($this$run, resultVar));
                IrBuilderWithScope irBuilderWithScope4 = $this$run;
                String string = backingField2.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull(string, "backingField.name.asString()");
                IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse(irBuilderWithScope3, irType, irExpression, irExpression2, LateinitLowering.access$throwUninitializedPropertyAccessException(this.this$0, irBuilderWithScope4, string));
                body.getStatements().add(throwIfNull);
                getter2.setBody(body);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final IrCall throwUninitializedPropertyAccessException(@NotNull IrBuilderWithScope $this$throwUninitializedPropertyAccessException, String name) {
        IrCall irCall = ExpressionHelpersKt.irCall($this$throwUninitializedPropertyAccessException, this.throwErrorFunction);
        boolean bl = false;
        boolean bl2 = false;
        IrCall $this$apply = irCall;
        boolean bl3 = false;
        $this$apply.putValueArgument(0, IrConstImpl.Companion.string(-1, -1, $this$throwUninitializedPropertyAccessException.getContext().getIrBuiltIns().getStringType(), name));
        return irCall;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public LateinitLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.throwErrorFunction = (IrSimpleFunction)this.context.getIr().getSymbols().getThrowUninitializedPropertyAccessException().getOwner();
    }

    public static final /* synthetic */ IrCall access$throwUninitializedPropertyAccessException(LateinitLowering $this, IrBuilderWithScope $this$access_u24throwUninitializedPropertyAccessException, String name) {
        return $this.throwUninitializedPropertyAccessException($this$access_u24throwUninitializedPropertyAccessException, name);
    }
}

