/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.NotifyOnceListener;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedSupplier;

public interface ActionListener<Response> {
    public void onResponse(Response var1);

    public void onFailure(Exception var1);

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }
        };
    }

    public static <Response> ActionListener<Response> wrap(Runnable runnable) {
        return ActionListener.wrap(r -> runnable.run(), e -> runnable.run());
    }

    public static <Response> BiConsumer<Response, Exception> toBiConsumer(ActionListener<Response> listener) {
        return (response, throwable) -> {
            if (throwable == null) {
                listener.onResponse(response);
            } else {
                listener.onFailure((Exception)throwable);
            }
        };
    }

    public static <Response> void onResponse(Iterable<ActionListener<Response>> listeners, Response response) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onResponse(response);
            }
            catch (Exception ex) {
                try {
                    listener.onFailure(ex);
                }
                catch (Exception ex1) {
                    exceptionList.add(ex1);
                }
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> void onFailure(Iterable<ActionListener<Response>> listeners, Exception failure) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onFailure(failure);
            }
            catch (Exception ex) {
                exceptionList.add(ex);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> ActionListener<Response> runAfter(final ActionListener<Response> delegate, final Runnable runAfter) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    delegate.onResponse(response);
                }
                finally {
                    runAfter.run();
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    delegate.onFailure(e);
                }
                finally {
                    runAfter.run();
                }
            }
        };
    }

    public static <Response> ActionListener<Response> notifyOnce(final ActionListener<Response> delegate) {
        return new NotifyOnceListener<Response>(){

            @Override
            protected void innerOnResponse(Response response) {
                delegate.onResponse(response);
            }

            @Override
            protected void innerOnFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> void completeWith(ActionListener<Response> listener, CheckedSupplier<Response, ? extends Exception> supplier) {
        try {
            listener.onResponse(supplier.get());
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

