/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public final class HttpTransportSettings {
    public static final Setting<Boolean> SETTING_CORS_ENABLED = Setting.boolSetting("http.cors.enabled", false, Setting.Property.NodeScope);
    public static final Setting<String> SETTING_CORS_ALLOW_ORIGIN = new Setting<String>("http.cors.allow-origin", "", value -> value, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_CORS_MAX_AGE = Setting.intSetting("http.cors.max-age", 1728000, Setting.Property.NodeScope);
    public static final Setting<String> SETTING_CORS_ALLOW_METHODS = new Setting<String>("http.cors.allow-methods", "OPTIONS,HEAD,GET,POST,PUT,DELETE", value -> value, Setting.Property.NodeScope);
    public static final Setting<String> SETTING_CORS_ALLOW_HEADERS = new Setting<String>("http.cors.allow-headers", "X-Requested-With,Content-Type,Content-Length", value -> value, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_CORS_ALLOW_CREDENTIALS = Setting.boolSetting("http.cors.allow-credentials", false, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_PIPELINING_MAX_EVENTS = Setting.intSetting("http.pipelining.max_events", 10000, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_COMPRESSION = Setting.boolSetting("http.compression", true, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_COMPRESSION_LEVEL = Setting.intSetting("http.compression_level", 3, Setting.Property.NodeScope);
    public static final Setting<List<String>> SETTING_HTTP_HOST = Setting.listSetting("http.host", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> SETTING_HTTP_PUBLISH_HOST = Setting.listSetting("http.publish_host", SETTING_HTTP_HOST, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> SETTING_HTTP_BIND_HOST = Setting.listSetting("http.bind_host", SETTING_HTTP_HOST, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<PortsRange> SETTING_HTTP_PORT = new Setting<PortsRange>("http.port", "9200-9300", PortsRange::new, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_PUBLISH_PORT = Setting.intSetting("http.publish_port", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_DETAILED_ERRORS_ENABLED = Setting.boolSetting("http.detailed_errors.enabled", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_CONTENT_TYPE_REQUIRED = new Setting<Boolean>("http.content_type.required", s -> Boolean.toString(true), s -> {
        boolean value = Booleans.parseBoolean((String)s);
        if (!value) {
            throw new IllegalArgumentException("http.content_type.required cannot be set to false. It exists only to make a rolling upgrade easier");
        }
        return true;
    }, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_CONTENT_LENGTH = Setting.byteSizeSetting("http.max_content_length", new ByteSizeValue(100L, ByteSizeUnit.MB), new ByteSizeValue(0L, ByteSizeUnit.BYTES), new ByteSizeValue(Integer.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_CHUNK_SIZE = Setting.byteSizeSetting("http.max_chunk_size", new ByteSizeValue(8L, ByteSizeUnit.KB), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_HEADER_SIZE = Setting.byteSizeSetting("http.max_header_size", new ByteSizeValue(8L, ByteSizeUnit.KB), Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_MAX_WARNING_HEADER_COUNT = Setting.intSetting("http.max_warning_header_count", -1, -1, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_WARNING_HEADER_SIZE = Setting.byteSizeSetting("http.max_warning_header_size", new ByteSizeValue(-1L), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_INITIAL_LINE_LENGTH = Setting.byteSizeSetting("http.max_initial_line_length", new ByteSizeValue(4L, ByteSizeUnit.KB), Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_RESET_COOKIES = Setting.boolSetting("http.reset_cookies", false, Setting.Property.NodeScope);
    public static final Setting<TimeValue> SETTING_HTTP_READ_TIMEOUT = Setting.timeSetting("http.read_timeout", new TimeValue(0L), new TimeValue(0L), Setting.Property.NodeScope);
    public static final Setting<Boolean> OLD_SETTING_HTTP_TCP_NO_DELAY = Setting.boolSetting("http.tcp_no_delay", NetworkService.TCP_NO_DELAY, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_TCP_NO_DELAY = Setting.boolSetting("http.tcp.no_delay", OLD_SETTING_HTTP_TCP_NO_DELAY, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_TCP_KEEP_ALIVE = Setting.boolSetting("http.tcp.keep_alive", NetworkService.TCP_KEEP_ALIVE, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_TCP_REUSE_ADDRESS = Setting.boolSetting("http.tcp.reuse_address", NetworkService.TCP_REUSE_ADDRESS, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_SEND_BUFFER_SIZE = Setting.byteSizeSetting("http.tcp.send_buffer_size", NetworkService.TCP_SEND_BUFFER_SIZE, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE = Setting.byteSizeSetting("http.tcp.receive_buffer_size", NetworkService.TCP_RECEIVE_BUFFER_SIZE, Setting.Property.NodeScope);

    private HttpTransportSettings() {
    }
}

