/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.model.ServerIndianSettlement;

public final class MapEditorTransformPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(MapEditorTransformPanel.class.getName());
    private final JPanel listPanel;
    private JToggleButton settlementButton;
    private final ButtonGroup group;
    private static Nation nativeNation = null;

    public MapEditorTransformPanel(FreeColClient freeColClient) {
        super(freeColClient, new BorderLayout());
        nativeNation = this.getSpecification().getIndianNations().get(0);
        this.listPanel = new JPanel(new GridLayout(2, 0));
        this.group = new ButtonGroup();
        this.group.add(new JToggleButton());
        this.buildList();
        JScrollPane sl = new JScrollPane(this.listPanel, 20, 30);
        sl.getViewport().setOpaque(false);
        this.add(sl);
    }

    private void buildList() {
        Specification spec = this.getSpecification();
        List<TileType> tileList = spec.getTileTypeList();
        Dimension terrainSize = ImageLibrary.scaleDimension(ImageLibrary.TILE_OVERLAY_SIZE, 0.5f);
        for (TileType type : tileList) {
            this.listPanel.add(this.buildButton(SwingGUI.createTileImageWithOverlayAndForest(type, terrainSize), Messages.getName(type), new TileTypeTransform(type)));
        }
        Dimension riverSize = ImageLibrary.scaleDimension(ImageLibrary.TILE_SIZE, 0.5f);
        this.listPanel.add(this.buildButton(ImageLibrary.getRiverImage("0101", riverSize), Messages.message("mapEditorTransformPanel.minorRiver"), new RiverTransform(1)));
        this.listPanel.add(this.buildButton(ImageLibrary.getRiverImage("0202", riverSize), Messages.message("mapEditorTransformPanel.majorRiver"), new RiverTransform(2)));
        this.listPanel.add(this.buildButton(ImageLibrary.getMiscImage("image.tileitem." + this.getSpecification().getResourceTypeList().get(0).getId(), 0.75f), Messages.message("mapEditorTransformPanel.resource"), new ResourceTransform()));
        this.listPanel.add(this.buildButton(ImageLibrary.getMiscImage("image.tileitem.lostCityRumour", 0.5f), Messages.getName(ModelMessage.MessageType.LOST_CITY_RUMOUR), new LostCityRumourTransform()));
        SettlementType settlementType = nativeNation.getType().getCapitalType();
        this.settlementButton = this.buildButton(ImageLibrary.getSettlementImage(settlementType, 0.5f), Messages.message("settlement"), new SettlementTransform());
        this.listPanel.add(this.settlementButton);
    }

    private JToggleButton buildButton(Image image, String text, MapTransform mt) {
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)new JLabel(new ImageIcon(image)), "Center");
        descriptionPanel.add((Component)new JLabel(text, 0), "South");
        descriptionPanel.setBackground(Color.RED);
        mt.setDescriptionPanel(descriptionPanel);
        ImageIcon icon = new ImageIcon(image);
        JToggleButton button = new JToggleButton(icon);
        button.setToolTipText(text);
        button.setOpaque(false);
        this.group.add(button);
        button.addActionListener(ae -> {
            MapEditorController ctlr = this.getFreeColClient().getMapEditorController();
            MapTransform newMapTransform = null;
            if (ctlr.getMapTransform() != mt) {
                newMapTransform = mt;
            }
            ctlr.setMapTransform(newMapTransform);
            if (newMapTransform == null && mt != null) {
                this.group.setSelected(this.group.getElements().nextElement().getModel(), true);
            }
        });
        button.setBorder(null);
        return button;
    }

    public static void setNativeNation(Nation newNativeNation) {
        nativeNation = newNativeNation;
    }

    private class SettlementTransform
    extends MapTransform {
        private SettlementTransform() {
        }

        @Override
        public void transform(Tile t) {
            if (!t.isLand() || t.hasSettlement() || nativeNation == null) {
                return;
            }
            UnitType skill = ((IndianNationType)nativeNation.getType()).getSkills().get(0).getObject();
            Player nativePlayer = MapEditorTransformPanel.this.getGame().getPlayerByNation(nativeNation);
            if (nativePlayer == null) {
                return;
            }
            String name = nativePlayer.getSettlementName(null);
            ServerIndianSettlement settlement = new ServerIndianSettlement(t.getGame(), nativePlayer, name, t, false, skill, null);
            nativePlayer.addSettlement(settlement);
            settlement.placeSettlement(true);
            settlement.addUnits(null);
            logger.info("Add settlement " + settlement.getName() + " to tile " + t);
        }
    }

    private class LostCityRumourTransform
    extends MapTransform {
        private LostCityRumourTransform() {
        }

        @Override
        public void transform(Tile t) {
            if (t.isLand()) {
                LostCityRumour rumour = t.getLostCityRumour();
                if (rumour == null) {
                    t.addLostCityRumour(new LostCityRumour(t.getGame(), t));
                } else {
                    t.removeLostCityRumour();
                }
            }
        }
    }

    private class ResourceTransform
    extends MapTransform {
        private ResourceTransform() {
        }

        @Override
        public void transform(Tile t) {
            Resource resource = null;
            if (t.getTileItemContainer() != null) {
                resource = t.getTileItemContainer().getResource();
            }
            if (resource != null) {
                t.getTileItemContainer().removeTileItem(resource);
            } else {
                List<ResourceType> resList = t.getType().getResourceTypes();
                switch (resList.size()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        ResourceType resourceType = resList.get(0);
                        t.addResource(new Resource(t.getGame(), t, resourceType, resourceType.getMaxValue()));
                        return;
                    }
                }
                ArrayList choices = new ArrayList();
                for (ResourceType rt : resList) {
                    String name = Messages.getName(rt);
                    choices.add(new ChoiceItem<ResourceType>(name, rt));
                }
                ResourceType choice = (ResourceType)MapEditorTransformPanel.this.getGUI().getChoice(null, Messages.message("mapEditorTransformPanel.chooseResource"), "cancel", choices);
                if (choice != null) {
                    t.addResource(new Resource(t.getGame(), t, choice, choice.getMaxValue()));
                }
            }
        }
    }

    private class RiverTransform
    extends MapTransform {
        private final int magnitude;

        private RiverTransform(int magnitude) {
            this.magnitude = magnitude;
        }

        @Override
        public void transform(Tile tile) {
            TileImprovementType riverType = tile.getSpecification().getTileImprovementType("model.improvement.river");
            if (riverType.isTileTypeAllowed(tile.getType()) && !tile.hasRiver()) {
                String conns = "";
                for (Direction direction : Direction.longSides) {
                    Tile t = tile.getNeighbourOrNull(direction);
                    TileImprovement otherRiver = t == null ? null : t.getRiver();
                    conns = conns + (t == null || t.isLand() && otherRiver == null ? "0" : Integer.toString(this.magnitude));
                }
                tile.addRiver(this.magnitude, conns);
            }
        }
    }

    public class TileTypeTransform
    extends MapTransform {
        private final TileType tileType;

        private TileTypeTransform(TileType tileType) {
            this.tileType = tileType;
        }

        public TileType getTileType() {
            return this.tileType;
        }

        @Override
        public void transform(Tile t) {
            t.changeType(this.tileType);
            t.removeLostCityRumour();
        }
    }

    public abstract class MapTransform
    implements MapEditorController.IMapTransform {
        private JPanel descriptionPanel = null;

        @Override
        public abstract void transform(Tile var1);

        public JPanel getDescriptionPanel() {
            return this.descriptionPanel;
        }

        public void setDescriptionPanel(JPanel descriptionPanel) {
            this.descriptionPanel = descriptionPanel;
        }
    }
}

