/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.AutoImplement;
import groovy.transform.Undefined;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.codehaus.groovy.antlr.AntlrParserPlugin;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class AutoImplementASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = AutoImplement.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
                return;
            }
            ClassNode exception = this.getMemberClassValue(anno, "exception");
            if (exception != null && Undefined.isUndefinedException(exception)) {
                exception = null;
            }
            String message = AutoImplementASTTransformation.getMemberStringValue(anno, "message");
            Expression code = anno.getMember("code");
            if (code != null && !(code instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'code'. Found " + code, cNode);
                return;
            }
            this.createMethods(cNode, exception, message, (ClosureExpression)code);
            if (code != null) {
                anno.setMember("code", new ClosureExpression(Parameter.EMPTY_ARRAY, EmptyStatement.INSTANCE));
            }
        }
    }

    private void createMethods(ClassNode cNode, ClassNode exception, String message, ClosureExpression code) {
        for (MethodNode candidate : AutoImplementASTTransformation.getAllCorrectedMethodsMap(cNode).values()) {
            if (!candidate.isAbstract()) continue;
            ClassNodeUtils.addGeneratedMethod(cNode, candidate.getName(), 1, candidate.getReturnType(), candidate.getParameters(), candidate.getExceptions(), this.methodBody(exception, message, code, candidate.getReturnType()));
        }
    }

    private static Map<String, MethodNode> getAllCorrectedMethodsMap(ClassNode cNode) {
        HashMap<String, MethodNode> result = new HashMap<String, MethodNode>();
        for (MethodNode mn : cNode.getMethods()) {
            result.put(MethodNodeUtils.methodDescriptorWithoutReturnType(mn), mn);
        }
        ClassNode next = cNode;
        while (true) {
            Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(next);
            for (MethodNode mn : next.getMethods()) {
                String td;
                ClassNode correctedClass;
                MethodNode found;
                MethodNode correctedMethod = GenericsUtils.correctToGenericsSpec(genericsSpec, mn);
                if (next == cNode || (found = AutoImplementASTTransformation.getDeclaredMethodCorrected(genericsSpec, correctedMethod, correctedClass = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, next))) == null || result.containsKey(td = MethodNodeUtils.methodDescriptorWithoutReturnType(found)) && !((MethodNode)result.get(td)).isAbstract()) continue;
                result.put(td, found);
            }
            ArrayList<ClassNode> interfaces = new ArrayList<ClassNode>(Arrays.asList(next.getInterfaces()));
            Map<String, ClassNode> updatedGenericsSpec = new HashMap<String, ClassNode>(genericsSpec);
            while (!interfaces.isEmpty()) {
                ClassNode origInterface = (ClassNode)interfaces.remove(0);
                if (origInterface.equals(ClassHelper.OBJECT_TYPE)) continue;
                updatedGenericsSpec = GenericsUtils.createGenericsSpec(origInterface, updatedGenericsSpec);
                ClassNode correctedInterface = GenericsUtils.correctToGenericsSpecRecurse(updatedGenericsSpec, origInterface);
                for (MethodNode nextMethod : correctedInterface.getMethods()) {
                    String td;
                    MethodNode correctedMethod = GenericsUtils.correctToGenericsSpec(genericsSpec, nextMethod);
                    MethodNode found = AutoImplementASTTransformation.getDeclaredMethodCorrected(updatedGenericsSpec, correctedMethod, correctedInterface);
                    if (found == null || result.containsKey(td = MethodNodeUtils.methodDescriptorWithoutReturnType(found)) && !((MethodNode)result.get(td)).isAbstract()) continue;
                    result.put(td, found);
                }
                interfaces.addAll(Arrays.asList(correctedInterface.getInterfaces()));
            }
            ClassNode superClass = next.getUnresolvedSuperClass();
            if (superClass == null) break;
            next = GenericsUtils.correctToGenericsSpecRecurse(updatedGenericsSpec, superClass);
        }
        return result;
    }

    private static MethodNode getDeclaredMethodCorrected(Map<String, ClassNode> genericsSpec, MethodNode origMethod, ClassNode correctedClass) {
        for (MethodNode nameMatch : correctedClass.getDeclaredMethods(origMethod.getName())) {
            MethodNode correctedMethod = GenericsUtils.correctToGenericsSpec(genericsSpec, nameMatch);
            if (!ParameterUtils.parametersEqual(correctedMethod.getParameters(), origMethod.getParameters())) continue;
            return correctedMethod;
        }
        return null;
    }

    private BlockStatement methodBody(ClassNode exception, String message, ClosureExpression code, ClassNode returnType) {
        BlockStatement body = new BlockStatement();
        if (code != null) {
            body.addStatement(code.getCode());
        } else if (exception != null) {
            body.addStatement(GeneralUtils.throwS(GeneralUtils.ctorX(exception, message == null ? ArgumentListExpression.EMPTY_ARGUMENTS : GeneralUtils.constX(message))));
        } else {
            Expression result = AntlrParserPlugin.getDefaultValueForPrimitive(returnType);
            if (result != null) {
                body.addStatement(GeneralUtils.returnS(result));
            }
        }
        return body;
    }
}

