/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.quantum.QS;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class GaussianReader
extends MOReader {
    private static final int STD_ORIENTATION_ATOMIC_NUMBER_OFFSET = 1;
    private String energyString = "";
    private String energyKey = "";
    protected int calculationNumber = 1;
    private int scanPoint = -1;
    private int equivalentAtomSets = 0;
    private int stepNumber;
    private int moModelSet = -1;
    protected BS namedSets = new BS();
    private boolean isHighPrecision;
    private boolean haveHighPrecision;
    private boolean allowHighPrecision;
    private boolean orientationInput;
    private String orientation;

    @Override
    protected void initializeReader() throws Exception {
        boolean bl = this.allowHighPrecision = !this.checkAndRemoveFilterKey("NOHP");
        this.orientation = this.checkFilterKey("ORIENTATION:INPUT") ? "Input" : (this.checkFilterKey("ORIENTATION:STANDARD") ? "Standard" : null);
        this.orientationInput = this.orientation == "Input";
        this.appendLoadNote("Orientation:" + (this.orientation == null ? "ALL" : this.orientation));
        if (this.orientation != null) {
            this.orientation = String.valueOf(this.orientation) + " orientation:";
        }
        super.initializeReader();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Step number")) {
            this.equivalentAtomSets = 0;
            ++this.stepNumber;
            int n = this.line.indexOf("scan point");
            this.scanPoint = n > 0 ? this.parseIntAt(this.line, n + 10) : -1;
            return true;
        }
        if (this.line.indexOf("-- Stationary point found") > 0) {
            if (this.scanPoint >= 0) {
                ++this.scanPoint;
            }
            return true;
        }
        if (this.orientation == null ? this.line.indexOf("Input orientation:") >= 0 || this.line.indexOf("Z-Matrix orientation:") >= 0 || this.line.indexOf("Standard orientation:") >= 0 : this.line.indexOf(this.orientation) >= 0 || this.orientationInput && this.line.indexOf("Z-Matrix orientation:") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            ++this.equivalentAtomSets;
            Logger.info(String.valueOf(this.asc.atomSetCount) + " model " + this.modelNumber + " step " + this.stepNumber + " equivalentAtomSet " + this.equivalentAtomSets + " calculation " + this.calculationNumber + " scan point " + this.scanPoint + this.line);
            this.readAtoms();
            return false;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" Energy=")) {
            this.setEnergy();
            return true;
        }
        if (this.line.startsWith(" SCF Done:")) {
            this.readSCFDone();
            return true;
        }
        if (!this.orientationInput && this.line.startsWith(" Harmonic frequencies")) {
            this.readFrequencies(":", true);
            return true;
        }
        if (this.line.startsWith(" Total atomic charges:") || this.line.startsWith(" Mulliken atomic charges:")) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith(" Dipole moment")) {
            this.readDipoleMoment();
            return true;
        }
        if (this.line.startsWith(" Standard basis:") || this.line.startsWith(" General basis read from")) {
            this.energyUnits = "";
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.line.startsWith(" AO basis set")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0 || this.line.indexOf("Natural Orbital Coefficients") >= 0 || this.line.indexOf("Natural Transition Orbitals") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals();
            Logger.info(String.valueOf(this.orbitals.size()) + " molecular orbitals read");
            return true;
        }
        if (this.line.startsWith(" Normal termination of Gaussian")) {
            ++this.calculationNumber;
            this.equivalentAtomSets = 0;
            return true;
        }
        if (this.line.startsWith(" Mulliken atomic spin densities:")) {
            this.getSpinDensities(11);
            return true;
        }
        if (this.line.startsWith(" Mulliken charges and spin densities:")) {
            this.getSpinDensities(21);
            return true;
        }
        return this.checkNboLine();
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        if (this.orientation == null) {
            this.appendLoadNote("\nUse filter 'orientation:xxx' where 'xxx' is one of: input (includes z-matrix), standard, or ALL");
        } else {
            this.appendLoadNote("\nfilter: " + this.filter);
        }
    }

    private void getSpinDensities(int n) throws Exception {
        this.rd();
        float[] fArray = new float[this.asc.getLastAtomSetAtomCount()];
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = this.parseFloatStr(this.rd().substring(n, n + 10));
            ++n2;
        }
        this.asc.setAtomProperties("spin", fArray, -1, false);
        this.appendLoadNote(String.valueOf(fArray.length) + " spin densities loaded into model " + (this.asc.iSet + 1));
    }

    private void readSCFDone() throws Exception {
        String[] stringArray = PT.getTokensAt(this.line, 11);
        if (stringArray.length < 4) {
            return;
        }
        this.energyKey = stringArray[0];
        this.asc.setAtomSetEnergy(stringArray[2], this.parseFloatStr(stringArray[2]));
        this.energyString = String.valueOf(stringArray[2]) + " " + stringArray[3];
        this.setNames(String.valueOf(this.energyKey) + " = " + this.energyString, this.namedSets, this.equivalentAtomSets);
        this.setProps(this.energyKey, this.energyString, this.equivalentAtomSets);
        stringArray = PT.getTokens(this.rd());
        if (stringArray.length > 2) {
            this.setProps(stringArray[0], stringArray[2], this.equivalentAtomSets);
            if (stringArray.length > 5) {
                this.setProps(stringArray[3], stringArray[5], this.equivalentAtomSets);
            }
            stringArray = PT.getTokens(this.rd());
        }
        if (stringArray.length > 2) {
            this.setProps(stringArray[0], stringArray[2], this.equivalentAtomSets);
        }
    }

    private void setProps(String string, String string2, int n) {
        int n2 = this.asc.iSet;
        while (--n >= 0 && n2 >= 0) {
            this.asc.setAtomSetModelPropertyForSet(string, string2, n2);
            --n2;
        }
    }

    private void setNames(String string, BS bS, int n) {
        int n2 = this.asc.iSet;
        while (--n >= 0 && n2 >= 0) {
            if (bS == null || !bS.get(n2)) {
                this.asc.setModelInfoForSet("name", string, n2);
            }
            --n2;
        }
    }

    private void setEnergy() {
        String[] stringArray = this.getTokens();
        this.energyKey = "Energy";
        this.energyString = stringArray[1];
        this.setNames("Energy = " + stringArray[1], this.namedSets, this.equivalentAtomSets);
        this.asc.setAtomSetEnergy(this.energyString, this.parseFloatStr(this.energyString));
    }

    protected void readAtoms() throws Exception {
        this.asc.newAtomSet();
        this.haveHighPrecision = false;
        if (this.energyKey.length() != 0) {
            this.asc.setAtomSetName(String.valueOf(this.energyKey) + " = " + this.energyString);
        }
        this.asc.setAtomSetEnergy(this.energyString, this.parseFloatStr(this.energyString));
        String string = this.getTokens()[0];
        this.readLines(4);
        while (this.rd() != null && !this.line.startsWith(" --")) {
            String[] stringArray = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)this.parseIntStr(stringArray[1]);
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            this.setAtomCoordTokens(atom, stringArray, stringArray.length - 3);
        }
        this.asc.setAtomSetModelProperty(".PATH", "Calculation " + this.calculationNumber + (this.scanPoint >= 0 ? String.valueOf(SmarterJmolAdapter.PATH_SEPARATOR) + "Scan Point " + this.scanPoint : "") + SmarterJmolAdapter.PATH_SEPARATOR + string);
    }

    /*
     * Unable to fully structure code
     */
    protected void readBasis() throws Exception {
        block11: {
            this.shells = new Lst<V>();
            var1_1 = new Lst<String[]>();
            var2_2 = 0;
            this.gaussianCount = 0;
            this.shellCount = 0;
            var3_3 = "";
            var5_4 = this.calculationType != null && this.calculationType.indexOf("5D") > 0;
            var6_5 = this.calculationType != null && this.calculationType.indexOf("7F") > 0;
            var7_6 = this.calculationType != null && this.calculationType.indexOf("9G") > 0;
            var8_7 = this.calculationType != null && this.calculationType.indexOf("11H") > 0;
            var9_8 = this.calculationType != null && this.calculationType.indexOf("13I") > 0;
            var10_9 = var7_6 != false || var8_7 != false || var9_8 != false;
            var11_10 = var5_4 != false || var6_5 != false || var10_9 != false;
            v0 = var12_11 = this.line.indexOf("general basis input") >= 0;
            if (!var12_11) ** GOTO lbl71
            while (this.rd() != null && this.line.length() > 0) {
                ++this.shellCount;
                var4_12 = this.getTokens();
                ++var2_2;
                while (this.rd().indexOf("****") < 0) {
                    var13_13 = new int[4];
                    var13_13[0] = var2_2;
                    var4_12 = this.getTokens();
                    var14_15 = var4_12[0];
                    var13_13[1] = var6_5 != false && var14_15.indexOf("F") >= 0 || var5_4 != false && var14_15.indexOf("D") >= 0 ? BasisFunctionReader.getQuantumShellTagIDSpherical(var14_15) : BasisFunctionReader.getQuantumShellTagID(var14_15);
                    var15_17 = this.parseIntStr(var4_12[1]);
                    var13_13[2] = this.gaussianCount + 1;
                    var13_13[3] = var15_17;
                    if (this.debugging) {
                        Logger.debug("Slater " + this.shells.size() + " " + Escape.eAI(var13_13));
                    }
                    this.shells.addLast(var13_13);
                    this.gaussianCount += var15_17;
                    var16_18 = 0;
                    while (var16_18 < var15_17) {
                        this.rd();
                        this.line = PT.rep(this.line, "D ", "D+");
                        var4_12 = this.getTokens();
                        if (this.debugging) {
                            Logger.debug("Gaussians " + (var16_18 + 1) + " " + Escape.eAS(var4_12, true));
                        }
                        var1_1.addLast(var4_12);
                        ++var16_18;
                    }
                }
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                ++this.shellCount;
                var4_12 = this.getTokens();
                var13_13 = new int[4];
                if (!var4_12[1].equals(var3_3)) {
                    // empty if block
                }
                var3_3 = var4_12[1];
                var13_13[0] = ++var2_2;
                var14_15 = var4_12[4];
                var13_13[1] = var11_10 != false && (var6_5 != false && var14_15.indexOf("F") >= 0 || var5_4 != false && var14_15.indexOf("D") >= 0 || var10_9 != false && (var7_6 != false && var14_15.indexOf("G") >= 0 || var8_7 != false && var14_15.indexOf("H") >= 0 || var9_8 != false && var14_15.indexOf("I") >= 0)) ? BasisFunctionReader.getQuantumShellTagIDSpherical(var14_15) : BasisFunctionReader.getQuantumShellTagID(var14_15);
                this.enableShell(var13_13[1]);
                var15_17 = this.parseIntStr(var4_12[5]);
                var13_13[2] = this.gaussianCount + 1;
                var13_13[3] = var15_17;
                this.shells.addLast(var13_13);
                this.gaussianCount += var15_17;
                var16_18 = 0;
                while (var16_18 < var15_17) {
                    var1_1.addLast(PT.getTokens(this.rd()));
                    ++var16_18;
                }
lbl71:
                // 2 sources

                ** while (this.rd() != null && this.line.startsWith((String)" Atom"))
            }
        }
        if (var2_2 == 0) {
            var2_2 = 1;
        }
        this.gaussians = AU.newFloat2(this.gaussianCount);
        var13_14 = 0;
        while (var13_14 < this.gaussianCount) {
            var4_12 = (String[])var1_1.get(var13_14);
            this.gaussians[var13_14] = new float[var4_12.length];
            var14_16 = 0;
            while (var14_16 < var4_12.length) {
                this.gaussians[var13_14][var14_16] = this.parseFloatStr(var4_12[var14_16]);
                ++var14_16;
            }
            ++var13_14;
        }
        Logger.info(String.valueOf(this.shellCount) + " slater shells read");
        Logger.info(String.valueOf(this.gaussianCount) + " gaussian primitives read");
    }

    protected void readMolecularOrbitals() throws Exception {
        if (this.shells == null) {
            return;
        }
        Map<K, V>[] mapArray = AU.createArrayOfHashtable(5);
        Lst<type>[] lstArray = AU.createArrayOfArrayList(5);
        int n = 0;
        boolean bl = this.line.contains("Natural Orbital");
        while (this.rd() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            String[] stringArray;
            if (this.line.indexOf("eta Molecular Orbital Coefficients") >= 0) {
                this.addMOData(n, lstArray, mapArray);
                n = 0;
                if (!this.filterMO()) break;
            }
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(n, lstArray, mapArray);
                if (bl) {
                    stringArray = this.getTokens();
                    n = stringArray.length;
                    stringArray = PT.getTokens(this.rd());
                } else {
                    stringArray = PT.getTokens(this.rd());
                    n = stringArray.length;
                }
                int n2 = 0;
                while (n2 < n) {
                    mapArray[n2] = new Hashtable();
                    lstArray[n2] = new Lst();
                    if (bl) {
                        mapArray[n2].put("occupancy", Float.valueOf(PT.parseFloat(stringArray[n2 + 2])));
                    } else {
                        String string = stringArray[n2];
                        mapArray[n2].put("symmetry", string);
                        if (string.indexOf("O") >= 0) {
                            mapArray[n2].put("occupancy", Float.valueOf(2.0f));
                        } else if (string.indexOf("V") >= 0) {
                            mapArray[n2].put("occupancy", Float.valueOf(0.0f));
                        }
                    }
                    ++n2;
                }
                if (bl) continue;
                this.line = this.rd().substring(21);
                stringArray = this.getTokens();
                if (stringArray.length != n) {
                    stringArray = GaussianReader.getStrings(this.line, n, 10);
                }
                n2 = 0;
                while (n2 < n) {
                    mapArray[n2].put("energy", Float.valueOf(stringArray[n2]));
                    ++n2;
                }
                continue;
            }
            if (this.line.length() < 21 || this.line.charAt(5) != ' ' && !PT.isDigit(this.line.charAt(5))) continue;
            try {
                this.line = PT.rep(this.line, " 0 ", "0  ");
                stringArray = this.getTokens();
                String string = stringArray[stringArray.length - n - 1].substring(1);
                if (PT.isDigit(string.charAt(0))) {
                    string = string.substring(1);
                }
                if (!QS.isQuantumBasisSupported(string.charAt(0)) && "XYZ".indexOf(string.charAt(0)) >= 0) {
                    string = String.valueOf(string.length() == 2 ? "D" : "F") + string;
                }
                if (!QS.isQuantumBasisSupported(string.charAt(0))) continue;
                stringArray = GaussianReader.getStrings(this.line.substring(this.line.length() - 10 * n), n, 10);
                int n3 = 0;
                while (n3 < n) {
                    lstArray[n3].addLast(stringArray[n3]);
                    ++n3;
                }
            }
            catch (Exception exception) {
                Logger.error("Error reading Gaussian file Molecular Orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(n, lstArray, mapArray);
        this.setMOData(this.moModelSet != this.asc.atomSetCount);
        this.moModelSet = this.asc.atomSetCount;
    }

    protected void readFrequencies(String string, boolean bl) throws Exception {
        this.discardLinesUntilContains2(string, ":");
        if (this.line == null && bl) {
            throw new Exception("No frequencies encountered");
        }
        this.line = this.rd();
        int n = this.asc.getLastAtomSetAtomCount();
        String[][] stringArray = new String[n][];
        String[][] stringArray2 = null;
        int[] nArray = new int[n];
        while (this.line != null && this.line.length() > 20) {
            String[] stringArray3 = PT.getTokens(this.rd());
            this.discardLinesUntilContains(" Frequencies");
            boolean bl2 = this.isHighPrecision = this.line.indexOf("---") > 0;
            if (this.isHighPrecision ? !this.allowHighPrecision : this.haveHighPrecision) {
                return;
            }
            if (this.isHighPrecision && !this.haveHighPrecision) {
                this.appendLoadNote("high precision vibrational modes enabled. Use filter 'NOHP' to disable.");
                this.haveHighPrecision = true;
            }
            if (stringArray2 == null) {
                stringArray2 = new String[this.isHighPrecision ? 3 : 1][0];
            }
            int n2 = this.isHighPrecision ? 22 : 15;
            String[] stringArray4 = PT.getTokensAt(this.line, n2);
            String[] stringArray5 = PT.getTokensAt(this.discardLinesUntilContains(this.isHighPrecision ? "Reduced masses" : "Red. masses"), n2);
            String[] stringArray6 = PT.getTokensAt(this.discardLinesUntilContains(this.isHighPrecision ? "Force constants" : "Frc consts"), n2);
            String[] stringArray7 = PT.getTokensAt(this.discardLinesUntilContains(this.isHighPrecision ? "IR Intensities" : "IR Inten"), n2);
            int n3 = this.asc.ac;
            int n4 = stringArray4.length;
            boolean[] blArray = new boolean[n4];
            int n5 = 0;
            while (n5 < n4) {
                boolean bl3 = blArray[n5] = !this.doGetVibration(++this.vibrationNumber);
                if (!blArray[n5]) {
                    this.asc.cloneAtomSetWithBonds(true);
                    String string2 = this.asc.setAtomSetFrequency(this.vibrationNumber, "Calculation " + this.calculationNumber, stringArray3[n5], stringArray4[n5], null);
                    this.appendLoadNote("model " + this.asc.atomSetCount + ": " + string2);
                    this.namedSets.set(this.asc.iSet);
                    this.asc.setAtomSetModelProperty("ReducedMass", String.valueOf(stringArray5[n5]) + " AMU");
                    this.asc.setAtomSetModelProperty("ForceConstant", String.valueOf(stringArray6[n5]) + " mDyne/A");
                    this.asc.setAtomSetModelProperty("IRIntensity", String.valueOf(stringArray7[n5]) + " KM/Mole");
                }
                ++n5;
            }
            this.discardLinesUntilContains(" Atom ");
            if (this.isHighPrecision) {
                do {
                    this.fillFrequencyData(n3, 1, n, blArray, false, 23, 10, null, 9, stringArray2);
                } while (stringArray2[0] != null);
                continue;
            }
            n5 = 0;
            while (true) {
                this.fillDataBlockFixed(stringArray2, 0, 0, 0);
                if (stringArray2[0].length < 10) break;
                nArray[n5] = Integer.valueOf(stringArray2[0][0]) - 1;
                stringArray[n5++] = stringArray2[0];
            }
            this.fillFrequencyData(n3, n5, n, blArray, true, 0, 0, nArray, 0, stringArray);
        }
    }

    void readDipoleMoment() throws Exception {
        String[] stringArray = PT.getTokens(this.rd());
        if (stringArray.length != 8) {
            return;
        }
        V3 v3 = V3.new3(this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[5]));
        Logger.info("Molecular dipole for model " + this.asc.atomSetCount + " = " + v3);
        this.asc.setCurrentModelInfo("dipole", v3);
    }

    /*
     * Unable to fully structure code
     */
    void readPartialCharges() throws Exception {
        this.rd();
        var1_1 = this.asc.ac;
        var2_2 = this.asc.getLastAtomSetAtomIndex();
        var3_3 = this.asc.atoms;
        var4_4 = var2_2;
        ** GOTO lbl13
        {
            ++var4_4;
            do {
                if (var3_3[var4_4].elementNumber == 0) continue block0;
                var3_3[var4_4].partialCharge = var5_5 = this.parseFloatStr(PT.getTokens(this.rd())[2]);
                ++var4_4;
lbl13:
                // 2 sources

            } while (var4_4 < var1_1);
        }
        Logger.info("Mulliken charges found for Model " + this.asc.atomSetCount);
    }
}

