/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.spartan;

import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.spartan.SpartanArchive;
import org.jmol.adapter.smarter.Atom;

public class SpartanReader
extends BasisFunctionReader {
    @Override
    public void initializeReader() throws Exception {
        String string = "Cartesian Coordinates (Ang";
        if (this.isSpartanArchive(string)) {
            this.moData = new Hashtable();
            SpartanArchive spartanArchive = new SpartanArchive(this, "", null, 0);
            int n = spartanArchive.readArchive(this.line, true, 0, true);
            if (n > 0) {
                this.asc.setAtomSetName("Spartan file");
            }
        } else if (this.line.indexOf(string) >= 0) {
            this.readAtoms();
            this.discardLinesUntilContains("Vibrational Frequencies");
            if (this.line != null) {
                this.readFrequencies();
            }
        }
        this.continuing = false;
    }

    private boolean isSpartanArchive(String string) throws Exception {
        String string2 = "";
        while (this.rd() != null) {
            if (this.line.equals("GEOMETRY")) {
                this.line = string2;
                return true;
            }
            if (this.line.indexOf(string) >= 0) {
                return false;
            }
            string2 = this.line;
        }
        return false;
    }

    private void readAtoms() throws Exception {
        this.discardLinesUntilBlank();
        while (this.rd() != null && this.parseIntRange(this.line, 0, 3) > 0) {
            Atom atom = this.asc.addNewAtom();
            atom.elementSymbol = this.parseTokenRange(this.line, 4, 6);
            atom.atomName = this.parseTokenRange(this.line, 7, 13);
            this.setAtomCoordXYZ(atom, this.parseFloatRange(this.line, 17, 30), this.parseFloatRange(this.line, 31, 44), this.parseFloatRange(this.line, 45, 58));
        }
    }

    private void readFrequencies() throws Exception {
        int n = this.asc.getAtomSetAtomCount(0);
        block0: while (true) {
            this.discardLinesUntilNonBlank();
            int n2 = this.vibrationNumber;
            this.next[0] = 16;
            boolean[] blArray = new boolean[3];
            int n3 = 0;
            while (n3 < 3) {
                float f = this.parseFloat();
                if (Float.isNaN(f)) break;
                boolean bl = blArray[n3] = !this.doGetVibration(++this.vibrationNumber);
                if (!blArray[n3]) {
                    if (this.vibrationNumber > 1) {
                        this.asc.cloneFirstAtomSet(0);
                    }
                    this.asc.setAtomSetFrequency(this.vibrationNumber, null, null, "" + f, null);
                }
                ++n3;
            }
            if (n3 == 0) {
                return;
            }
            this.readLines(2);
            int n4 = 0;
            while (true) {
                if (n4 >= n) continue block0;
                this.rd();
                int n5 = 0;
                while (n5 < n3) {
                    int n6 = n5 * 23 + 10;
                    float f = this.parseFloatRange(this.line, n6, n6 + 7);
                    float f2 = this.parseFloatRange(this.line, n6 + 7, n6 + 14);
                    float f3 = this.parseFloatRange(this.line, n6 + 14, n6 + 21);
                    if (!blArray[n5]) {
                        this.asc.addVibrationVector(n4 + (n2 + n5) * n, f, f2, f3);
                    }
                    ++n5;
                }
                ++n4;
            }
            break;
        }
    }
}

