/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.api.JmolRendererInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.util.C;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class NucleicRenderer {
    private boolean cartoonBaseEdges;
    private boolean cartoonBlocks;
    private float blockHeight;
    private boolean cartoonLadders;
    private boolean cartoonRibose;
    private P3[] rPt;
    private P3[] rPt5;
    private P3[] rScr;
    private P3[] rScr5;
    private P3 basePt;
    private P3 backbonePt;
    private P3 baseScreen;
    private P3 backboneScreen;
    private P3 ptTemp;
    private Viewer vwr;
    private TransformManager tm;
    private JmolRendererInterface g3d;
    private BioShapeRenderer bsr;
    private short colix;
    private boolean cartoonSteps;
    private P3[] scrBox;
    private final int[] triangles;

    public NucleicRenderer() {
        int[] nArray = new int[36];
        nArray[0] = 1;
        nArray[2] = 3;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 2;
        nArray[7] = 4;
        nArray[8] = 7;
        nArray[10] = 7;
        nArray[11] = 3;
        nArray[12] = 4;
        nArray[13] = 5;
        nArray[14] = 6;
        nArray[15] = 4;
        nArray[16] = 6;
        nArray[17] = 7;
        nArray[18] = 5;
        nArray[19] = 1;
        nArray[20] = 2;
        nArray[21] = 5;
        nArray[22] = 2;
        nArray[23] = 6;
        nArray[24] = 2;
        nArray[25] = 3;
        nArray[26] = 7;
        nArray[27] = 2;
        nArray[28] = 7;
        nArray[29] = 6;
        nArray[31] = 1;
        nArray[32] = 5;
        nArray[34] = 5;
        nArray[35] = 4;
        this.triangles = nArray;
    }

    void renderNucleic(BioShapeRenderer bioShapeRenderer) {
        if (this.vwr == null) {
            this.rPt = new P3[10];
            this.rScr = new P3[10];
            this.rPt5 = new P3[5];
            this.rScr5 = new P3[5];
            this.backboneScreen = new P3();
            this.backbonePt = new P3();
            this.bsr = bioShapeRenderer;
            this.tm = bioShapeRenderer.vwr.tm;
            this.vwr = bioShapeRenderer.vwr;
        }
        this.g3d = bioShapeRenderer.g3d;
        P3[] p3Array = bioShapeRenderer.controlPointScreens;
        P3[] p3Array2 = bioShapeRenderer.controlPoints;
        this.cartoonBlocks = this.vwr.getBoolean(0x24000022);
        this.cartoonBaseEdges = this.vwr.getBoolean(603979816);
        this.cartoonSteps = this.vwr.getBoolean(603979811);
        this.cartoonLadders = this.vwr.getBoolean(603979818);
        this.cartoonRibose = this.vwr.getBoolean(603979819);
        this.blockHeight = this.vwr.getFloat(0x22000003);
        boolean bl = this.vwr.getBoolean(603979966);
        BS bS = this.bsr.bsVisible;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            P3 p3 = p3Array[n + 1];
            if (bl) {
                this.backboneScreen.ave(p3Array[n], p3);
                this.backbonePt.ave(p3Array2[n], p3Array2[n + 1]);
            } else {
                this.backboneScreen.setT(p3);
                this.backbonePt.setT(p3Array2[n + 1]);
            }
            this.bsr.renderHermiteConic(n, false, 4);
            this.colix = this.bsr.getLeadColix(n);
            if (this.bsr.setBioColix(this.colix)) {
                if (this.cartoonRibose && bS.get(n + 1)) {
                    this.renderNucleicBaseStep(n, p3Array2[n + 1], p3Array[n + 1]);
                } else {
                    this.renderNucleicBaseStep(n, null, null);
                }
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    private void renderNucleicBaseStep(int n, T3 t3, T3 t32) {
        P3 p3;
        P3 p32;
        boolean bl;
        if (this.bsr.isPhosphorusOnly) {
            return;
        }
        NucleicMonomer nucleicMonomer = (NucleicMonomer)this.bsr.monomers[n];
        int n2 = this.bsr.mad = this.bsr.mads[n];
        if (this.rScr[0] == null) {
            int n3 = 10;
            while (--n3 >= 0) {
                this.rScr[n3] = new P3();
            }
            n3 = 5;
            while (--n3 >= 0) {
                this.rScr5[n3] = new P3();
            }
            this.baseScreen = new P3();
            this.basePt = new P3();
            this.rPt[9] = new P3();
        }
        if (this.cartoonBlocks) {
            this.renderBlock(nucleicMonomer);
            return;
        }
        if (this.cartoonBaseEdges) {
            this.renderLeontisWesthofEdges(nucleicMonomer);
            return;
        }
        if (this.cartoonSteps) {
            this.renderSteps(nucleicMonomer, n);
            return;
        }
        nucleicMonomer.getBaseRing6Points(this.rPt);
        this.transformPoints(6, this.rPt, this.rScr);
        if (!this.cartoonLadders) {
            this.renderRing6();
        }
        if (bl = nucleicMonomer.maybeGetBaseRing5Points(this.rPt5)) {
            if (this.cartoonLadders) {
                p32 = this.rScr[2];
                p3 = this.rPt[2];
            } else {
                this.transformPoints(5, this.rPt5, this.rScr5);
                this.renderRing5();
                p32 = this.rScr5[3];
                p3 = this.rPt5[3];
            }
        } else {
            int n4 = this.cartoonLadders ? 4 : 2;
            p32 = this.rScr[n4];
            p3 = this.rPt[n4];
        }
        short s = (short)(n2 > 1 ? n2 / 2 : n2);
        float f = (float)s / 2000.0f;
        int n5 = (int)this.vwr.tm.scaleToScreen((int)this.backboneScreen.z, s);
        if (this.cartoonLadders || !this.cartoonRibose) {
            this.g3d.fillCylinderScreen3I((byte)3, n5, this.backboneScreen, p32, this.backbonePt, p3, f);
        }
        if (this.cartoonLadders) {
            return;
        }
        this.drawEdges(this.rScr, this.rPt, 6);
        if (bl) {
            this.drawEdges(this.rScr5, this.rPt5, 5);
        } else {
            this.renderEdge(this.rScr, this.rPt, 0, 5);
        }
        if (this.cartoonRibose) {
            this.baseScreen.setT(p32);
            this.basePt.setT(p3);
            nucleicMonomer.getRiboseRing5Points(this.rPt);
            P3 p33 = this.rPt[9];
            p33.set(0.0f, 0.0f, 0.0f);
            int n6 = 0;
            while (n6 < 5) {
                p33.add(this.rPt[n6]);
                ++n6;
            }
            p33.scale(0.2f);
            this.transformPoints(10, this.rPt, this.rScr);
            this.renderRibose();
            this.renderEdge(this.rScr, this.rPt, 2, 5);
            this.renderEdge(this.rScr, this.rPt, 3, 6);
            this.renderEdge(this.rScr, this.rPt, 6, 7);
            this.renderEdge(this.rScr, this.rPt, 7, 8);
            this.renderEdge(this.rScr, this.rPt, 0, 4);
            this.renderCyl(this.rScr[0], this.baseScreen, this.rPt[0], this.basePt);
            if (t3 != null) {
                this.renderCyl(this.rScr[5], (P3)t32, this.rPt[5], (P3)t3);
            }
            this.drawEdges(this.rScr, this.rPt, 5);
        }
    }

    private void renderSteps(NucleicMonomer nucleicMonomer, int n) {
        Lst<BasePair> lst = nucleicMonomer.getBasePairs();
        Atom atom = nucleicMonomer.getLeadAtom();
        short s = C.getColixInherited(this.colix, atom.colixAtom);
        if (lst != null) {
            boolean bl = !this.bsr.isExport && !this.vwr.gdata.isPass2;
            int n2 = lst.size();
            while (--n2 >= 0) {
                int n3 = ((BasePair)lst.get(n2)).getPartnerAtom(nucleicMonomer);
                if (n3 <= n) continue;
                Atom atom2 = this.vwr.ms.at[n3];
                short s2 = C.getColixInherited(this.colix, atom2.colixAtom);
                if (bl && !this.bsr.setBioColix(s) && !this.bsr.setBioColix(s2)) continue;
                this.bsr.drawSegmentAB(atom, atom2, s, s2, 1000.0f);
            }
        }
    }

    private void transformPoints(int n, T3[] t3Array, P3[] p3Array) {
        int n2 = n;
        while (--n2 >= 0) {
            this.tm.transformPtScrT3(t3Array[n2], p3Array[n2]);
        }
    }

    private void drawEdges(P3[] p3Array, P3[] p3Array2, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            p3Array[n2].z -= 1.0f;
        }
        n2 = n;
        while (--n2 > 0) {
            this.renderEdge(p3Array, p3Array2, n2, n2 - 1);
        }
    }

    private void renderBlock(NucleicMonomer nucleicMonomer) {
        Atom atom = nucleicMonomer.getLeadAtom();
        short s = this.colix;
        if (this.scrBox == null) {
            this.scrBox = new P3[8];
            int n = 0;
            while (n < 8) {
                this.scrBox[n] = new P3();
                ++n;
            }
        }
        T3[] t3Array = nucleicMonomer.getDSSRFrame(this.vwr);
        P3[] p3Array = nucleicMonomer.dssrBox;
        float f = nucleicMonomer.dssrBoxHeight;
        boolean bl = nucleicMonomer.isPurine();
        if (p3Array == null || f != this.blockHeight) {
            nucleicMonomer.dssrBoxHeight = this.blockHeight;
            if (p3Array == null) {
                p3Array = new P3[8];
                int n = 8;
                while (--n >= 0) {
                    p3Array[n] = new P3();
                }
                nucleicMonomer.dssrBox = p3Array;
            }
            SymmetryInterface symmetryInterface = this.vwr.getSymTemp().getUnitCell(t3Array, false, null);
            if (this.ptTemp == null) {
                this.ptTemp = new P3();
            }
            this.ptTemp.setT(t3Array[0]);
            symmetryInterface.toFractional(this.ptTemp, true);
            symmetryInterface.setOffsetPt(P3.new3(this.ptTemp.x - 2.25f, this.ptTemp.y + 5.0f, this.ptTemp.z - this.blockHeight / 2.0f));
            float f2 = 4.5f;
            float f3 = bl ? -4.5f : -3.0f;
            float f4 = this.blockHeight;
            p3Array[0] = P3.new3(0.0f, 0.0f, 0.0f);
            symmetryInterface.toCartesian(p3Array[0], false);
            p3Array[1] = P3.new3(f2, 0.0f, 0.0f);
            symmetryInterface.toCartesian(p3Array[1], false);
            p3Array[2] = P3.new3(f2, f3, 0.0f);
            symmetryInterface.toCartesian(p3Array[2], false);
            p3Array[3] = P3.new3(0.0f, f3, 0.0f);
            symmetryInterface.toCartesian(p3Array[3], false);
            p3Array[4] = P3.new3(0.0f, 0.0f, f4);
            symmetryInterface.toCartesian(p3Array[4], false);
            p3Array[5] = P3.new3(f2, 0.0f, f4);
            symmetryInterface.toCartesian(p3Array[5], false);
            p3Array[6] = P3.new3(f2, f3, f4);
            symmetryInterface.toCartesian(p3Array[6], false);
            p3Array[7] = P3.new3(0.0f, f3, f4);
            symmetryInterface.toCartesian(p3Array[7], false);
        }
        int n = 0;
        while (n < 8) {
            this.vwr.tm.transformPt3f(p3Array[n], this.scrBox[n]);
            ++n;
        }
        n = 0;
        while (n < 36) {
            this.g3d.fillTriangle3f(this.scrBox[this.triangles[n++]], this.scrBox[this.triangles[n++]], this.scrBox[this.triangles[n++]], false);
        }
        Atom atom2 = nucleicMonomer.getC1P();
        Atom atom3 = nucleicMonomer.getN0();
        if (atom2 != null && atom3 != null) {
            this.bsr.drawSegmentAB(atom, atom2, s, s, 1000.0f);
            this.bsr.drawSegmentAB(atom2, atom3, s, s, 1000.0f);
        }
    }

    private void renderLeontisWesthofEdges(NucleicMonomer nucleicMonomer) {
        if (!nucleicMonomer.getEdgePoints(this.rPt)) {
            return;
        }
        this.transformPoints(6, this.rPt, this.rScr);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, true);
        this.renderEdge(this.rScr, this.rPt, 0, 1);
        this.renderEdge(this.rScr, this.rPt, 1, 2);
        boolean bl = C.isColixTranslucent(this.colix);
        float f = C.getColixTranslucencyLevel(this.colix);
        short s = C.getColixTranslucent3((short)10, bl, f);
        short s2 = C.getColixTranslucent3((short)11, bl, f);
        short s3 = C.getColixTranslucent3((short)7, bl, f);
        this.g3d.setC(s);
        this.renderEdge(this.rScr, this.rPt, 2, 3);
        this.g3d.setC(s2);
        this.renderEdge(this.rScr, this.rPt, 3, 4);
        this.g3d.setC(s3);
        this.renderEdge(this.rScr, this.rPt, 4, 5);
    }

    private void renderEdge(P3[] p3Array, P3[] p3Array2, int n, int n2) {
        this.renderCyl(p3Array[n], p3Array[n2], p3Array2[n], p3Array2[n2]);
    }

    private void renderCyl(P3 p3, P3 p32, P3 p33, P3 p34) {
        this.g3d.fillCylinderScreen3I((byte)3, 3, p3, p32, p33, p34, 0.005f);
    }

    private void renderTriangle(P3[] p3Array, P3[] p3Array2, int n, int n2, int n3, boolean bl) {
        this.g3d.fillTriangle3i(p3Array[n], p3Array[n2], p3Array[n3], p3Array2[n], p3Array2[n2], p3Array2[n3], bl);
    }

    private void renderRing6() {
        this.renderTriangle(this.rScr, this.rPt, 0, 2, 4, true);
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 2, false);
        this.renderTriangle(this.rScr, this.rPt, 0, 4, 5, false);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, false);
    }

    private void renderRing5() {
        this.renderTriangle(this.rScr5, this.rPt5, 0, 1, 2, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 2, 3, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 3, 4, false);
    }

    private void renderRibose() {
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 1, 2, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 3, 4, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 4, 0, 9, true);
    }
}

