/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;
import org.jmol.util.Vibration;

class PointGroup {
    private static final int[] axesMaxN;
    private static final int[] nUnique;
    private static final int s3 = 3;
    private static final int s4 = 4;
    private static final int s5 = 5;
    private static final int s6 = 6;
    private static final int s8 = 8;
    private static final int s10 = 10;
    private static final int s12 = 12;
    private static final int firstProper = 14;
    private static final int c2 = 16;
    private static final int c3 = 17;
    private static final int c4 = 18;
    private static final int c5 = 19;
    private static final int c6 = 20;
    private static final int c8 = 22;
    private static final int maxAxis;
    private boolean isAtoms;
    String drawInfo;
    Map<String, Object> info;
    String textInfo;
    private CubeIterator iter;
    private String drawType = "";
    private int drawIndex;
    private float scale = Float.NaN;
    private int[] nAxes = new int[maxAxis];
    private Operation[][] axes = new Operation[maxAxis][];
    private int nAtoms;
    private float radius;
    private float distanceTolerance = 0.25f;
    private float distanceTolerance2;
    private float linearTolerance = 8.0f;
    private float cosTolerance = 0.99f;
    private String name = "C_1?";
    private Operation principalAxis;
    private Operation principalPlane;
    private final V3 vTemp = new V3();
    private int centerAtomIndex = -1;
    private boolean haveInversionCenter;
    private T3 center;
    private T3[] points;
    private int[] elements;
    private int[] atomMap;
    private BS bsAtoms;
    private boolean haveVibration;
    private boolean localEnvOnly;
    private static final int ATOM_COUNT_MAX = 100;
    int maxElement = 0;
    int[] eCounts;
    static final int OPERATION_PLANE = 0;
    static final int OPERATION_PROPER_AXIS = 1;
    static final int OPERATION_IMPROPER_AXIS = 2;
    static final int OPERATION_INVERSION_CENTER = 3;
    static final String[] typeNames;
    int nOps = 0;

    static {
        int[] nArray = new int[23];
        nArray[0] = 15;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 1;
        nArray[6] = 10;
        nArray[8] = 1;
        nArray[10] = 6;
        nArray[12] = 1;
        nArray[16] = 15;
        nArray[17] = 10;
        nArray[18] = 6;
        nArray[19] = 6;
        nArray[20] = 10;
        nArray[22] = 1;
        axesMaxN = nArray;
        int[] nArray2 = new int[23];
        nArray2[0] = 1;
        nArray2[3] = 2;
        nArray2[4] = 2;
        nArray2[5] = 4;
        nArray2[6] = 2;
        nArray2[8] = 4;
        nArray2[10] = 4;
        nArray2[12] = 4;
        nArray2[16] = 1;
        nArray2[17] = 2;
        nArray2[18] = 2;
        nArray2[19] = 4;
        nArray2[20] = 2;
        nArray2[22] = 4;
        nUnique = nArray2;
        maxAxis = axesMaxN.length;
        typeNames = new String[]{"plane", "proper axis", "improper axis", "center of inversion"};
    }

    String getName() {
        return this.name;
    }

    static PointGroup getPointGroup(PointGroup pointGroup, T3 t3, T3[] t3Array, BS bS, boolean bl, float f, float f2, boolean bl2) {
        PointGroup pointGroup2 = new PointGroup();
        if (f == 0.0f) {
            f = 0.01f;
            f2 = 0.5f;
        }
        pointGroup2.distanceTolerance = f;
        pointGroup2.distanceTolerance2 = f * f;
        pointGroup2.linearTolerance = f2;
        pointGroup2.isAtoms = bS != null;
        pointGroup2.bsAtoms = pointGroup2.isAtoms ? bS : BSUtil.newBitSet2(0, t3Array.length);
        pointGroup2.haveVibration = bl;
        pointGroup2.center = t3;
        pointGroup2.localEnvOnly = bl2;
        return pointGroup2.set(pointGroup, t3Array) ? pointGroup2 : pointGroup;
    }

    private PointGroup() {
    }

    private boolean isEqual(PointGroup pointGroup) {
        if (pointGroup == null) {
            return false;
        }
        if (this.linearTolerance != pointGroup.linearTolerance || this.distanceTolerance != pointGroup.distanceTolerance || this.nAtoms != pointGroup.nAtoms || this.localEnvOnly != pointGroup.localEnvOnly || this.haveVibration != pointGroup.haveVibration || this.bsAtoms == null ? pointGroup.bsAtoms != null : !this.bsAtoms.equals(pointGroup.bsAtoms)) {
            return false;
        }
        int n = 0;
        while (n < this.nAtoms) {
            if (this.elements[n] != pointGroup.elements[n] || !this.points[n].equals(pointGroup.points[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean set(PointGroup pointGroup, T3[] t3Array) {
        block18: {
            int n;
            this.cosTolerance = (float)Math.cos((double)(this.linearTolerance / 180.0f) * Math.PI);
            if (!this.getPointsAndElements(t3Array)) {
                Logger.error("Too many atoms for point group calculation");
                this.name = "point group not determined -- ac > 100 -- select fewer atoms and try again.";
                return true;
            }
            this.getElementCounts();
            if (this.haveVibration) {
                P3[] p3Array = new P3[this.points.length];
                n = this.points.length;
                while (--n >= 0) {
                    p3Array[n] = P3.newP(this.points[n]);
                    Vibration vibration = ((Atom)this.points[n]).getVibrationVector();
                    if (vibration == null) continue;
                    p3Array[n].add(vibration);
                }
                this.points = p3Array;
            }
            if (this.isEqual(pointGroup)) {
                return false;
            }
            this.findInversionCenter();
            if (this.isLinear(this.points)) {
                this.name = this.haveInversionCenter ? "D(infinity)h" : "C(infinity)v";
                this.vTemp.sub2(this.points[1], this.points[0]);
                this.addAxis(16, this.vTemp);
                this.principalAxis = this.axes[16][0];
                if (this.haveInversionCenter) {
                    this.axes[0] = new Operation[1];
                    int n2 = this.nAxes[0];
                    this.nAxes[0] = n2 + 1;
                    Operation operation = new Operation(this.vTemp);
                    this.axes[0][n2] = operation;
                    this.principalPlane = operation;
                }
                return true;
            }
            this.axes[0] = new Operation[15];
            int n3 = 0;
            this.findCAxes();
            n3 = this.findPlanes();
            this.findAdditionalAxes(n3);
            try {
                n = this.getHighestOrder();
                if (this.nAxes[17] > 1) {
                    this.name = this.nAxes[19] > 1 ? (this.haveInversionCenter ? "Ih" : "I") : (this.nAxes[18] > 1 ? (this.haveInversionCenter ? "Oh" : "O") : (n3 > 0 ? (this.haveInversionCenter ? "Th" : "Td") : "T"));
                    break block18;
                }
                if (n < 2) {
                    if (n3 == 1) {
                        this.name = "Cs";
                        return true;
                    }
                    if (this.haveInversionCenter) {
                        this.name = "Ci";
                        return true;
                    }
                    this.name = "C1";
                    break block18;
                }
                if (n % 2 == 1 && this.nAxes[16] > 0 || n % 2 == 0 && this.nAxes[16] > 1) {
                    this.principalAxis = this.setPrincipalAxis(n, n3);
                    if (n3 == 0) {
                        this.name = n < 14 ? "S" + n : "D" + (n - 14);
                        break block18;
                    } else {
                        n = n < 14 ? (n /= 2) : (n -= 14);
                        this.name = n3 == n ? "D" + n + "d" : "D" + n + "h";
                    }
                    break block18;
                }
                if (n3 == 0) {
                    this.principalAxis = this.axes[n][0];
                    this.name = n < 14 ? "S" + n : "C" + (n - 14);
                    break block18;
                }
                if (n3 == n - 14) {
                    this.principalAxis = this.axes[n][0];
                    this.name = "C" + n3 + "v";
                } else {
                    this.principalAxis = this.axes[n < 14 ? n + 14 : n][0];
                    this.principalPlane = this.axes[0][0];
                    n = n < 14 ? (n /= 2) : (n -= 14);
                    this.name = "C" + n + "h";
                }
            }
            catch (Exception exception) {
                this.name = "??";
            }
        }
        Logger.info("Point group found: " + this.name);
        return true;
    }

    private Operation setPrincipalAxis(int n, int n2) {
        Operation operation = this.setPrincipalPlane(n, n2);
        if (n2 == 0 && n < 14 || this.nAxes[n] == 1) {
            if (n2 > 0 && n < 14) {
                n = 14 + n / 2;
            }
            return this.axes[n][0];
        }
        if (operation == null) {
            return null;
        }
        int n3 = 0;
        while (n3 < this.nAxes[16]) {
            if (this.isParallel(operation.normalOrAxis, this.axes[16][n3].normalOrAxis)) {
                if (n3 != 0) {
                    Operation operation2 = this.axes[16][0];
                    this.axes[16][0] = this.axes[16][n3];
                    this.axes[16][n3] = operation2;
                }
                return this.axes[16][0];
            }
            ++n3;
        }
        return null;
    }

    private Operation setPrincipalPlane(int n, int n2) {
        if (n2 == 1) {
            this.principalPlane = this.axes[0][0];
            return this.principalPlane;
        }
        if (n2 == 0 || n2 == n - 14) {
            return null;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            while (n4 < n2) {
                if (this.isPerpendicular(this.axes[0][n3].normalOrAxis, this.axes[0][n4].normalOrAxis) && ++n5 > 2) {
                    if (n3 != 0) {
                        Operation operation = this.axes[0][0];
                        this.axes[0][0] = this.axes[0][n3];
                        this.axes[0][n3] = operation;
                    }
                    this.principalPlane = this.axes[0][0];
                    return this.principalPlane;
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    private boolean getPointsAndElements(T3[] t3Array) {
        Object object;
        int n = this.bsAtoms.cardinality();
        if (this.isAtoms && n > 100) {
            return false;
        }
        this.points = new P3[n];
        this.elements = new int[n];
        if (n == 0) {
            return true;
        }
        int n2 = 0;
        int n3 = this.bsAtoms.nextSetBit(0);
        while (n3 >= 0) {
            object = t3Array[n3];
            if (object instanceof Node) {
                n2 = Math.max(n2, ((Point3fi)object).i);
            }
            n3 = this.bsAtoms.nextSetBit(n3 + 1);
        }
        this.atomMap = new int[n2 + 1];
        this.nAtoms = 0;
        int n4 = n3 = this.center == null ? 1 : 0;
        if (n3 != 0) {
            this.center = new P3();
        }
        object = new Bspt(3, 0);
        int n5 = this.bsAtoms.nextSetBit(0);
        while (n5 >= 0) {
            this.points[this.nAtoms] = t3Array[n5];
            T3 t3 = this.points[this.nAtoms];
            if (t3 instanceof Node) {
                int n6 = this.localEnvOnly ? 1 : 1 + Math.max(3, ((Node)((Object)t3)).getCovalentBondCount());
                this.elements[this.nAtoms] = ((Node)((Object)t3)).getElementNumber() * n6;
                this.atomMap[((Point3fi)t3).i] = this.nAtoms + 1;
            } else if (t3 instanceof Point3fi) {
                this.elements[this.nAtoms] = Math.max(0, ((Point3fi)t3).sD);
            } else {
                Point3fi point3fi = new Point3fi();
                point3fi.setT(t3);
                point3fi.i = this.nAtoms;
                t3 = point3fi;
            }
            ((Bspt)object).addTuple(t3);
            if (n3 != 0) {
                this.center.add(this.points[this.nAtoms]);
            }
            n5 = this.bsAtoms.nextSetBit(n5 + 1);
            ++this.nAtoms;
        }
        this.iter = ((Bspt)object).allocateCubeIterator();
        if (n3 != 0) {
            this.center.scale(1.0f / (float)this.nAtoms);
        }
        n5 = this.nAtoms;
        while (--n5 >= 0) {
            float f = this.center.distanceSquared(this.points[n5]);
            if (this.isAtoms && f < this.distanceTolerance2) {
                this.centerAtomIndex = n5;
            }
            this.radius = Math.max(this.radius, f);
        }
        this.radius = (float)Math.sqrt(this.radius);
        if (this.radius < 1.5f && this.distanceTolerance > 0.15f) {
            this.distanceTolerance = this.radius / 10.0f;
            this.distanceTolerance2 = this.distanceTolerance * this.distanceTolerance;
            System.out.println("PointGroup calculation adjusting distanceTolerance to " + this.distanceTolerance);
        }
        return true;
    }

    private void findInversionCenter() {
        this.haveInversionCenter = this.checkOperation(null, this.center, -1);
        if (this.haveInversionCenter) {
            this.axes[1] = new Operation[1];
            this.axes[1][0] = new Operation();
        }
    }

    private boolean checkOperation(Quat quat, T3 t3, int n) {
        P3 p3 = new P3();
        int n2 = 0;
        boolean bl = n < 14;
        int n3 = this.points.length;
        block0: while (--n3 >= 0 && n2 < this.points.length) {
            if (n3 == this.centerAtomIndex) continue;
            T3 t32 = this.points[n3];
            int n4 = this.elements[n3];
            if (quat != null) {
                p3.sub2(t32, t3);
                quat.transform2(p3, p3).add(t3);
            } else {
                p3.setT(t32);
            }
            if (bl) {
                this.vTemp.sub2(t3, p3);
                p3.scaleAdd2(2.0f, this.vTemp, p3);
            }
            if ((quat != null || bl) && p3.distanceSquared(t32) < this.distanceTolerance2) {
                ++n2;
                continue;
            }
            this.iter.initialize(p3, this.distanceTolerance, false);
            while (this.iter.hasMoreElements()) {
                T3 t33 = this.iter.nextElement();
                if (t33 == t32) continue;
                int n5 = this.getPointIndex(((Point3fi)t33).i);
                if (this.centerAtomIndex >= 0 && n5 == this.centerAtomIndex || this.elements[n5] != n4 || !(p3.distanceSquared(t33) < this.distanceTolerance2)) continue;
                ++n2;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private int getPointIndex(int n) {
        return n < this.atomMap.length && this.atomMap[n] > 0 ? this.atomMap[n] - 1 : n;
    }

    private boolean isLinear(T3[] t3Array) {
        V3 v3 = null;
        if (t3Array.length < 2) {
            return false;
        }
        int n = t3Array.length;
        while (--n >= 0) {
            if (n == this.centerAtomIndex) continue;
            if (v3 == null) {
                v3 = new V3();
                v3.sub2(t3Array[n], this.center);
                v3.normalize();
                this.vTemp.setT(v3);
                continue;
            }
            this.vTemp.sub2(t3Array[n], this.center);
            this.vTemp.normalize();
            if (this.isParallel(v3, this.vTemp)) continue;
            return false;
        }
        return true;
    }

    private boolean isParallel(V3 v3, V3 v32) {
        return Math.abs(v3.dot(v32)) >= this.cosTolerance;
    }

    private boolean isPerpendicular(V3 v3, V3 v32) {
        return Math.abs(v3.dot(v32)) <= 1.0f - this.cosTolerance;
    }

    private void getElementCounts() {
        int n = this.points.length;
        while (--n >= 0) {
            int n2 = this.elements[n];
            if (n2 <= this.maxElement) continue;
            this.maxElement = n2;
        }
        this.eCounts = new int[++this.maxElement];
        n = this.points.length;
        while (--n >= 0) {
            int n3 = this.elements[n];
            this.eCounts[n3] = this.eCounts[n3] + 1;
        }
    }

    private int findCAxes() {
        int n;
        int n2;
        int n3;
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        int n4 = this.points.length;
        while (--n4 >= 0) {
            if (n4 == this.centerAtomIndex) continue;
            T3 t3 = this.points[n4];
            n3 = this.elements[n4];
            n2 = this.points.length;
            while (--n2 > n4) {
                float f;
                boolean bl;
                T3 t32 = this.points[n2];
                if (this.elements[n2] != n3) continue;
                v3.sub2(t3, this.center);
                v32.sub2(t32, this.center);
                v3.normalize();
                v32.normalize();
                if (this.isParallel(v3, v32)) {
                    this.getAllAxes(v3);
                    continue;
                }
                if (this.nAxes[16] < axesMaxN[16]) {
                    v33.ave(t3, t32);
                    v33.sub(this.center);
                    this.getAllAxes(v33);
                }
                boolean bl2 = bl = (f = (float)(Math.PI * 2 / (double)v3.angle(v32))) - (float)(n = (int)Math.floor(f + 0.01f)) <= 0.02f;
                if (!bl || (n += 14) >= maxAxis || this.nAxes[n] >= axesMaxN[n]) continue;
                v33.cross(v3, v32);
                this.checkAxisOrder(n, v33, this.center);
            }
        }
        V3[] v3Array = new V3[this.nAxes[16] * 2];
        int n5 = 0;
        while (n5 < v3Array.length) {
            v3Array[n5] = new V3();
            ++n5;
        }
        n5 = 0;
        n3 = 0;
        while (n3 < this.nAxes[16]) {
            v3Array[n5++].setT(this.axes[16][n3].normalOrAxis);
            v3Array[n5].setT(this.axes[16][n3].normalOrAxis);
            v3Array[n5++].scale(-1.0f);
            ++n3;
        }
        n3 = v3Array.length;
        while (--n3 >= 2) {
            n2 = n3;
            while (--n2 >= 1) {
                int n6 = n2;
                while (--n6 >= 0) {
                    v33.add2(v3Array[n3], v3Array[n2]);
                    v33.add(v3Array[n6]);
                    if ((double)v33.length() < 1.0) continue;
                    this.checkAxisOrder(17, v33, this.center);
                }
            }
        }
        n3 = Integer.MAX_VALUE;
        n2 = -1;
        int n7 = 0;
        while (n7 < this.maxElement) {
            if (this.eCounts[n7] < n3 && this.eCounts[n7] > 2) {
                n3 = this.eCounts[n7];
                n2 = n7;
            }
            ++n7;
        }
        n7 = 0;
        block8: while (n7 < this.points.length - 2) {
            if (this.elements[n7] == n2) {
                int n8 = n7 + 1;
                while (n8 < this.points.length - 1) {
                    if (this.elements[n8] == n2) {
                        n = n8 + 1;
                        while (n < this.points.length) {
                            if (this.elements[n] == n2) {
                                v3.sub2(this.points[n7], this.points[n8]);
                                v32.sub2(this.points[n7], this.points[n]);
                                v3.normalize();
                                v32.normalize();
                                v33.cross(v3, v32);
                                this.getAllAxes(v33);
                                v3.add2(this.points[n7], this.points[n8]);
                                v3.add(this.points[n]);
                                v3.normalize();
                                if (!this.isParallel(v3, v33)) {
                                    this.getAllAxes(v3);
                                }
                                if (this.nAxes[19] == axesMaxN[19]) break block8;
                            }
                            ++n;
                        }
                    }
                    ++n8;
                }
            }
            ++n7;
        }
        v3Array = new V3[this.maxElement];
        n7 = this.points.length;
        while (--n7 >= 0) {
            int n9 = this.elements[n7];
            if (v3Array[n9] == null) {
                v3Array[n9] = new V3();
            } else if (this.haveInversionCenter) continue;
            v3Array[n9].add(this.points[n7]);
        }
        if (!this.haveInversionCenter) {
            n7 = 0;
            while (n7 < this.maxElement) {
                if (v3Array[n7] != null) {
                    v3Array[n7].scale(1.0f / (float)this.eCounts[n7]);
                }
                ++n7;
            }
        }
        n7 = 0;
        while (n7 < this.maxElement) {
            if (v3Array[n7] != null) {
                int n10 = 0;
                while (n10 < this.maxElement) {
                    if (n7 != n10 && v3Array[n10] != null) {
                        if (this.haveInversionCenter) {
                            v3.cross(v3Array[n7], v3Array[n10]);
                        } else {
                            v3.sub2(v3Array[n7], v3Array[n10]);
                        }
                        this.checkAxisOrder(16, v3, this.center);
                    }
                    ++n10;
                }
            }
            ++n7;
        }
        return this.getHighestOrder();
    }

    private void getAllAxes(V3 v3) {
        int n = 16;
        while (n < maxAxis) {
            if (this.nAxes[n] < axesMaxN[n]) {
                this.checkAxisOrder(n, v3, this.center);
            }
            ++n;
        }
    }

    private int getHighestOrder() {
        int n = 0;
        n = 14;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        if (n > 1) {
            return n + 14 < maxAxis && this.nAxes[n + 14] > 0 ? n + 14 : n;
        }
        n = maxAxis;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        return n;
    }

    private boolean checkAxisOrder(int n, V3 v3, T3 t3) {
        switch (n) {
            case 22: {
                if (this.nAxes[17] > 0) {
                    return false;
                }
            }
            case 18: 
            case 20: {
                if (this.nAxes[19] <= 0) break;
                return false;
            }
            case 17: {
                if (this.nAxes[22] <= 0) break;
                return false;
            }
            case 19: {
                if (this.nAxes[18] <= 0 && this.nAxes[20] <= 0 && this.nAxes[22] <= 0) break;
                return false;
            }
        }
        v3.normalize();
        if (this.haveAxis(n, v3)) {
            return false;
        }
        Quat quat = Quat.newVA(v3, (n < 14 ? 180 : 0) + 360 / (n % 14));
        if (!this.checkOperation(quat, t3, n)) {
            return false;
        }
        this.addAxis(n, v3);
        switch (n) {
            case 16: {
                this.checkAxisOrder(4, v3, t3);
                break;
            }
            case 17: {
                this.checkAxisOrder(3, v3, t3);
                if (!this.haveInversionCenter) break;
                this.addAxis(6, v3);
                break;
            }
            case 18: {
                this.addAxis(16, v3);
                this.checkAxisOrder(4, v3, t3);
                this.checkAxisOrder(8, v3, t3);
                break;
            }
            case 19: {
                this.checkAxisOrder(5, v3, t3);
                if (!this.haveInversionCenter) break;
                this.addAxis(10, v3);
                break;
            }
            case 20: {
                this.addAxis(16, v3);
                this.addAxis(17, v3);
                this.checkAxisOrder(3, v3, t3);
                this.checkAxisOrder(6, v3, t3);
                this.checkAxisOrder(12, v3, t3);
                break;
            }
            case 22: {
                this.addAxis(16, v3);
                this.addAxis(18, v3);
            }
        }
        return true;
    }

    private void addAxis(int n, V3 v3) {
        if (this.haveAxis(n, v3)) {
            return;
        }
        if (this.axes[n] == null) {
            this.axes[n] = new Operation[axesMaxN[n]];
        }
        int n2 = n;
        int n3 = this.nAxes[n2];
        this.nAxes[n2] = n3 + 1;
        this.axes[n][n3] = new Operation(v3, n);
    }

    private boolean haveAxis(int n, V3 v3) {
        if (this.nAxes[n] == axesMaxN[n]) {
            return true;
        }
        if (this.nAxes[n] > 0) {
            int n2 = this.nAxes[n];
            while (--n2 >= 0) {
                if (!this.isParallel(v3, this.axes[n][n2].normalOrAxis)) continue;
                return true;
            }
        }
        return false;
    }

    private int findPlanes() {
        P3 p3 = new P3();
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        int n = 0;
        boolean bl = this.getHighestOrder() > 1;
        int n2 = this.points.length;
        while (--n2 >= 0) {
            if (n2 == this.centerAtomIndex) continue;
            T3 t3 = this.points[n2];
            int n3 = this.elements[n2];
            int n4 = this.points.length;
            while (--n4 > n2) {
                if (bl && this.elements[n4] != n3) continue;
                T3 t32 = this.points[n4];
                p3.add2(t3, t32);
                p3.scale(0.5f);
                v3.sub2(t3, this.center);
                v32.sub2(t32, this.center);
                if (!this.isParallel(v3, v32)) {
                    v33.cross(v3, v32);
                    v33.normalize();
                    n = this.getPlane(v33);
                }
                v33.sub2(t32, t3);
                v33.normalize();
                n = this.getPlane(v33);
                if (n != axesMaxN[0]) continue;
                return n;
            }
        }
        if (bl) {
            n2 = 16;
            while (n2 < maxAxis) {
                int n5 = 0;
                while (n5 < this.nAxes[n2]) {
                    n = this.getPlane(this.axes[n2][n5].normalOrAxis);
                    ++n5;
                }
                ++n2;
            }
        }
        return n;
    }

    private int getPlane(V3 v3) {
        if (!this.haveAxis(0, v3) && this.checkOperation(Quat.newVA(v3, 180.0f), this.center, -1)) {
            int n = this.nAxes[0];
            this.nAxes[0] = n + 1;
            this.axes[0][n] = new Operation(v3);
        }
        return this.nAxes[0];
    }

    private void findAdditionalAxes(int n) {
        Operation[] operationArray = this.axes[0];
        int n2 = 0;
        if (n > 1 && (n2 = n + 14) < maxAxis && this.nAxes[n2] == 0) {
            this.vTemp.cross(operationArray[0].normalOrAxis, operationArray[1].normalOrAxis);
            if (!this.checkAxisOrder(n2, this.vTemp, this.center) && n > 2) {
                this.vTemp.cross(operationArray[1].normalOrAxis, operationArray[2].normalOrAxis);
                this.checkAxisOrder(n2 - 1, this.vTemp, this.center);
            }
        }
        if (this.nAxes[16] == 0 && n > 2) {
            int n3 = 0;
            while (n3 < n - 1) {
                int n4 = n3 + 1;
                while (n4 < n) {
                    this.vTemp.add2(operationArray[1].normalOrAxis, operationArray[2].normalOrAxis);
                    this.checkAxisOrder(16, this.vTemp, this.center);
                    ++n4;
                }
                ++n3;
            }
        }
    }

    Object getInfo(int n, String string, boolean bl, String string2, int n2, float f) {
        String string3;
        int n3;
        boolean bl2 = string != null;
        this.info = bl ? new Hashtable() : null;
        V3 v3 = new V3();
        if (f == 0.0f) {
            f = 1.0f;
        }
        this.scale = f;
        int[][] nArray = new int[4][2];
        int n4 = 1;
        while (n4 < maxAxis) {
            n3 = this.nAxes[n4];
            while (--n3 >= 0) {
                int[] nArray2 = nArray[this.axes[n4][n3].type];
                nArray2[0] = nArray2[0] + 1;
            }
            ++n4;
        }
        SB sB = new SB().append("# ").appendI(this.nAtoms).append(" atoms\n");
        if (bl2) {
            Operation operation;
            string = "draw " + string;
            n3 = string2 != null && string2.length() > 0 ? 1 : 0;
            string2 = n3 != 0 ? string2 : "";
            this.drawType = string2;
            this.drawIndex = n2;
            boolean bl3 = string2.equalsIgnoreCase("Cn");
            boolean bl4 = string2.equalsIgnoreCase("Sn");
            sB.append("set perspectivedepth off;\n");
            String string4 = "_" + n + "_";
            if (n3 == 0) {
                sB.append(String.valueOf(string) + "pg0").append(string4).append("* delete;draw pgva").append(string4).append("* delete;draw pgvp").append(string4).append("* delete;");
            }
            if (n3 == 0 || string2.equalsIgnoreCase("Ci")) {
                sB.append(String.valueOf(string) + "pg0").append(string4).append(this.haveInversionCenter ? "inv " : " ").append(Escape.eP(this.center)).append(this.haveInversionCenter ? "\"i\";\n" : ";\n");
            }
            float f2 = 0.1f;
            int n5 = 2;
            while (n5 < maxAxis) {
                if (n5 == 14) {
                    f2 = 0.1f;
                }
                if (this.nAxes[n5] != 0) {
                    String string5 = this.axes[n5][0].getLabel();
                    float f3 = f * this.radius + (f2 += 0.25f);
                    if (n3 == 0 || string2.equalsIgnoreCase(string5) || bl3 && n5 >= 14 || bl4 && n5 < 14) {
                        int n6 = 0;
                        while (n6 < this.nAxes[n5]) {
                            if (n2 <= 0 || n6 + 1 == n2) {
                                operation = this.axes[n5][n6];
                                v3.add2(operation.normalOrAxis, this.center);
                                if (operation.type == 2) {
                                    f3 = -f3;
                                }
                                sB.append(String.valueOf(string) + "pgva").append(string4).append(string5).append("_").appendI(n6 + 1).append(" width 0.05 scale ").appendF(f3).append(" ").append(Escape.eP(v3));
                                v3.scaleAdd2(-2.0f, operation.normalOrAxis, v3);
                                boolean bl5 = this.principalAxis != null && operation.index == this.principalAxis.index;
                                sB.append(Escape.eP(v3)).append("\"").append(string5).append(bl5 ? "*" : "").append("\" color ").append(bl5 ? "red" : (operation.type == 2 ? "blue" : "orange")).append(";\n");
                            }
                            ++n6;
                        }
                    }
                }
                ++n5;
            }
            if (n3 == 0 || string2.equalsIgnoreCase("Cs")) {
                n5 = 0;
                while (n5 < this.nAxes[0]) {
                    if (n2 <= 0 || n5 + 1 == n2) {
                        operation = this.axes[0][n5];
                        sB.append(String.valueOf(string) + "pgvp").append(string4).appendI(n5 + 1).append("disk scale ").appendF(f * this.radius * 2.0f).append(" CIRCLE PLANE ").append(Escape.eP(this.center));
                        v3.add2(operation.normalOrAxis, this.center);
                        sB.append(Escape.eP(v3)).append(" color translucent yellow;\n");
                        v3.add2(operation.normalOrAxis, this.center);
                        sB.append(String.valueOf(string) + "pgvp").append(string4).appendI(n5 + 1).append("ring width 0.05 scale ").appendF(f * this.radius * 2.0f).append(" arc ").append(Escape.eP(v3));
                        v3.scaleAdd2(-2.0f, operation.normalOrAxis, v3);
                        sB.append(Escape.eP(v3));
                        v3.add3(0.011f, 0.012f, 0.013f);
                        sB.append(Escape.eP(v3)).append("{0 360 0.5} color ").append(this.principalPlane != null && operation.index == this.principalPlane.index ? "red" : "blue").append(";\n");
                    }
                    ++n5;
                }
            }
            sB.append("# name=").append(this.name);
            sB.append(", nCi=").appendI(this.haveInversionCenter ? 1 : 0);
            sB.append(", nCs=").appendI(this.nAxes[0]);
            sB.append(", nCn=").appendI(nArray[1][0]);
            sB.append(", nSn=").appendI(nArray[2][0]);
            sB.append(": ");
            n5 = maxAxis;
            while (--n5 >= 2) {
                if (this.nAxes[n5] <= 0) continue;
                sB.append(" n").append(n5 < 14 ? "S" : "C").appendI(n5 % 14);
                sB.append("=").appendI(this.nAxes[n5]);
            }
            sB.append(";\n");
            sB.append("print '" + this.name + "';\n");
            this.drawInfo = sB.toString();
            if (Logger.debugging) {
                Logger.info(this.drawInfo);
            }
            return this.drawInfo;
        }
        n3 = 0;
        int n7 = 1;
        String string6 = string3 = this.haveInversionCenter ? "Ci" : "center";
        if (this.haveInversionCenter) {
            ++n7;
        }
        if (bl) {
            this.info.put(string3, this.center);
        } else {
            sB.append("\n\n").append(this.name).append("\t").append(string3).append("\t").append(Escape.eP(this.center));
        }
        int n8 = maxAxis;
        while (--n8 >= 0) {
            if (this.nAxes[n8] <= 0) continue;
            n3 = nUnique[n8];
            String string7 = this.axes[n8][0].getLabel();
            if (bl) {
                this.info.put("n" + string7, this.nAxes[n8]);
            } else {
                sB.append("\n\n").append(this.name).append("\tn").append(string7).append("\t").appendI(this.nAxes[n8]).append("\t").appendI(n3);
            }
            n7 += (n3 *= this.nAxes[n8]);
            int[] nArray3 = nArray[this.axes[n8][0].type];
            nArray3[1] = nArray3[1] + n3;
            Lst<V3> lst = bl ? new Lst<V3>() : null;
            int n9 = 0;
            while (n9 < this.nAxes[n8]) {
                if (bl) {
                    lst.addLast(this.axes[n8][n9].normalOrAxis);
                } else {
                    sB.append("\n").append(this.name).append("\t").append(string7).append("_").appendI(n9 + 1).append("\t").appendO(this.axes[n8][n9].normalOrAxis);
                }
                ++n9;
            }
            if (!bl) continue;
            this.info.put(string7, lst);
        }
        if (!bl) {
            sB.append("\n");
            sB.append("\n").append(this.name).append("\ttype\tnType\tnUnique");
            sB.append("\n").append(this.name).append("\tE\t  1\t  1");
            n3 = this.haveInversionCenter ? 1 : 0;
            sB.append("\n").append(this.name).append("\tCi\t  ").appendI(n3).append("\t  ").appendI(n3);
            sB.append("\n").append(this.name).append("\tCs\t");
            PT.rightJustify(sB, "    ", String.valueOf(this.nAxes[0]) + "\t");
            PT.rightJustify(sB, "    ", String.valueOf(this.nAxes[0]) + "\n");
            sB.append(this.name).append("\tCn\t");
            PT.rightJustify(sB, "    ", String.valueOf(nArray[1][0]) + "\t");
            PT.rightJustify(sB, "    ", String.valueOf(nArray[1][1]) + "\n");
            sB.append(this.name).append("\tSn\t");
            PT.rightJustify(sB, "    ", String.valueOf(nArray[2][0]) + "\t");
            PT.rightJustify(sB, "    ", String.valueOf(nArray[2][1]) + "\n");
            sB.append(this.name).append("\t\tTOTAL\t");
            PT.rightJustify(sB, "    ", String.valueOf(n7) + "\n");
            this.textInfo = sB.toString();
            return this.textInfo;
        }
        this.info.put("name", this.name);
        this.info.put("nAtoms", this.nAtoms);
        this.info.put("nTotal", n7);
        this.info.put("nCi", this.haveInversionCenter ? 1 : 0);
        this.info.put("nCs", this.nAxes[0]);
        this.info.put("nCn", nArray[1][0]);
        this.info.put("nSn", nArray[2][0]);
        this.info.put("distanceTolerance", Float.valueOf(this.distanceTolerance));
        this.info.put("linearTolerance", Float.valueOf(this.linearTolerance));
        this.info.put("points", this.points);
        this.info.put("detail", sB.toString().replace('\n', ';'));
        if (this.principalAxis != null && this.principalAxis.index > 0) {
            this.info.put("principalAxis", this.principalAxis.normalOrAxis);
        }
        if (this.principalPlane != null && this.principalPlane.index > 0) {
            this.info.put("principalPlane", this.principalPlane.normalOrAxis);
        }
        return this.info;
    }

    boolean isDrawType(String string, int n, float f) {
        return this.drawInfo != null && this.drawType.equals(string == null ? "" : string) && this.drawIndex == n && this.scale == f;
    }

    private class Operation {
        int type;
        int order;
        int index;
        V3 normalOrAxis;

        Operation() {
            this.index = ++PointGroup.this.nOps;
            this.type = 3;
            this.order = 1;
            if (Logger.debugging) {
                Logger.debug("new operation -- " + typeNames[this.type]);
            }
        }

        Operation(V3 v3, int n) {
            this.index = ++PointGroup.this.nOps;
            this.type = n < 14 ? 2 : 1;
            this.order = n % 14;
            this.normalOrAxis = Quat.newVA(v3, 180.0f).getNormal();
            if (Logger.debugging) {
                Logger.debug("new operation -- " + (this.order == n ? "S" : "C") + this.order + " " + this.normalOrAxis);
            }
        }

        Operation(V3 v3) {
            if (v3 == null) {
                return;
            }
            this.index = ++PointGroup.this.nOps;
            this.type = 0;
            this.normalOrAxis = Quat.newVA(v3, 180.0f).getNormal();
            if (Logger.debugging) {
                Logger.debug("new operation -- plane " + this.normalOrAxis);
            }
        }

        String getLabel() {
            switch (this.type) {
                case 0: {
                    return "Cs";
                }
                case 2: {
                    return "S" + this.order;
                }
            }
            return "C" + this.order;
        }
    }
}

