/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class PostDownloadHandler
implements Runnable {
    private final DownloadTask task;
    private final Future<?> future;
    private Consumer<Collection<Object>> errorReporter;

    public PostDownloadHandler(DownloadTask task, Future<?> future) {
        this.task = task;
        this.future = future;
    }

    public PostDownloadHandler(DownloadTask task, Future<?> future, Consumer<Collection<Object>> errorReporter) {
        this(task, future);
        this.errorReporter = errorReporter;
    }

    @Override
    public void run() {
        try {
            this.future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            Logging.error(e);
            return;
        }
        LinkedHashSet<Object> errors = new LinkedHashSet<Object>(this.task.getErrorObjects());
        if (this.errorReporter != null) {
            GuiHelper.runInEDT(() -> this.errorReporter.accept(errors));
        }
        if (errors.isEmpty()) {
            return;
        }
        if (errors.size() == 1) {
            Object error = errors.iterator().next();
            if (!GraphicsEnvironment.isHeadless()) {
                SwingUtilities.invokeLater(() -> {
                    if (error instanceof Exception) {
                        ExceptionDialogUtil.explainException((Exception)error);
                    } else if (I18n.tr("No data found in this area.", new Object[0]).equals(error)) {
                        new Notification(error.toString()).setIcon(2).show();
                    } else {
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), error.toString(), I18n.tr("Error during download", new Object[0]), 0);
                    }
                });
            }
            return;
        }
        if (!errors.isEmpty()) {
            ArrayList<String> items = new ArrayList<String>();
            for (Object e : errors) {
                if (e instanceof String) {
                    items.add((String)e);
                    continue;
                }
                if (!(e instanceof Exception)) continue;
                items.add(ExceptionUtil.explainException((Exception)e));
            }
            if (!GraphicsEnvironment.isHeadless()) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), "<html>" + Utils.joinAsHtmlUnorderedList(items) + "</html>", I18n.tr("Errors during download", new Object[0]), 0));
            }
        }
    }
}

