/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.structure;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/contracts/model/structure/ESConstants;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "falseValue", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "getFalseValue", "()Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "notNullValue", "getNotNullValue", "nullValue", "getNullValue", "trueValue", "getTrueValue", "wildcard", "getWildcard", "booleanValue", "value", "", "resolution"})
public final class ESConstants {
    @NotNull
    private final ESConstant trueValue;
    @NotNull
    private final ESConstant falseValue;
    @NotNull
    private final ESConstant nullValue;
    @NotNull
    private final ESConstant notNullValue;
    @NotNull
    private final ESConstant wildcard;

    @NotNull
    public final ESConstant getTrueValue() {
        return this.trueValue;
    }

    @NotNull
    public final ESConstant getFalseValue() {
        return this.falseValue;
    }

    @NotNull
    public final ESConstant getNullValue() {
        return this.nullValue;
    }

    @NotNull
    public final ESConstant getNotNullValue() {
        return this.notNullValue;
    }

    @NotNull
    public final ESConstant getWildcard() {
        return this.wildcard;
    }

    @NotNull
    public final ESConstant booleanValue(boolean value) {
        return value ? this.trueValue : this.falseValue;
    }

    public ESConstants(@NotNull KotlinBuiltIns builtIns2) {
        Intrinsics.checkParameterIsNotNull(builtIns2, "builtIns");
        ConstantReference constantReference = BooleanConstantReference.Companion.getTRUE();
        SimpleType simpleType2 = builtIns2.getBooleanType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "builtIns.booleanType");
        this.trueValue = new ESConstant(constantReference, simpleType2);
        ConstantReference constantReference2 = BooleanConstantReference.Companion.getFALSE();
        SimpleType simpleType3 = builtIns2.getBooleanType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType3, "builtIns.booleanType");
        this.falseValue = new ESConstant(constantReference2, simpleType3);
        ConstantReference constantReference3 = ConstantReference.Companion.getNULL();
        SimpleType simpleType4 = builtIns2.getNullableNothingType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType4, "builtIns.nullableNothingType");
        this.nullValue = new ESConstant(constantReference3, simpleType4);
        ConstantReference constantReference4 = ConstantReference.Companion.getNOT_NULL();
        SimpleType simpleType5 = builtIns2.getAnyType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType5, "builtIns.anyType");
        this.notNullValue = new ESConstant(constantReference4, simpleType5);
        ConstantReference constantReference5 = ConstantReference.Companion.getWILDCARD();
        SimpleType simpleType6 = builtIns2.getNullableAnyType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType6, "builtIns.nullableAnyType");
        this.wildcard = new ESConstant(constantReference5, simpleType6);
    }
}

