/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TimeZone;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.gephi.desktop.datalab.DataTableTopComponent;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.ui.utils.TimeFormatWrapper;
import org.gephi.ui.utils.TimeRepresentationWrapper;
import org.gephi.ui.utils.TimeZoneWrapper;
import org.joda.time.DateTimeZone;
import org.openide.util.NbBundle;

public class ConfigurationPanel
extends JPanel {
    private final DataTableTopComponent dataTableTopComponent;
    private final GraphModel graphModel;
    private JCheckBox onlyVisibleCheckBox;
    private JCheckBox showEdgesNodesLabelsCheckBox;
    private JComboBox timeFormatComboBox;
    private JLabel timeFormatLabel;
    private JCheckBox timeIntervalsGraphicsCheckBox;
    private JComboBox timeRepresentationComboBox;
    private JLabel timeRepresentationLabel;
    private JComboBox timeZoneComboBox;
    private JLabel timeZoneLabel;
    private JCheckBox useSparklinesCheckBox;

    public ConfigurationPanel(final DataTableTopComponent dataTableTopComponent, final GraphModel graphModel) {
        this.dataTableTopComponent = dataTableTopComponent;
        this.graphModel = graphModel;
        this.initComponents();
        for (TimeFormat tf : TimeFormat.values()) {
            this.timeFormatComboBox.addItem(new TimeFormatWrapper(tf));
        }
        this.timeFormatComboBox.setSelectedItem(new TimeFormatWrapper(graphModel.getTimeFormat()));
        this.timeFormatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                graphModel.setTimeFormat(((TimeFormatWrapper)ConfigurationPanel.this.timeFormatComboBox.getSelectedItem()).getTimeFormat());
                dataTableTopComponent.refreshCurrentTable();
            }
        });
        this.onlyVisibleCheckBox.setSelected(dataTableTopComponent.isShowOnlyVisible());
        this.useSparklinesCheckBox.setSelected(dataTableTopComponent.isUseSparklines());
        this.timeIntervalsGraphicsCheckBox.setSelected(dataTableTopComponent.isTimeIntervalGraphics());
        this.showEdgesNodesLabelsCheckBox.setSelected(dataTableTopComponent.isShowEdgesNodesLabels());
        long currentTimestamp = System.currentTimeMillis();
        DateTimeZone currentTimeZone = graphModel.getTimeZone();
        this.buildTimeZoneList();
        this.timeZoneComboBox.setSelectedItem(new TimeZoneWrapper(currentTimeZone.toTimeZone(), currentTimestamp));
        this.timeZoneComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeZone selected = ((TimeZoneWrapper)ConfigurationPanel.this.timeZoneComboBox.getSelectedItem()).getTimeZone();
                graphModel.setTimeZone(DateTimeZone.forTimeZone((TimeZone)selected));
                dataTableTopComponent.refreshCurrentTable();
            }
        });
        for (TimeRepresentation tr : TimeRepresentation.values()) {
            this.timeRepresentationComboBox.addItem(new TimeRepresentationWrapper(tr));
        }
        this.timeRepresentationComboBox.setSelectedItem(new TimeRepresentationWrapper(graphModel.getConfiguration().getTimeRepresentation()));
        if (this.canChangeTimeRepresentation(graphModel)) {
            this.timeRepresentationComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configuration c = graphModel.getConfiguration();
                    c.setTimeRepresentation(((TimeRepresentationWrapper)ConfigurationPanel.this.timeRepresentationComboBox.getSelectedItem()).getTimeRepresentation());
                    graphModel.setConfiguration(c);
                }
            });
        } else {
            this.timeRepresentationComboBox.setEnabled(false);
            this.timeRepresentationComboBox.setToolTipText(NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.timeRepresentation.disabled.tooltip"));
        }
    }

    private boolean canChangeTimeRepresentation(GraphModel graphModel) {
        String id;
        if (graphModel.getGraph().getNodeCount() > 0) {
            return false;
        }
        for (Column column : graphModel.getNodeTable()) {
            id = column.getId();
            if (id.equalsIgnoreCase("Id") || id.equalsIgnoreCase("Label") || id.equalsIgnoreCase("timeset")) continue;
            return false;
        }
        for (Column column : graphModel.getEdgeTable()) {
            id = column.getId();
            if (id.equalsIgnoreCase("Id") || id.equalsIgnoreCase("Label") || id.equalsIgnoreCase("timeset") || id.equalsIgnoreCase("Weight")) continue;
            return false;
        }
        return true;
    }

    private void buildTimeZoneList() {
        long currentTimestamp = System.currentTimeMillis();
        for (String id : TimeZone.getAvailableIDs()) {
            this.timeZoneComboBox.addItem(new TimeZoneWrapper(TimeZone.getTimeZone(id), currentTimestamp));
        }
    }

    private void initComponents() {
        this.onlyVisibleCheckBox = new JCheckBox();
        this.useSparklinesCheckBox = new JCheckBox();
        this.showEdgesNodesLabelsCheckBox = new JCheckBox();
        this.timeIntervalsGraphicsCheckBox = new JCheckBox();
        this.timeFormatComboBox = new JComboBox();
        this.timeFormatLabel = new JLabel();
        this.timeZoneLabel = new JLabel();
        this.timeZoneComboBox = new JComboBox();
        this.timeRepresentationLabel = new JLabel();
        this.timeRepresentationComboBox = new JComboBox();
        this.onlyVisibleCheckBox.setText(NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.onlyVisibleCheckBox.text"));
        this.onlyVisibleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.onlyVisibleCheckBoxActionPerformed(evt);
            }
        });
        this.useSparklinesCheckBox.setText(NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.useSparklinesCheckBox.text"));
        this.useSparklinesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.useSparklinesCheckBoxActionPerformed(evt);
            }
        });
        this.showEdgesNodesLabelsCheckBox.setText(NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.showEdgesNodesLabelsCheckBox.text"));
        this.showEdgesNodesLabelsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.showEdgesNodesLabelsCheckBoxActionPerformed(evt);
            }
        });
        this.timeIntervalsGraphicsCheckBox.setText(NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.timeIntervalsGraphicsCheckBox.text"));
        this.timeIntervalsGraphicsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.timeIntervalsGraphicsCheckBoxActionPerformed(evt);
            }
        });
        this.timeFormatLabel.setText(NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.timeFormatLabel.text"));
        this.timeZoneLabel.setText(NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.timeZoneLabel.text"));
        this.timeRepresentationLabel.setText(NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.timeRepresentationLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showEdgesNodesLabelsCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.timeIntervalsGraphicsCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.useSparklinesCheckBox, -1, 321, Short.MAX_VALUE).addComponent(this.onlyVisibleCheckBox, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeFormatLabel, -2, 96, -2).addComponent(this.timeZoneLabel, -2, 106, -2).addComponent(this.timeRepresentationLabel, -2, 132, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeRepresentationComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.timeFormatComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.timeZoneComboBox, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.onlyVisibleCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useSparklinesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.timeIntervalsGraphicsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showEdgesNodesLabelsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeFormatLabel).addComponent(this.timeFormatComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeZoneLabel).addComponent(this.timeZoneComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeRepresentationLabel).addComponent(this.timeRepresentationComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void onlyVisibleCheckBoxActionPerformed(ActionEvent evt) {
        this.dataTableTopComponent.setShowOnlyVisible(this.onlyVisibleCheckBox.isSelected());
    }

    private void useSparklinesCheckBoxActionPerformed(ActionEvent evt) {
        this.dataTableTopComponent.setUseSparklines(this.useSparklinesCheckBox.isSelected());
    }

    private void timeIntervalsGraphicsCheckBoxActionPerformed(ActionEvent evt) {
        this.dataTableTopComponent.setTimeIntervalGraphics(this.timeIntervalsGraphicsCheckBox.isSelected());
    }

    private void showEdgesNodesLabelsCheckBoxActionPerformed(ActionEvent evt) {
        this.dataTableTopComponent.setShowEdgesNodesLabels(this.showEdgesNodesLabelsCheckBox.isSelected());
    }
}

