/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ga extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Am L\u00e1r na hAfraice",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Am Caighde\u00e1nach Mhosc\u00f3",
               "MSK",
               "Am Samhraidh Mhosc\u00f3",
               "MSD",
               "Am Mhosc\u00f3",
               "MT",
            };
        final String[] Japan = new String[] {
               "Am Caighde\u00e1nach na Seap\u00e1ine",
               "JST",
               "Am Samhraidh na Seap\u00e1ine",
               "JDT",
               "Am na Seap\u00e1ine",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Am Caighde\u00e1nach na Pacast\u00e1ine",
               "PKT",
               "Am Samhraidh na Pacast\u00e1ine",
               "PKST",
               "Am na Pacast\u00e1ine",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Am Caighde\u00e1nach Thaipei",
               "CST",
               "Am Samhraidh Thaipei",
               "CDT",
               "Am Thaipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Am Caighde\u00e1nach Hovd",
               "HOVT",
               "Am Samhraidh Hovd",
               "HOVST",
               "Am Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Am Caighde\u00e1nach Mhagadan",
               "MAGT",
               "Am Samhraidh Mhagadan",
               "MAGST",
               "Am Mhagadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Am Caighde\u00e1nach Mhe\u00e1niarthar na hAstr\u00e1ile",
               "ACWST",
               "Am Samhraidh Mhe\u00e1niarthar na hAstr\u00e1ile",
               "ACWDT",
               "Am Mhe\u00e1niarthar na hAstr\u00e1ile",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Am Caighde\u00e1nach L\u00e1r na hEorpa",
               "CET",
               "Am Samhraidh L\u00e1r na hEorpa",
               "CEST",
               "Am L\u00e1r na hEorpa",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Am Caighde\u00e1nach Shakhalin",
               "SAKT",
               "Am Samhraidh Shakhalin",
               "SAKST",
               "Am Shakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Am Caighde\u00e1nach Pharagua",
               "PYT",
               "Am Samhraidh Pharagua",
               "PYST",
               "Am Pharagua",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Am Caighde\u00e1nach Acre",
               "ACT",
               "Am Samhraidh Acre",
               "ACST",
               "Am Acre",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Am na Malaeisia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Am Caighde\u00e1nach an Oirthir",
               "EST",
               "Am Samhraidh an Oirthir",
               "EDT",
               "Am an Oirthir",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Am Caighde\u00e1nach Lord Howe",
               "LHST",
               "Am Samhraidh Lord Howe",
               "LHDT",
               "Am Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Am Caighde\u00e1nach na Nua-Sh\u00e9alainne",
               "NZST",
               "Am Samhraidh na Nua-Sh\u00e9alainne",
               "NZDT",
               "Am na Nua-Sh\u00e9alainne",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Am an Aig\u00e9in Indiaigh",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Am Caighde\u00e1nach Iac\u00fatsc",
               "YAKT",
               "Am Samhraidh Iac\u00fatsc",
               "YAKST",
               "Am Iac\u00fatsc",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1n Mhuir\u00eds",
               "MUT",
               "Am Samhraidh Oile\u00e1n Mhuir\u00eds",
               "MUST",
               "Am Oile\u00e1n Mhuir\u00eds",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Am Oirthear na hAfraice",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Am Th\u00edom\u00f3r Thoir",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Am Oile\u00e1in Sholom\u00f3n",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Am Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Am Oile\u00e1in Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Am Caighde\u00e1nach Oirthear na hEorpa",
               "EET",
               "Am Samhraidh Oirthear na hEorpa",
               "EEST",
               "Am Oirthear na hEorpa",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Am Caighde\u00e1nach Thalamh an \u00c9isc",
               "NST",
               "Am Samhraidh Thalamh an \u00c9isc",
               "NDT",
               "Am Thalamh an \u00c9isc",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Am na hAfganast\u00e1ine",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Am Caighde\u00e1nach Hong Cong",
               "HKT",
               "Am Samhraidh Hong Cong",
               "HKST",
               "Am Hong Cong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hAirgint\u00edne",
               "ART",
               "Am Samhraidh Iarthar na hAirgint\u00edne",
               "ARST",
               "Am Iarthar na hAirgint\u00edne",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Am Caighde\u00e1nach an Atlantaigh",
               "AST",
               "Am Samhraidh an Atlantaigh",
               "ADT",
               "Am an Atlantaigh",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Am Phohnpei",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Am na Bolaive",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Am Caighde\u00e1nach Saint-Pierre-et-Miquelon",
               "PMST",
               "Am Samhraidh Saint-Pierre-et-Miquelon",
               "PMDT",
               "Am Saint-Pierre-et-Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Am na hInd-S\u00edne",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Am Caighde\u00e1nach Yekaterinburg",
               "YEKT",
               "Am Samhraidh Yekaterinburg",
               "YEKST",
               "Am Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Am Oile\u00e1in Mhaild\u00edve",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Am Thaih\u00edt\u00ed",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Am Caighde\u00e1nach Iosrael",
               "IST",
               "Am Samhraidh Iosrael",
               "IDT",
               "Am Iosrael",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Am L\u00e1r na hIndin\u00e9ise",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Am Vail\u00eds agus Fut\u00fana",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Am Caighde\u00e1nach na hAfraice Theas",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Am St\u00e1isi\u00fan Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Am Oile\u00e1in na L\u00edne",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Am Caighde\u00e1nach na h\u00daisb\u00e9iceast\u00e1ine",
               "UZT",
               "Am Samhraidh na h\u00daisb\u00e9iceast\u00e1ine",
               "UZST",
               "Am na h\u00daisb\u00e9iceast\u00e1ine",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Am Caighde\u00e1nach Omsk",
               "OMST",
               "Am Samhraidh Omsk",
               "OMSST",
               "Am Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Am na S\u00e9is\u00e9al",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Am Caighde\u00e1nach Uragua",
               "UYT",
               "Am Samhraidh Uragua",
               "UYST",
               "Am Uragua",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Am Neipeal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Am Caighde\u00e1nach Ul\u00e1nb\u00e1tar",
               "ULAT",
               "Am Samhraidh Ul\u00e1nb\u00e1tar",
               "ULAST",
               "Am Ul\u00e1nb\u00e1tar",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Am Caighde\u00e1nach L\u00e1rnach",
               "CST",
               "Am Samhraidh L\u00e1rnach",
               "CDT",
               "Am L\u00e1rnach",
               "CT",
            };
        final String[] Truk = new String[] {
               "Am Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Am Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Am Oile\u00e1n Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1in Fh\u00e1clainne",
               "FKT",
               "Am Samhraidh Oile\u00e1in Fh\u00e1clainne",
               "FKST",
               "Am Oile\u00e1in Fh\u00e1clainne",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Am Caighde\u00e1nach Vanuat\u00fa",
               "VUT",
               "Am Samhraidh Vanuat\u00fa",
               "VUST",
               "Am Vanuat\u00fa",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Am Caighde\u00e1nach Novosibirsk",
               "NOVT",
               "Am Samhraidh Novosibirsk",
               "NOVST",
               "Am Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Am Caighde\u00e1nach Shingeap\u00f3r",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Am Caighde\u00e1nach na nAs\u00f3r",
               "AZOT",
               "Am Samhraidh na nAs\u00f3r",
               "AZOST",
               "Am na nAs\u00f3r",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Am Caighde\u00e1nach Apia",
               "WSST",
               "Am Samhraidh Apia",
               "WSDT",
               "Am Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Am na B\u00fat\u00e1ine",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Am Shuranam",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Am N\u00e1r\u00fa",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Am Caighde\u00e1nach Krasnoyarsk",
               "KRAT",
               "Am Samhraidh Krasnoyarsk",
               "KRAST",
               "Am Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Am Iarthar na Casacst\u00e1ine",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Am Mhaenmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Am Oile\u00e1n na Nollag",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Am Caighde\u00e1nach na hAmas\u00f3ine",
               "AMT",
               "Am Samhraidh na hAmas\u00f3ine",
               "AMST",
               "Am na hAmas\u00f3ine",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Am Oirthear na Casacst\u00e1ine",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Am Caighde\u00e1nach Fhids\u00ed",
               "FJT",
               "Am Samhraidh Fhids\u00ed",
               "FJST",
               "Am Fhids\u00ed",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Am R\u00e9union",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Am Oile\u00e1in Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Am Caighde\u00e1nach Chatham",
               "CHAST",
               "Am Samhraidh Chatham",
               "CHADT",
               "Am Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Am St\u00e1isi\u00fan Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Am Caighde\u00e1nach na hAirgint\u00edne",
               "ART",
               "Am Samhraidh na hAirgint\u00edne",
               "ARST",
               "Am na hAirgint\u00edne",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Am Ghambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Am Caighde\u00e1nach Phetropavlovsk-Kamchatski",
               "PETT",
               "Am Samhraidh Phetropavlovsk-Kamchatski",
               "PETST",
               "Am Phetropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Am Thuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Am Oile\u00e1in Gal\u00e1pagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Am Oile\u00e1n Mhic Guaire",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Am Veinis\u00e9ala",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Am Caighde\u00e1nach Hav\u00e1\u00ed-Aili\u00fait",
               "HAST",
               "Am Samhraidh Hav\u00e1\u00ed-Aili\u00fait",
               "HADT",
               "Am Hav\u00e1\u00ed-Aili\u00fait",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Am Caighde\u00e1nach L\u00e1r na hAstr\u00e1ile",
               "ACST",
               "Am Samhraidh L\u00e1r na hAstr\u00e1ile",
               "ACDT",
               "Am L\u00e1r na hAstr\u00e1ile",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Am Caighde\u00e1nach an Aig\u00e9in Chi\u00fain",
               "PST",
               "Am Samhraidh an Aig\u00e9in Chi\u00fain",
               "PDT",
               "Am an Aig\u00e9in Chi\u00fain",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Am Oile\u00e1in an Fh\u00e9inics",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Am Caighde\u00e1nach na Tuircm\u00e9anast\u00e1ine",
               "TMT",
               "Am Samhraidh na Tuircm\u00e9anast\u00e1ine",
               "TMST",
               "Am na Tuircm\u00e9anast\u00e1ine",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hEorpa",
               "WET",
               "Am Samhraidh Iarthar na hEorpa",
               "WEST",
               "Am Iarthar na hEorpa",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Am Caighde\u00e1nach Rinn Verde",
               "CVT",
               "Am Samhraidh Rinn Verde",
               "CVST",
               "Am Rinn Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Am Oile\u00e1n Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Am na Gu\u00e1ine",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Am Oile\u00e1n Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Am St\u00e1isi\u00fan Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Am Caighde\u00e1nach Sham\u00f3",
               "SST",
               "Am Samhraidh Sham\u00f3",
               "SDT",
               "Am Sham\u00f3",
               "ST",
            };
        final String[] Palau = new String[] {
               "Am Oile\u00e1in Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Am Chianoirthear na hEorpa",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Am Caighde\u00e1nach na hAsarbaise\u00e1ine",
               "AZT",
               "Am Samhraidh na hAsarbaise\u00e1ine",
               "AZST",
               "Am na hAsarbaise\u00e1ine",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Am St\u00e1isi\u00fan Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Am Caighde\u00e1nach Meicsiceach an Aig\u00e9in Chi\u00fain",
               "MST",
               "Am Samhraidh Meicsiceach an Aig\u00e9in Chi\u00fain",
               "MDT",
               "Am Meicsiceach an Aig\u00e9in Chi\u00fain",
               "MT",
            };
        final String[] Davis = new String[] {
               "Am St\u00e1isi\u00fan Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Am Caighde\u00e1nach Ch\u00faba",
               "CST",
               "Am Samhraidh Ch\u00faba",
               "CDT",
               "Am Ch\u00faba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hAfraice",
               "CAT",
               "Am Samhraidh Iarthar na hAfraice",
               "CAST",
               "Am Iarthar na hAfraice",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Me\u00e1n-Am Greenwich",
               "MAG",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Am Caighde\u00e1nach na nOile\u00e1n Filip\u00edneach",
               "PHT",
               "Am Samhraidh na nOile\u00e1n Filip\u00edneach",
               "PHST",
               "Am na nOile\u00e1n Filip\u00edneach",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Am Chr\u00edocha Francacha Deisceart an Domhain",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Am na Seoirsia Theas",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Am Caighde\u00e1nach na Nua-Chalad\u00f3ine",
               "NCT",
               "Am Samhraidh na Nua-Chalad\u00f3ine",
               "NCST",
               "Am na Nua-Chalad\u00f3ine",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Am Br\u00fain\u00e9 Darasal\u00e1m",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Am Caighde\u00e1nach na hIar\u00e1ine",
               "IRST",
               "Am Samhraidh na hIar\u00e1ine",
               "IRDT",
               "Am na hIar\u00e1ine",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1n na C\u00e1sca",
               "EAST",
               "Am Samhraidh Oile\u00e1n na C\u00e1sca",
               "EASST",
               "Am Oile\u00e1n na C\u00e1sca",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Am Caighde\u00e1nach Iarthuaisceart Mheicsiceo",
               "PST",
               "Am Samhraidh Iarthuaisceart Mheicsiceo",
               "PDT",
               "Am Iarthuaisceart Mheicsiceo",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Am St\u00e1isi\u00fan Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Am na T\u00e1ids\u00edceast\u00e1ine",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Am Caighde\u00e1nach Thonga",
               "TOT",
               "Am Samhraidh Thonga",
               "TOST",
               "Am Thonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Am Caighde\u00e1nach na Banglaid\u00e9ise",
               "BDT",
               "Am Samhraidh na Banglaid\u00e9ise",
               "BDST",
               "Am na Banglaid\u00e9ise",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Am Caighde\u00e1nach Pheiri\u00fa",
               "PET",
               "Am Samhraidh Pheiri\u00fa",
               "PEST",
               "Am Pheiri\u00fa",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na Graonlainne",
               "WGT",
               "Am Samhraidh Iarthar na Graonlainne",
               "WGST",
               "Am Iarthar na Graonlainne",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Am Eacuad\u00f3r",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Am Caighde\u00e1nach Oirthear na Graonlainne",
               "EGT",
               "Am Samhraidh Oirthear na Graonlainne",
               "EGST",
               "Am Oirthear na Graonlainne",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Am Caighde\u00e1nach na Murascaille",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Am Oirthear na hIndin\u00e9ise",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Am Caighde\u00e1nach na C\u00f3ir\u00e9",
               "KST",
               "Am Samhraidh na C\u00f3ir\u00e9",
               "KDT",
               "Am na C\u00f3ir\u00e9",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hAstr\u00e1ile",
               "AWST",
               "Am Samhraidh Iarthar na hAstr\u00e1ile",
               "AWDT",
               "Am Iarthar na hAstr\u00e1ile",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Am na Cirgeast\u00e1ine",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Am Iarthar na hIndin\u00e9ise",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Am Caighde\u00e1nach Oirthear na hAstr\u00e1ile",
               "AEST",
               "Am Samhraidh Oirthear na hAstr\u00e1ile",
               "AEDT",
               "Am Oirthear na hAstr\u00e1ile",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Am Ghu\u00e1in na Fraince",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Am Caighde\u00e1nach na Col\u00f3ime",
               "COT",
               "Am Samhraidh na Col\u00f3ime",
               "COST",
               "Am na Col\u00f3ime",
               "COT",
            };
        final String[] Chile = new String[] {
               "Am Caighde\u00e1nach na Sile",
               "CLT",
               "Am Samhraidh na Sile",
               "CLST",
               "Am na Sile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Am Chireabait\u00ed",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Am Caighde\u00e1nach na Sl\u00e9ibhte",
               "MST",
               "Am Samhraidh na Sl\u00e9ibhte",
               "MDT",
               "Am na Sl\u00e9ibhte",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Am na nOile\u00e1n Marcasach",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Am Caighde\u00e1nach na hAraibe",
               "AST",
               "Am Samhraidh na hAraibe",
               "ADT",
               "Am na hAraibe",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Am Caighde\u00e1nach Alasca",
               "AKST",
               "Am Samhraidh Alasca",
               "AKDT",
               "Am Alasca",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Am Caighde\u00e1nach Vladivostok",
               "VLAT",
               "Am Samhraidh Vladivostok",
               "VLAST",
               "Am Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Am Caighde\u00e1nach Seam\u00f3rach",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Am Caighde\u00e1nach Irkutsk",
               "IRKT",
               "Am Samhraidh Irkutsk",
               "IRKST",
               "Am Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Am Caighde\u00e1nach na Seoirsia",
               "GET",
               "Am Samhraidh na Seoirsia",
               "GEST",
               "Am na Seoirsia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Am Oile\u00e1in T\u00f3cal\u00e1",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Am Nua-Ghuine Phapua",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Am Caighde\u00e1nach Fhernando de Noronha",
               "FNT",
               "Am Samhraidh Fhernando de Noronha",
               "FNST",
               "Am Fhernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Am Caighde\u00e1nach Choibalsan",
               "CHOT",
               "Am Samhraidh Choibalsan",
               "CHOST",
               "Am Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Am Caighde\u00e1nach Bhras\u00edlia",
               "BRT",
               "Am Samhraidh Bhras\u00edlia",
               "BRST",
               "Am Bhras\u00edlia",
               "BRT",
            };
        final String[] China = new String[] {
               "Am Caighde\u00e1nach na S\u00edne",
               "CST",
               "Am Samhraidh na S\u00edne",
               "CDT",
               "Am na S\u00edne",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Am Caighde\u00e1nach na hAirm\u00e9ine",
               "AMT",
               "Am Samhraidh na hAirm\u00e9ine",
               "AMST",
               "Am na hAirm\u00e9ine",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Am Caighde\u00e1nach Shamara",
               "SAMT",
               "Am Samhraidh Shamara",
               "SAMST",
               "Am Shamara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Am Caighde\u00e1nach na hIndia",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1in Cook",
               "CKT",
               "Am Leathshamhraidh Oile\u00e1in Cook",
               "CKHST",
               "Am Oile\u00e1in Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Me\u00e1n-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Me\u00e1n-Am Greenwich",
                    "MAG",
                    "Am Caighd\u00e9anach na h\u00c9ireann",
                    "AC\u00c9",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
