/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.base.Objects;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.internal.Describables;

public class DefaultComponentSelectionDescriptor
implements ComponentSelectionDescriptorInternal {
    private final ComponentSelectionCause cause;
    private final Describable description;
    private final boolean hasCustomDescription;
    private final int hashCode;
    private final boolean isEquivalentToForce;

    public DefaultComponentSelectionDescriptor(ComponentSelectionCause cause) {
        this(cause, (Describable)Describables.of((Object)cause.getDefaultReason()), false, cause == ComponentSelectionCause.FORCED);
    }

    public DefaultComponentSelectionDescriptor(ComponentSelectionCause cause, Describable description) {
        this(cause, description, true, cause == ComponentSelectionCause.FORCED);
    }

    private DefaultComponentSelectionDescriptor(ComponentSelectionCause cause, Describable description, boolean hasCustomDescription, boolean isEquivalentToForce) {
        this.cause = cause;
        this.description = description;
        this.hasCustomDescription = hasCustomDescription;
        this.isEquivalentToForce = isEquivalentToForce;
        this.hashCode = hasCustomDescription ? Objects.hashCode((Object[])new Object[]{cause, description, isEquivalentToForce}) : Objects.hashCode((Object[])new Object[]{cause, isEquivalentToForce});
    }

    public ComponentSelectionCause getCause() {
        return this.cause;
    }

    public String getDescription() {
        return this.description.getDisplayName();
    }

    @Override
    public boolean hasCustomDescription() {
        return this.hasCustomDescription;
    }

    @Override
    public Describable getDescribable() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultComponentSelectionDescriptor that = (DefaultComponentSelectionDescriptor)o;
        return this.cause == that.cause && this.isEquivalentToForce == that.isEquivalentToForce && Objects.equal((Object)this.description, (Object)that.description);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.description.getDisplayName();
    }

    @Override
    public ComponentSelectionDescriptorInternal withDescription(Describable description) {
        if (this.description.equals(description)) {
            return this;
        }
        return new DefaultComponentSelectionDescriptor(this.cause, description, true, this.isEquivalentToForce);
    }

    @Override
    public ComponentSelectionDescriptorInternal markAsEquivalentToForce() {
        return new DefaultComponentSelectionDescriptor(this.cause, this.description, this.hasCustomDescription, true);
    }

    @Override
    public boolean isEquivalentToForce() {
        return this.isEquivalentToForce;
    }
}

