/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class DefaultPropertyState<T>
extends AbstractProperty<T>
implements Property<T> {
    private final Class<T> type;
    private final ValueSanitizer<T> sanitizer;
    private ProviderInternal<? extends T> provider;

    public DefaultPropertyState(Class<T> type) {
        this.applyDefaultValue();
        this.type = type;
        this.sanitizer = ValueSanitizers.forType(type);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            this.set(object);
        }
    }

    public void set(T value) {
        if (!this.beforeMutate()) {
            return;
        }
        if (value == null) {
            this.provider = Providers.notDefined();
            this.afterMutate();
            return;
        }
        if (!this.type.isInstance(value = this.sanitizer.sanitize(value))) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.type.getName(), value.getClass().getName()));
        }
        this.provider = Providers.of(value);
        this.afterMutate();
    }

    public Property<T> value(T value) {
        this.set(value);
        return this;
    }

    public void set(Provider<? extends T> provider) {
        if (!this.beforeMutate()) {
            return;
        }
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        Provider p = Providers.internal(provider);
        if (p.getType() != null && !this.type.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.type.getName(), p.getType().getName()));
        }
        if (p.getType() == null) {
            p = p.map(new Transformer<T, T>(){

                public T transform(T t) {
                    t = DefaultPropertyState.this.sanitizer.sanitize(t);
                    if (DefaultPropertyState.this.type.isInstance(t)) {
                        return t;
                    }
                    throw new IllegalArgumentException(String.format("Cannot get the value of a property of type %s as the provider associated with this property returned a value of type %s.", DefaultPropertyState.this.type.getName(), t.getClass().getName()));
                }
            });
        }
        this.provider = p;
        this.afterMutate();
    }

    public Property<T> convention(T value) {
        if (this.shouldApplyConvention()) {
            this.provider = Providers.of(value);
        }
        return this;
    }

    public Property<T> convention(Provider<? extends T> valueProvider) {
        if (this.shouldApplyConvention()) {
            this.provider = Providers.internal(valueProvider);
        }
        return this;
    }

    @Override
    protected void applyDefaultValue() {
        this.provider = Providers.notDefined();
    }

    @Override
    protected void makeFinal() {
        this.provider = this.provider.withFinalValue();
    }

    protected ProviderInternal<? extends T> getProvider() {
        return this.provider;
    }

    public T get() {
        this.beforeRead();
        return (T)this.provider.get();
    }

    public T getOrNull() {
        this.beforeRead();
        return (T)this.provider.getOrNull();
    }

    @Override
    public T getOrElse(T defaultValue) {
        this.beforeRead();
        Object t = this.provider.getOrNull();
        if (t == null) {
            return defaultValue;
        }
        return (T)t;
    }

    @Override
    public boolean isPresent() {
        this.beforeRead();
        return this.provider.isPresent();
    }

    @Override
    public String toString() {
        return String.format("property(%s, %s)", this.type, this.provider);
    }
}

