/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.concurrent.DefaultParallelismConfiguration;
import org.gradle.internal.concurrent.ParallelismConfigurationListener;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.event.ListenerManager;

public class DefaultParallelismConfigurationManager
implements ParallelismConfigurationManager {
    private final ListenerManager listenerManager;
    private final ParallelismConfigurationListener broadcaster;
    private ParallelismConfiguration parallelismConfiguration = DefaultParallelismConfiguration.DEFAULT;

    public DefaultParallelismConfigurationManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        this.broadcaster = (ParallelismConfigurationListener)listenerManager.getBroadcaster(ParallelismConfigurationListener.class);
    }

    public ParallelismConfiguration getParallelismConfiguration() {
        return this.parallelismConfiguration;
    }

    public void setParallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
        this.parallelismConfiguration = parallelismConfiguration;
        this.broadcaster.onParallelismConfigurationChange(parallelismConfiguration);
    }

    public void addListener(ParallelismConfigurationListener listener) {
        this.listenerManager.addListener((Object)listener);
    }

    public void removeListener(ParallelismConfigurationListener listener) {
        this.listenerManager.removeListener((Object)listener);
    }
}

