/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Logger;

public abstract class ProteinStructure
implements Structure {
    STR type;
    STR subtype;
    String structureID;
    int strucNo;
    int serialID;
    int strandCount = 1;
    public int nRes;
    public AlphaPolymer apolymer;
    protected int monomerIndexFirst;
    int monomerIndexLast;
    protected P3 axisA;
    protected P3 axisB;
    protected V3 axisUnitVector;
    protected V3 vectorProjection;
    private static int globalStrucNo = 1000;
    private P3[] segments;
    private Map<Monomer, Integer> resMap;

    protected void setupPS(AlphaPolymer alphaPolymer, STR sTR, int n, int n2) {
        this.strucNo = ++globalStrucNo;
        this.apolymer = alphaPolymer;
        this.type = sTR;
        this.vectorProjection = new V3();
        this.monomerIndexFirst = n;
        this.addMonomer(n + n2 - 1);
        if (Logger.debugging) {
            Logger.info("Creating ProteinStructure " + this.strucNo + " " + sTR.getBioStructureTypeName(false) + " from " + this.monomerIndexFirst + " through " + this.monomerIndexLast + " in polymer " + alphaPolymer);
        }
    }

    void addMonomer(int n) {
        this.resMap = null;
        this.resetAxes();
        this.monomerIndexFirst = Math.min(this.monomerIndexFirst, n);
        this.monomerIndexLast = Math.max(this.monomerIndexLast, n);
        this.nRes = this.monomerIndexLast - this.monomerIndexFirst + 1;
    }

    void removeMonomer(int n) {
        this.resMap = null;
        this.resetAxes();
        if (n > this.monomerIndexLast || n < this.monomerIndexFirst) {
            return;
        }
        if (n == this.monomerIndexFirst) {
            ++this.monomerIndexFirst;
            --this.nRes;
        } else if (n == this.monomerIndexLast) {
            --this.monomerIndexLast;
            --this.nRes;
        } else {
            int n2 = this.monomerIndexLast - n;
            this.monomerIndexLast = n - 1;
            this.nRes = n - this.monomerIndexFirst;
            Monomer[] monomerArray = this.apolymer.monomers;
            STR sTR = monomerArray[++n].getProteinStructureType();
            int n3 = -1;
            int n4 = 0;
            int n5 = n;
            while (n4 < n2) {
                ((AlphaMonomer)monomerArray[n5]).setStructure(null);
                n3 = monomerArray[n5].setProteinStructureType(sTR, n3);
                ++n4;
                ++n5;
            }
        }
    }

    public void calcAxis() {
    }

    public boolean isWithin(int n) {
        return n > this.monomerIndexFirst && n < this.monomerIndexLast;
    }

    public int getIndex(Monomer monomer) {
        Integer n;
        if (this.resMap == null) {
            this.resMap = new Hashtable<Monomer, Integer>();
            int n2 = this.nRes;
            while (--n2 >= 0) {
                this.resMap.put(this.apolymer.monomers[this.monomerIndexFirst + n2], n2);
            }
        }
        return (n = this.resMap.get(monomer)) == null ? -1 : n;
    }

    public P3[] getSegments() {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments;
    }

    P3 getStructureMidPoint(int n) {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments[n];
    }

    private void calcSegments() {
        if (this.segments != null) {
            return;
        }
        this.calcAxis();
        this.segments = new P3[this.nRes + 1];
        this.segments[this.nRes] = this.axisB;
        this.segments[0] = this.axisA;
        V3 v3 = V3.newV(this.axisUnitVector);
        v3.scale(this.axisB.distance(this.axisA) / (float)this.nRes);
        int n = 1;
        while (n < this.nRes) {
            P3 p3 = this.segments[n] = new P3();
            p3.add2(this.segments[n - 1], v3);
            ++n;
        }
    }

    public P3 getAxisStartPoint() {
        this.calcAxis();
        return this.axisA;
    }

    public P3 getAxisEndPoint() {
        this.calcAxis();
        return this.axisB;
    }

    void resetAxes() {
        this.axisA = null;
        this.segments = null;
    }

    @Override
    public void setAtomBits(BS bS) {
        Monomer[] monomerArray = this.apolymer.monomers;
        int n = this.monomerIndexFirst;
        while (n <= this.monomerIndexLast) {
            monomerArray[n].setAtomBits(bS);
            ++n;
        }
    }

    @Override
    public void setAtomBitsAndClear(BS bS, BS bS2) {
        Monomer[] monomerArray = this.apolymer.monomers;
        int n = this.monomerIndexFirst;
        while (n <= this.monomerIndexLast) {
            monomerArray[n].setAtomBitsAndClear(bS, bS2);
            ++n;
        }
    }

    public Monomer findMonomer(BS bS, boolean bl) {
        Monomer[] monomerArray = this.apolymer.monomers;
        if (bl) {
            int n = this.monomerIndexFirst;
            while (n <= this.monomerIndexLast) {
                if (bS == null || bS.get(monomerArray[n].leadAtomIndex)) {
                    return monomerArray[n];
                }
                ++n;
            }
        } else {
            int n = this.monomerIndexLast;
            while (n >= this.monomerIndexFirst) {
                if (bS == null || bS.get(monomerArray[n].leadAtomIndex)) {
                    return monomerArray[n];
                }
                --n;
            }
        }
        return null;
    }
}

