/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.A4;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.render.MeshRenderer;
import org.jmol.shapespecial.Draw;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.C;
import org.jmol.util.GData;

public class DrawRenderer
extends MeshRenderer {
    private Draw.EnumDrawType drawType;
    protected DrawMesh dmesh;
    private P3[] controlHermites;
    protected P3 pt0 = new P3();
    protected P3 pt1 = new P3();
    protected P3 pt2 = new P3();
    protected final V3 vTemp = new V3();
    protected final V3 vTemp2 = new V3();
    private final P3 pt0f = new P3();
    protected P3i pt0i = new P3i();
    private P3 s0f;
    private P3 s1f;
    private P3 s2f;
    private final BS bsHandles = new BS();

    @Override
    protected boolean render() {
        this.needTranslucent = false;
        this.imageFontScaling = this.vwr.imageFontScaling;
        Draw draw = (Draw)this.shape;
        int n = draw.meshCount;
        while (--n >= 0) {
            DrawMesh drawMesh = this.dmesh = (DrawMesh)draw.meshes[n];
            if (drawMesh.connectedAtoms != null) {
                if (drawMesh.connectedAtoms[0] < 0) continue;
                drawMesh.vs = new P3[4];
                drawMesh.vc = 4;
                int[] nArray = drawMesh.connectedAtoms;
                int n2 = 0;
                while (n2 < 4) {
                    drawMesh.vs[n2] = nArray[n2] < 0 ? drawMesh.vs[n2 - 1] : this.vwr.ms.at[nArray[n2]];
                    ++n2;
                }
                drawMesh.recalcAltVertices = true;
            }
            if (this.renderMesh2(drawMesh)) {
                this.renderInfo();
            }
            if (this.isExport || drawMesh.visibilityFlags == 0 || this.vwr.getPickingMode() != 4) continue;
            if (!this.g3d.setC(C.getColixTranslucent3((short)23, true, 0.5f))) {
                this.needTranslucent = true;
                continue;
            }
            this.renderHandles();
        }
        return this.needTranslucent;
    }

    @Override
    protected boolean isPolygonDisplayable(int n) {
        return Draw.isPolygonDisplayable(this.dmesh, n) && (this.dmesh.modelFlags == null || this.dmesh.bsMeshesVisible.get(n));
    }

    @Override
    protected void render2(boolean bl) {
        int n;
        int n2;
        boolean bl2;
        this.drawType = this.dmesh.drawType;
        this.diameter = this.dmesh.diameter;
        this.width = this.dmesh.width;
        if (this.mesh.connectedAtoms != null) {
            this.getConnectionPoints();
        }
        if (this.mesh.lineData != null) {
            this.drawLineData(this.mesh.lineData);
            return;
        }
        int n3 = this.vertexCount;
        boolean bl3 = bl2 = (this.drawType == Draw.EnumDrawType.CURVE || this.drawType == Draw.EnumDrawType.ARROW || this.drawType == Draw.EnumDrawType.ARC) && this.vertexCount > 2;
        if (this.width > 0.0f && bl2 || this.drawType == Draw.EnumDrawType.ARROW) {
            this.pt1f.set(0.0f, 0.0f, 0.0f);
            n2 = this.drawType == Draw.EnumDrawType.ARC ? 2 : this.vertexCount;
            n = 0;
            while (n < n2) {
                this.pt1f.add(this.vertices[n]);
                ++n;
            }
            this.pt1f.scale(1.0f / (float)n2);
            this.tm.transformPtScr(this.pt1f, this.pt1i);
            this.diameter = (int)this.vwr.tm.scaleToScreen(this.pt1i.z, (int)Math.floor(this.width * 1000.0f));
            if (this.diameter == 0) {
                this.diameter = 1;
            }
        }
        if (this.dmesh.haveXyPoints) {
            if (this.dmesh.isVector) {
                n2 = 0;
                n = 0;
                while (n < 2) {
                    if (this.vertices[n].z == Float.MAX_VALUE || this.vertices[n].z == -3.4028235E38f) {
                        n2 += n + 1;
                    }
                    ++n;
                }
                if (--n2 < 2) {
                    this.renderXyArrow(n2);
                    return;
                }
            } else if (this.drawType == Draw.EnumDrawType.POINT) {
                this.renderXyPoint();
            }
        }
        n2 = 5;
        switch (this.drawType) {
            default: {
                this.render2b(false);
                return;
            }
            case CIRCULARPLANE: {
                if (this.dmesh.scale > 0.0f) {
                    this.width *= this.dmesh.scale;
                }
                this.render2b(false);
                return;
            }
            case CIRCLE: {
                this.tm.transformPtScr(this.vertices[0], this.pt1i);
                if (this.diameter == 0 && this.width == 0.0f) {
                    this.width = 1.0f;
                }
                if (this.dmesh.scale > 0.0f) {
                    this.width *= this.dmesh.scale;
                }
                if (this.width > 0.0f) {
                    this.diameter = (int)this.vwr.tm.scaleToScreen(this.pt1i.z, (int)Math.floor(this.width * 1000.0f));
                }
                if (this.diameter > 0 && (this.mesh.drawTriangles || this.mesh.fillTriangles)) {
                    this.g3d.addRenderer(1073741880);
                    this.g3d.drawFilledCircle(this.colix, this.mesh.fillTriangles ? this.colix : (short)0, this.diameter, this.pt1i.x, this.pt1i.y, this.pt1i.z);
                }
                return;
            }
            case LINE_SEGMENT: {
                n = 0;
                while (n < n3 - 1) {
                    this.drawEdge(n, n + 1, true, this.vertices[n], this.vertices[n + 1], this.screens[n], this.screens[n + 1]);
                    ++n;
                }
                return;
            }
            case CURVE: {
                break;
            }
            case ARC: {
                float f;
                P3 p3 = this.vertexCount > 2 ? this.vertices[2] : Draw.randomPoint();
                float f2 = this.vertexCount > 3 ? this.vertices[3].x : 0.0f;
                float f3 = f = this.vertexCount > 3 ? this.vertices[3].y : 360.0f;
                if (f == 0.0f) {
                    return;
                }
                float f4 = this.vertexCount > 3 ? this.vertices[3].z : 0.0f;
                n3 = this.setArc(this.vertices[0], this.vertices[1], p3, f2, f, f4, this.dmesh.scale);
                if (this.dmesh.isVector && !this.dmesh.noHead) {
                    this.renderArrowHead(this.pt0, this.pt1, 0.3f, false, false, this.dmesh.isBarb);
                    this.tm.transformPtScr(this.pt1f, this.screens[n3 - 1]);
                    this.tm.transformPtScrT3(this.pt1f, this.p3Screens[n3 - 1]);
                }
                this.pt1f.setT(this.pt2);
                break;
            }
            case ARROW: {
                if (!bl2) {
                    this.renderArrowHead(this.vertices[0], this.vertices[1], 0.0f, false, true, this.dmesh.isBarb);
                    return;
                }
                int n4 = 5;
                if (this.controlHermites == null || this.controlHermites.length < n4 + 1) {
                    this.controlHermites = new P3[n4 + 1];
                }
                GData.getHermiteList(n2, this.vertices[this.vertexCount - 3], this.vertices[this.vertexCount - 2], this.vertices[this.vertexCount - 1], this.vertices[this.vertexCount - 1], this.vertices[this.vertexCount - 1], this.controlHermites, 0, n4, true);
                this.renderArrowHead(this.controlHermites[n4 - 2], this.controlHermites[n4 - 1], 0.0f, false, false, this.dmesh.isBarb);
            }
        }
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        if (bl2) {
            this.g3d.addRenderer(0x21000012);
            int n5 = 0;
            int n6 = 0;
            while (n5 < n3 - 1) {
                this.g3d.fillHermite(n2, this.diameter, this.diameter, this.diameter, this.p3Screens[n6], this.p3Screens[n5], this.p3Screens[n5 + 1], this.p3Screens[n5 + (n5 == n3 - 2 ? 1 : 2)]);
                n6 = n5++;
            }
        } else {
            this.render2b(false);
        }
    }

    private int setArc(T3 t3, T3 t32, T3 t33, float f, float f2, float f3, float f4) {
        this.vTemp.sub2(t32, t3);
        this.pt1f.scaleAdd2(f3, this.vTemp, t3);
        M3 m3 = new M3().setAA(A4.newVA(this.vTemp, (float)((double)f * Math.PI / 180.0)));
        this.vTemp2.sub2(t33, t3);
        this.vTemp2.cross(this.vTemp, this.vTemp2);
        this.vTemp2.cross(this.vTemp2, this.vTemp);
        this.vTemp2.normalize();
        this.vTemp2.scale(f4 / 2.0f);
        m3.rotate(this.vTemp2);
        float f5 = f2 / 5.0f;
        while (Math.abs(f5) > 5.0f) {
            f5 /= 2.0f;
        }
        int n = Math.round(f2 / f5) + 1;
        while (n < 10) {
            n = Math.round(f2 / (f5 /= 2.0f)) + 1;
        }
        m3.setAA(A4.newVA(this.vTemp, (float)((double)f5 * Math.PI / 180.0)));
        this.screens = this.vwr.allocTempScreens(n);
        this.p3Screens = this.vwr.allocTempPoints(n);
        int n2 = n - (this.dmesh.scale < 2.0f ? 3 : 3);
        int n3 = 0;
        while (n3 < n) {
            if (n3 == n2) {
                this.pt0.setT(this.pt1);
            }
            this.pt1.scaleAdd2(1.0f, this.vTemp2, this.pt1f);
            if (n3 == 0) {
                this.pt2.setT(this.pt1);
            }
            this.tm.transformPtScr(this.pt1, this.screens[n3]);
            this.tm.transformPtScrT3(this.pt1, this.p3Screens[n3]);
            m3.rotate(this.vTemp2);
            ++n3;
        }
        return n;
    }

    private void getConnectionPoints() {
        float f;
        this.vertexCount = 3;
        float f2 = Float.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 2;
            while (n4 < 4) {
                f = this.vertices[n3].distance(this.vertices[n4]);
                if (f < f2) {
                    f2 = f;
                    n = n3;
                    n2 = n4;
                }
                ++n4;
            }
            ++n3;
        }
        this.pt0.ave(this.vertices[0], this.vertices[1]);
        this.pt2.ave(this.vertices[2], this.vertices[3]);
        this.pt1.ave(this.pt0, this.pt2);
        this.vertices[3] = P3.newP(this.vertices[n]);
        this.vertices[3].add(this.vertices[n2]);
        this.vertices[3].scale(0.5f);
        this.vertices[1] = P3.newP(this.pt1);
        this.vertices[0] = P3.newP(this.pt0);
        this.vertices[2] = P3.newP(this.pt2);
        n3 = 0;
        while (n3 < 4) {
            this.tm.transformPtScr(this.vertices[n3], this.screens[n3]);
            ++n3;
        }
        float f3 = 4.0f * this.getArrowScale();
        float f4 = 0.2f;
        f = this.width == 0.0f ? 0.1f : this.width;
        this.pt0.set(this.screens[0].x, this.screens[0].y, this.screens[0].z);
        this.pt1.set(this.screens[1].x, this.screens[1].y, this.screens[1].z);
        this.pt2.set(this.screens[3].x, this.screens[3].y, this.screens[3].z);
        float f5 = (float)(this.screens[1].x - this.screens[0].x) * f3;
        float f6 = (float)(this.screens[1].y - this.screens[0].y) * f3;
        if (f2 == 0.0f || Measure.computeTorsion(this.pt2, this.pt0, P3.new3(this.pt0.x, this.pt0.y, 10000.0f), this.pt1, false) > 0.0f) {
            f5 = -f5;
            f6 = -f6;
        }
        this.pt2.set(f6, -f5, 0.0f);
        this.pt1.add(this.pt2);
        this.tm.unTransformPoint(this.pt1, this.vertices[1]);
        this.pt2.scale(f);
        this.vTemp.sub2(this.vertices[1], this.vertices[0]);
        this.vTemp.scale(f4);
        this.vertices[0].add(this.vTemp);
        this.vTemp.sub2(this.vertices[1], this.vertices[2]);
        this.vTemp.scale(f4);
        this.vertices[2].add(this.vTemp);
        int n5 = 0;
        while (n5 < 3) {
            this.tm.transformPtScr(this.vertices[n5], this.screens[n5]);
            if (f != 0.0f) {
                this.screens[n5].x += Math.round(this.pt2.x);
                this.screens[n5].y += Math.round(this.pt2.y);
                this.pt1.set(this.screens[n5].x, this.screens[n5].y, this.screens[n5].z);
                this.tm.unTransformPoint(this.pt1, this.vertices[n5]);
            }
            ++n5;
        }
    }

    private void drawLineData(Lst<P3[]> lst) {
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        int n = lst.size();
        while (--n >= 0) {
            P3[] p3Array = (P3[])lst.get(n);
            this.tm.transformPtScr(p3Array[0], this.pt1i);
            this.tm.transformPtScr(p3Array[1], this.pt2i);
            this.drawEdge(-1, -2, true, p3Array[0], p3Array[1], this.pt1i, this.pt2i);
        }
    }

    private void renderXyPoint() {
        int n = this.g3d.isAntialiased() ? 2 : 1;
        this.pt0.setT(this.vertices[0]);
        if (this.diameter == 0) {
            this.diameter = (int)this.width;
        }
        if (this.pt0.z == -3.4028235E38f) {
            this.pt0.x *= (float)this.vwr.tm.width / 100.0f;
            this.pt0.y *= (float)this.vwr.tm.height / 100.0f;
            this.diameter = (int)((float)(this.diameter * this.vwr.getScreenDim()) / 100.0f);
        }
        this.diameter *= n;
        this.pt1i.set((int)(this.pt0.x * (float)n), (int)((float)this.vwr.tm.height - this.pt0.y * (float)n), (int)this.vwr.tm.cameraDistance);
        this.g3d.fillSphereI(this.diameter, this.pt1i);
    }

    private void renderXyArrow(int n) {
        int n2 = 1 - n;
        P3[] p3Array = new P3[2];
        p3Array[n2] = this.pt1;
        p3Array[n] = this.pt0;
        this.pt0.set(this.screens[n].x, this.screens[n].y, this.screens[n].z);
        this.tm.rotatePoint(this.vertices[n2], this.pt1);
        this.pt1.z *= -1.0f;
        float f = this.vwr.getScreenDim();
        float f2 = f / 20.0f;
        this.pt1.scaleAdd2(this.dmesh.scale * f2, this.pt1, this.pt0);
        if (this.diameter == 0) {
            this.diameter = 1;
        }
        if (this.diameter < 0) {
            this.g3d.drawDashedLineBits(8, 4, this.pt0, this.pt1);
        } else {
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.pt0, this.pt1);
        }
        this.renderArrowHead(this.pt0, this.pt1, 0.0f, true, false, false);
    }

    private void renderArrowHead(T3 t3, T3 t32, float f, boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (this.dmesh.noHead) {
            return;
        }
        if (this.s0f == null) {
            this.s0f = new P3();
            this.s1f = new P3();
            this.s2f = new P3();
        }
        float f2 = this.getArrowScale();
        if (bl) {
            f2 *= 40.0f;
        }
        if (f > 0.0f) {
            f2 *= f;
        }
        this.pt0f.setT(t3);
        this.pt2f.setT(t32);
        float f3 = this.pt0f.distance(this.pt2f);
        if (f3 == 0.0f) {
            return;
        }
        this.vTemp.sub2(this.pt2f, this.pt0f);
        this.vTemp.normalize();
        this.vTemp.scale(f2 / 5.0f);
        if (!bl2) {
            this.pt2f.add(this.vTemp);
        }
        this.vTemp.scale(5.0f);
        this.pt1f.sub2(this.pt2f, this.vTemp);
        if (bl) {
            this.s1f.setT(this.pt1f);
            this.s2f.setT(this.pt2f);
        } else {
            this.tm.transformPtScrT3(this.pt2f, this.s2f);
            this.tm.transformPtScrT3(this.pt1f, this.s1f);
            this.tm.transformPtScrT3(this.pt0f, this.s0f);
        }
        if (this.s2f.z == 1.0f || this.s1f.z == 1.0f) {
            return;
        }
        if (this.diameter > 0) {
            n = this.diameter * 3;
        } else {
            this.vTemp.set(this.s2f.x - this.s1f.x, this.s2f.y - this.s1f.y, this.s2f.z - this.s1f.z);
            n = Math.round(this.vTemp.length() * 0.5f);
            this.diameter = n / 5;
        }
        if (this.diameter < 1) {
            this.diameter = 1;
        }
        if (n > 2) {
            this.g3d.fillConeScreen3f((byte)2, n, this.s1f, this.s2f, bl3);
        }
        if (bl2) {
            this.g3d.fillCylinderScreen3I((byte)2, this.diameter, this.s0f, this.s1f, null, null, 0.0f);
        }
    }

    private float getArrowScale() {
        float f;
        float f2 = f = this.dmesh.isScaleSet ? this.dmesh.scale : 0.0f;
        if (f == 0.0f) {
            f = this.vwr.getFloat(0x22000008) * (this.dmesh.connectedAtoms == null ? 1.0f : 0.5f);
        }
        if (f <= 0.0f) {
            f = 0.5f;
        }
        return f;
    }

    private void renderHandles() {
        int n = Math.round(10.0f * this.imageFontScaling);
        switch (this.drawType) {
            case NONE: {
                return;
            }
        }
        short s = C.getColixTranslucent3((short)23, true, 0.5f);
        this.bsHandles.clearAll();
        this.g3d.addRenderer(1073741880);
        int n2 = this.dmesh.pc;
        while (--n2 >= 0) {
            int[] nArray;
            if (!this.isPolygonDisplayable(n2) || (nArray = this.dmesh.pis[n2]) == null) continue;
            int n3 = this.dmesh.isDrawPolygon ? 3 : nArray.length;
            while (--n3 >= 0) {
                int n4 = nArray[n3];
                if (this.bsHandles.get(n4)) continue;
                this.bsHandles.set(n4);
                this.g3d.drawFilledCircle((short)23, s, n, this.screens[n4].x, this.screens[n4].y, this.screens[n4].z);
            }
        }
    }

    private void renderInfo() {
        if (this.isExport || this.mesh.title == null || this.vwr.getDrawHover() || !this.g3d.setC(this.vwr.cm.colixBackgroundContrast)) {
            return;
        }
        int n = this.dmesh.pc;
        while (--n >= 0) {
            if (!this.isPolygonDisplayable(n)) continue;
            float f = this.vwr.getFloat(0x2200000C);
            if (f <= 0.0f) {
                f = 14.0f;
            }
            this.vwr.gdata.setFontFid(this.vwr.gdata.getFontFid(f * this.imageFontScaling));
            String string = this.mesh.title[n < this.mesh.title.length ? n : this.mesh.title.length - 1];
            int n2 = 0;
            if (string.length() > 1 && string.charAt(0) == '>') {
                n2 = this.dmesh.pis[n].length - 1;
                string = string.substring(1);
                if (this.drawType == Draw.EnumDrawType.ARC) {
                    this.pt1f.setT(this.pt2f);
                }
            }
            if (this.drawType != Draw.EnumDrawType.ARC) {
                this.pt1f.setT(this.vertices[this.dmesh.pis[n][n2]]);
            }
            this.tm.transformPtScr(this.pt1f, this.pt1i);
            int n3 = Math.round(5.0f * this.imageFontScaling);
            this.g3d.drawString(string, null, this.pt1i.x + n3, this.pt1i.y - n3, this.pt1i.z, this.pt1i.z, (short)0);
            break;
        }
    }
}

