/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import javajs.util.PT;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;

public class GaussianDialog
extends JDialog
implements ActionListener,
ChangeListener,
MouseListener {
    Viewer vwr;
    private JPanel container;
    private JTextField checkField;
    private JTextField optsField;
    private JTextField fileField;
    private JTextField selectField;
    private JComboBox<String> memBox;
    private JComboBox<String> methBox;
    private JComboBox<String> basisBox;
    private JComboBox<String> dfBox;
    private JSpinner procSpinner;
    private JSpinner chargeSpinner;
    private JSpinner multSpinner;
    private JButton fileButton;
    private JButton saveButton;
    private JButton closeButton;
    private JButton refreshButton;
    private JFileChooser fileChooser;
    protected JTextPane editArea;
    private String check;
    private String mem;
    private String proc;
    private String file;
    private String meth;
    private String route;
    private String charge;
    private String mult;
    private String select;
    protected JScrollPane editPane;
    protected int iscroll;
    private static final String DEFAULT_METHOD = "HF";
    private static final String DEFAULT_BASIS = "3-21G**";
    private static final String DEFAULT_CHARGE = "0";
    private static final String DEFAULT_MULT = "1";
    private static final String[] BASIS_LIST = new String[]{"Gen", "3-21G", "3-21G*", "3-21G**", "6-21G", "4-31G", "6-31G", "6-311G", "D95V", "D95", "SHC", "CEP-4G", "CEP-31G", "CEP-121G", "LanL2MB", "LanL2DZ", "SDD", "SDDAll", "cc-pVDZ", "cc-pVTZ", "cc-pVQZ", "cc-pV5Z", "cc-pV6Z", "aug-cc-pVDZ", "aug-cc-pVTZ", "aug-cc-pVQZ", "aug-cc-pV5Z", "aug-cc-pV6Z", "SV", "SVP", "TZV", "TZVP", "MidiX", "EPR-II", "EPR-III", "UGBS", "UGBS1P", "UGBS2P", "UGBS3P", "MTSmall", "DGDZVP", "DGDZVP2", "DGTZVP"};
    private static final String[] METHOD_LIST = new String[]{"HF", "MP2", "MP3", "MP4", "CCSD(T)", "CIS", "CISD", "LSDA", "BLYP", "BP86", "BPW91", "OLYP", "OP86", "OPW91", "PBEPBE", "VSXC", "HCTH93", "HCTH147", "HCTH407", "TPSSTPSS", "B3LYP", "B3PW91", "AM1", "PM3", "CNDO", "INDO", "MNDO", "MINDO3", "ZINDO", "UFF", "AMBER", "DREIDING", "Huckel"};
    private static final String[] DF_LIST = new String[]{"None", "Auto", "DGA1", "DGA2"};
    private static final String[] MEMORY_LIST = new String[]{"Default", "100MB", "500MB", "1GB", "2GB", "4GB", "7GB", "15GB"};
    private static final String NOBASIS_LIST = "AM1 PM3 CNDO INDO MNDO MINDO3 ZINDO UFF AMBER DREIDING Huckel";
    private static final String DFT_LIST = "LSDA BLYP BP86 BPW91 OLYP OP86 OPW91 PBEPBE VSXC HCTH93 NCTH147 HCTH407 TPSSTPSS B3LYP B3PW91";

    public GaussianDialog(JFrame jFrame, Viewer viewer) {
        super((Frame)jFrame, false);
        this.vwr = viewer;
        this.setTitle(GT.$("Create Gaussian Input File"));
        this.container = new JPanel();
        this.container.setLayout(new BorderLayout());
        JPanel jPanel = this.buildBasicPanel();
        JPanel jPanel2 = this.buildAdvancedPanel();
        JPanel jPanel3 = this.buildFilePanel();
        JPanel jPanel4 = this.buildButtonPanel();
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        this.container.add((Component)jSplitPane, "North");
        this.container.add((Component)jPanel3, "Center");
        this.container.add((Component)jPanel4, "South");
        this.getContentPane().add(this.container);
        this.pack();
        this.centerDialog();
        this.updateUI();
    }

    private JPanel buildBasicPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("link0 Section");
        jPanel2.setBorder(titledBorder);
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        JPanel jPanel4 = new JPanel(new GridLayout(3, 1));
        JLabel jLabel = new JLabel(GT.$("Checkpoint File: "));
        jPanel3.add(jLabel);
        this.checkField = new JTextField(20);
        jPanel4.add(this.checkField);
        this.checkField.addActionListener(this);
        JLabel jLabel2 = new JLabel(GT.$("Memory:"));
        jPanel3.add(jLabel2);
        this.memBox = new JComboBox<String>(MEMORY_LIST);
        jPanel4.add(this.memBox);
        this.memBox.setSelectedIndex(0);
        this.memBox.addActionListener(this);
        JLabel jLabel3 = new JLabel(GT.$("Processors:"));
        jPanel3.add(jLabel3);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 16, 1);
        this.procSpinner = new JSpinner(spinnerNumberModel);
        this.procSpinner.setEditor(new JSpinner.NumberEditor(this.procSpinner, "#"));
        jPanel4.add(this.procSpinner);
        this.procSpinner.addChangeListener(this);
        jPanel2.add((Component)jPanel3, "Before");
        jPanel2.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(GT.$("Route"));
        jPanel5.setBorder(titledBorder2);
        JPanel jPanel6 = new JPanel(new GridLayout(4, 1));
        JPanel jPanel7 = new JPanel(new GridLayout(4, 1));
        JLabel jLabel4 = new JLabel(GT.$("Method: "));
        jPanel6.add(jLabel4);
        this.methBox = new JComboBox<String>(METHOD_LIST);
        jPanel7.add(this.methBox);
        this.methBox.setSelectedIndex(0);
        this.methBox.addActionListener(this);
        JLabel jLabel5 = new JLabel(GT.$("Basis Set: "));
        jPanel6.add(jLabel5);
        this.basisBox = new JComboBox<String>(BASIS_LIST);
        jPanel7.add(this.basisBox);
        this.basisBox.setSelectedIndex(3);
        this.basisBox.addActionListener(this);
        JLabel jLabel6 = new JLabel(GT.$("DFT Density Fit: "));
        jPanel6.add(jLabel6);
        this.dfBox = new JComboBox<String>(DF_LIST);
        jPanel7.add(this.dfBox);
        this.dfBox.setSelectedIndex(0);
        this.dfBox.addActionListener(this);
        JLabel jLabel7 = new JLabel(GT.$("Job Options: "));
        jPanel6.add(jLabel7);
        this.optsField = new JTextField(20);
        jPanel7.add(this.optsField);
        this.optsField.setText("opt pop=full gfprint");
        this.optsField.addActionListener(this);
        jPanel5.add((Component)jPanel6, "Before");
        jPanel5.add((Component)jPanel7, "Center");
        jPanel.add((Component)jPanel5, "Center");
        JPanel jPanel8 = new JPanel(new BorderLayout());
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(GT.$("Molecular Properties"));
        jPanel8.setBorder(titledBorder3);
        JPanel jPanel9 = new JPanel(new GridLayout(3, 1));
        JPanel jPanel10 = new JPanel(new GridLayout(3, 1));
        JLabel jLabel8 = new JLabel(GT.$("Total Charge: "));
        jPanel9.add(jLabel8);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(0, -10, 10, 1);
        this.chargeSpinner = new JSpinner(spinnerNumberModel2);
        this.chargeSpinner.setEditor(new JSpinner.NumberEditor(this.chargeSpinner, "#"));
        jPanel10.add(this.chargeSpinner);
        this.chargeSpinner.addChangeListener(this);
        JLabel jLabel9 = new JLabel(GT.$("Multiplicity: "));
        jPanel9.add(jLabel9);
        SpinnerNumberModel spinnerNumberModel3 = new SpinnerNumberModel(1, 0, 10, 1);
        this.multSpinner = new JSpinner(spinnerNumberModel3);
        this.multSpinner.setEditor(new JSpinner.NumberEditor(this.multSpinner, "#"));
        jPanel10.add(this.multSpinner);
        this.multSpinner.addChangeListener(this);
        jPanel8.add((Component)jPanel9, "Before");
        jPanel8.add((Component)jPanel10, "Center");
        jPanel.add((Component)jPanel8, "South");
        return jPanel;
    }

    private JPanel buildAdvancedPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Edit Gaussian Input File");
        jPanel.setBorder(titledBorder);
        this.editArea = new JTextPane();
        this.editArea.setContentType("text/html");
        this.editArea.setFont(new Font("Monospaced", 0, 8));
        this.editArea.addMouseListener(this);
        this.editPane = new JScrollPane(this.editArea);
        this.editPane.setPreferredSize(new Dimension(150, 100));
        jPanel.add((Component)this.editPane, "Center");
        return jPanel;
    }

    private JPanel buildFilePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(GT.$("Gaussian Input File Name"));
        jPanel.setBorder(titledBorder);
        this.fileField = new JTextField(30);
        jPanel.add(this.fileField);
        this.fileField.setText(new File("my_input.com").getAbsolutePath());
        this.fileButton = new JButton(GT.$("File..."));
        this.fileButton.addActionListener(this);
        jPanel.add(this.fileButton);
        return jPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JLabel jLabel = new JLabel(GT.$("Selection: "));
        jPanel.add(jLabel);
        this.selectField = new JTextField(20);
        this.selectField.setText("visible");
        jPanel.add(this.selectField);
        this.selectField.addActionListener(this);
        this.refreshButton = new JButton(GT.$("Refresh"));
        this.refreshButton.addActionListener(this);
        jPanel.add(this.refreshButton);
        this.saveButton = new JButton(GT.$("Save"));
        this.saveButton.addActionListener(this);
        jPanel.add(this.saveButton);
        this.closeButton = new JButton(GT.$("Close"));
        this.closeButton.addActionListener(this);
        jPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.saveButton);
        return jPanel;
    }

    protected void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    private void updateVars() {
        String string;
        this.check = this.checkField.getText();
        this.mem = this.memBox.getSelectedItem().toString();
        this.proc = this.procSpinner.getValue().toString();
        this.select = this.selectField.getText();
        if (this.select.length() == 0) {
            this.select = "visible";
            this.selectField.setText(this.select);
        }
        this.charge = this.chargeSpinner.getValue().toString();
        if (this.charge.equals("")) {
            this.charge = DEFAULT_CHARGE;
        }
        this.mult = this.multSpinner.getValue().toString();
        if (this.mult.equals("")) {
            this.mult = DEFAULT_MULT;
        }
        if ((string = (String)this.basisBox.getSelectedItem()).equals("")) {
            string = DEFAULT_BASIS;
        }
        this.meth = this.methBox.getSelectedItem().toString();
        if (this.meth.equals("")) {
            this.meth = DEFAULT_METHOD;
        }
        if (NOBASIS_LIST.lastIndexOf(this.meth, NOBASIS_LIST.length()) >= 0) {
            string = "";
        }
        if (!string.equals("")) {
            string = "/" + string;
        }
        String string2 = this.dfBox.getSelectedItem().toString();
        if (DFT_LIST.lastIndexOf(this.meth, DFT_LIST.length()) < 0) {
            string2 = "None";
        }
        string2 = string2.equals("None") ? "" : "/" + string2;
        this.file = this.fileField.getText();
        if (this.file.equals("")) {
            this.file = "my_input.com";
        }
        String string3 = this.optsField.getText();
        this.route = "# " + this.meth + string + string2 + " " + string3;
    }

    private void updateUI() {
        this.updateVars();
        if (NOBASIS_LIST.lastIndexOf(this.meth, NOBASIS_LIST.length()) >= 0) {
            this.basisBox.setEnabled(false);
        } else {
            this.basisBox.setEnabled(true);
        }
        if (DFT_LIST.lastIndexOf(this.meth, DFT_LIST.length()) >= 0) {
            this.dfBox.setEnabled(true);
        } else {
            this.dfBox.setEnabled(false);
        }
        this.getCommand(-2, true);
    }

    private void save() {
        BufferedWriter bufferedWriter = null;
        try {
            String string = this.editArea.getText();
            if (string.indexOf("<pre>") < 0) {
                this.getCommand(-1, true);
                string = this.editArea.getText();
            }
            File file = new File(this.fileField.getText());
            this.fileField.setText(file.getAbsolutePath());
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(this.asHTML(string, false));
            ((Writer)bufferedWriter).close();
        }
        catch (Exception exception) {
            return;
        }
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.vwr.script("select off");
        super.dispose();
    }

    private void setFile() {
        this.fileChooser = new JFileChooser();
        String string = this.fileField.getText();
        this.fileChooser.setSelectedFile(new File(string));
        int n = this.fileChooser.showDialog(this, "Set");
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.fileField.setText(file.getAbsolutePath());
        }
    }

    protected void getCommand(int n, boolean bl) {
        String string;
        this.updateVars();
        String string2 = this.check;
        if (!string2.equals("")) {
            string2 = "%chk=" + string2 + "\n";
        }
        string = !(string = this.mem).equals("Default") ? "%mem=" + string + "\n" : "";
        String string3 = this.proc;
        string3 = !string3.equals(DEFAULT_MULT) ? "%nproc=" + string3 + "\n" : "";
        String string4 = "USER:%-2e %10.5x %10.5y %10.5z";
        String string5 = this.vwr.getData(this.select, string4);
        this.iscroll = 0;
        if (n >= 0) {
            String string6 = this.vwr.getData("atomIndex=" + n, string4);
            this.iscroll = string5.indexOf(string6);
            if (this.iscroll >= 0) {
                string5 = PT.rep(string5, string6, "<b><font color=\"red\">" + PT.rep(string6, "\n", "") + "&#160;&#160;&lt;&lt;&lt;</font></b>\n");
            }
            int n2 = this.editPane.getVerticalScrollBar().getMaximum();
            this.iscroll = (int)((double)this.iscroll * 1.0 / (double)string5.length() * (double)n2);
        } else if (n == -1) {
            this.iscroll = -1;
        }
        if (!bl) {
            this.iscroll = this.editPane.getVerticalScrollBar().getValue();
        }
        this.editArea.setText(this.asHTML(String.valueOf(string2) + string + string3 + this.route + "\n\n" + "Title: <b>Created by Jmol</b> version " + Viewer.getJmolVersion() + "\n\n" + this.charge + " " + this.mult + "\n" + string5 + "\n", true));
        if (this.iscroll >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        GaussianDialog.this.editPane.getVerticalScrollBar().setValue(GaussianDialog.this.iscroll);
                    }
                    catch (Exception exception) {
                        GaussianDialog.this.editPane.getVerticalScrollBar().setValue(0);
                    }
                }
            });
        }
    }

    protected String asHTML(String string, boolean bl) {
        if (bl) {
            return "<html><small><pre>" + string + "</pre></small></html>";
        }
        if (string.indexOf("<pre>") >= 0) {
            string = PT.rep(string, "<b>", "");
            string = PT.rep(string, "</b>", "");
            string = PT.rep(string, "<font color=\"red\">", "");
            string = PT.rep(string, "</font>", "");
            string = PT.rep(string, "&lt;", "");
            string = PT.rep(string, "&#160;", "");
            string = PT.split(string, "<pre>")[1];
            string = PT.split(string, "</pre>")[0];
        }
        return String.valueOf(string.trim()) + "\n";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveButton) {
            this.save();
        } else if (object == this.closeButton) {
            this.cancel();
        } else if (object == this.fileButton) {
            this.setFile();
        } else if (object == this.refreshButton) {
            this.getCommand(-2, true);
        } else {
            this.updateUI();
        }
    }

    public void updateModel(int n) {
        this.getCommand(n, true);
        if (n >= 0) {
            this.vwr.script("select on atomindex=" + n);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.getCommand(-2, true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.editArea) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = GaussianDialog.this.asHTML(GaussianDialog.this.editArea.getText(), false);
                        int n = GaussianDialog.this.editArea.getCaretPosition();
                        int n2 = string.lastIndexOf("\n", n) + 5;
                        int n3 = string.indexOf("\n", n);
                        String string2 = string.substring(n2, n3);
                        if (Float.isNaN(PT.parseFloat(string2))) {
                            return;
                        }
                        GaussianDialog.this.vwr.scriptWait("select on within(0.1,{" + string2 + "})");
                        GaussianDialog.this.getCommand(GaussianDialog.this.vwr.bsA().nextSetBit(0), false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

