/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awtjs.swing;

import javajs.awt.Container;
import javajs.util.SB;
import org.jmol.awtjs.swing.JComponent;
import org.jmol.awtjs.swing.JComponentImp;

public class JSplitPane
extends JComponent {
    public static final int HORIZONTAL_SPLIT = 1;
    boolean isH = true;
    private int split = 1;
    private Container right;
    private Container left;

    public JSplitPane(int split) {
        super("JSpP");
        this.split = split;
        this.isH = split == 1;
    }

    public void setRightComponent(JComponent r) {
        this.right = new JComponentImp(null);
        this.right.add(r);
    }

    public void setLeftComponent(JComponent l) {
        this.left = new JComponentImp(null);
        this.left.add(l);
    }

    @Override
    public int getSubcomponentWidth() {
        int w = this.width;
        if (w == 0) {
            int wleft = this.left.getSubcomponentWidth();
            int wright = this.right.getSubcomponentWidth();
            if (wleft > 0 && wright > 0) {
                w = this.isH ? wleft + wright : Math.max(wleft, wright);
            }
        }
        return w;
    }

    @Override
    public int getSubcomponentHeight() {
        int h = this.height;
        if (h == 0) {
            int hleft = this.left.getSubcomponentHeight();
            int hright = this.right.getSubcomponentHeight();
            if (hleft > 0 && hright > 0) {
                h = this.isH ? Math.max(hleft, hright) : hleft + hright;
            }
        }
        return h;
    }

    @Override
    public String toHTML() {
        boolean isH;
        if (this.left == null || this.right == null) {
            return "";
        }
        boolean bl = isH = this.split == 1;
        if (this.width == 0) {
            this.width = this.getSubcomponentWidth();
        }
        if (this.height == 0) {
            this.height = this.getSubcomponentHeight();
        }
        SB sb = new SB();
        sb.append("<div id='" + this.id + "' class='JSplitPane' style='" + this.getCSSstyle(100, 100) + "'>");
        if (isH) {
            sb.append("<div id='" + this.id + "_left' style='width:50%;height:100%;position:absolute;top:0%;left:0%'>");
        } else {
            sb.append("<div id='" + this.id + "_top' style='width:100%;height:50%;position:absolute;top:0%;left:0%'>");
        }
        sb.append(this.left.getComponents()[0].toHTML());
        if (isH) {
            sb.append("</div><div id='" + this.id + "_right' style='width:50%;height:100%;position:absolute;top:0%;left:50%'>");
        } else {
            sb.append("</div><div id='" + this.id + "_bottom' style='width:100%;height:50%;position:absolute;top:50%;left:0%'>");
        }
        sb.append(this.right.getComponents()[0].toHTML());
        sb.append("</div></div>\n");
        return sb.toString();
    }
}

