/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.PT;
import jspecview.application.MainFrame;
import org.jmol.api.JSVInterface;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolSyncInterface;
import org.jmol.c.CBK;
import org.jmol.dialog.Dialog;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.JmolPlugin;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.console.AppConsole;
import org.openscience.jmol.app.webexport.WebExport;

class StatusListener
implements JmolStatusListener,
JmolSyncInterface,
JSVInterface {
    private JmolPanel jmol;
    private DisplayPanel display;
    private Viewer vwr;
    private MainFrame jSpecViewFrame;
    private boolean jSpecViewForceNew;
    private Map<String, Object> nboOptions;
    private int modificationMode;
    private String lastSimulate;
    private static String propertiesFileName = "jspecview.properties";

    void setViewer(Viewer vwr) {
        this.vwr = vwr;
    }

    StatusListener(JmolPanel jmol, DisplayPanel display) {
        this.jmol = jmol;
        this.display = display;
    }

    @Override
    public boolean notifyEnabled(CBK type) {
        switch (type) {
            case ANIMFRAME: 
            case ECHO: 
            case IMAGE: 
            case LOADSTRUCT: 
            case STRUCTUREMODIFIED: 
            case MEASURE: 
            case MESSAGE: 
            case SERVICE: 
            case PICK: 
            case SCRIPT: 
            case SYNC: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyCallback(CBK type, Object[] data) {
        JmolCallbackListener appConsole;
        if (!this.jmol.plugins.isEmpty()) {
            for (JmolPlugin p : this.jmol.plugins.values()) {
                p.notifyCallback(type, data);
            }
        }
        String strInfo = data == null || data[1] == null ? null : data[1].toString();
        switch (type) {
            case LOADSTRUCT: {
                this.notifyFileLoaded(strInfo, (String)data[2], (String)data[3], (String)data[4], (Boolean)data[8]);
                if (this.jmol.gaussianDialog != null) {
                    this.jmol.gaussianDialog.updateModel(-2);
                }
                return;
            }
            case ANIMFRAME: {
                int[] iData = (int[])data[1];
                int modelIndex = iData[0];
                if (modelIndex <= -2) {
                    modelIndex = -2 - modelIndex;
                }
                if (this.display.haveDisplay) {
                    String menuName = (String)data[2];
                    if (menuName.equals("0.0: ")) {
                        menuName = "";
                    }
                    this.display.status.setStatus(1, menuName);
                    if (this.jmol.frame != null) {
                        this.jmol.frame.setTitle(menuName);
                    }
                }
                return;
            }
            case SCRIPT: {
                int msWalltime = (Integer)data[3];
                if (msWalltime == 0 && data[2] != null && this.display.haveDisplay) {
                    this.display.status.setStatus(1, (String)data[2]);
                }
                return;
            }
            case ECHO: {
                break;
            }
            case MEASURE: {
                String mystatus = (String)data[3];
                if (mystatus.indexOf("Sequence") >= 0) break;
                if (mystatus.indexOf("Pending") < 0 && this.display.haveDisplay) {
                    this.display.measurementTable.updateTables();
                }
                if (mystatus.indexOf("Picked") >= 0) {
                    this.notifyAtomPicked(strInfo);
                    break;
                }
                if (mystatus.indexOf("Completed") >= 0) break;
                return;
            }
            case MESSAGE: {
                break;
            }
            case SERVICE: {
                if (this.display == null) {
                    return;
                }
                Map info = (Map)data[1];
                try {
                    String service = (String)info.get("service");
                    if ("nbo".equals(service) && "showPanel".equals(info.get("action"))) {
                        this.jmol.startNBO(info);
                    }
                }
                catch (Exception service) {
                    // empty catch block
                }
                return;
            }
            case PICK: {
                this.notifyAtomPicked(strInfo);
                if (this.jmol.gaussianDialog == null) break;
                this.jmol.gaussianDialog.updateModel((Integer)data[2]);
                break;
            }
            case STRUCTUREMODIFIED: {
                int mode = (Integer)data[1];
                int atomIndex = (Integer)data[2];
                int modelIndexx = (Integer)data[3];
                this.notifyStructureModified(atomIndex, modelIndexx, mode);
                if (this.jmol.gaussianDialog == null) break;
                this.jmol.gaussianDialog.updateModel(-1);
                break;
            }
            case SYNC: {
                String lc;
                String string = lc = strInfo == null ? "" : strInfo.toLowerCase();
                if (lc.startsWith("jspecview")) {
                    this.setJSpecView(strInfo.substring(9).trim(), false, false);
                    return;
                }
                if (lc.equals("getpreference")) {
                    data[0] = data[2] == null ? this.jmol.preferencesDialog : this.jmol.getPreference(data[2].toString());
                    return;
                }
                if (strInfo != null && strInfo.toLowerCase().startsWith("nbo:")) {
                    if (this.nboOptions == null) {
                        this.nboOptions = new Hashtable<String, Object>();
                    }
                    this.nboOptions.put("options", strInfo);
                    this.jmol.startNBO(this.nboOptions);
                    return;
                }
                this.jmol.sendNioMessage((Integer)data[3], strInfo);
                return;
            }
            case IMAGE: 
            case AUDIO: 
            case EVAL: 
            case ATOMMOVED: 
            case CLICK: 
            case DRAGDROP: 
            case ERROR: 
            case HOVER: 
            case MINIMIZATION: 
            case RESIZE: 
            case APPLETREADY: {
                return;
            }
        }
        if (this.jmol.service != null) {
            this.jmol.service.scriptCallback(strInfo);
        }
        if ((appConsole = (JmolCallbackListener)this.vwr.getProperty("DATA_API", "getAppConsole", null)) != null) {
            appConsole.notifyCallback(type, data);
        }
    }

    private void notifyStructureModified(int atomIndex, int modelIndex, int mode) {
        this.modificationMode = mode;
        if (mode < 0) {
            switch (mode) {
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    this.checkJSpecView(false);
                    return;
                }
            }
        }
    }

    @Override
    public void setCallbackFunction(String callbackType, String callbackFunction) {
        if (callbackType.equals("modelkit")) {
            if (callbackFunction.equals("ON")) {
                this.display.buttonModelkit.setSelected(true);
            } else {
                this.display.buttonRotate.setSelected(true);
            }
            return;
        }
        if (callbackType.equalsIgnoreCase("language")) {
            AppConsole appConsole;
            JmolResourceHandler.clear();
            Dialog.setupUIManager();
            if (this.jmol.webExport != null) {
                WebExport.saveHistory();
                WebExport.dispose();
                this.jmol.createWebExport();
            }
            if ((appConsole = (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null)) != null) {
                appConsole.sendConsoleEcho(null);
            }
            this.jmol.updateLabels();
            return;
        }
    }

    @Override
    public String eval(String strEval) {
        String msg = "# this funcationality is implemented only for the applet.\n" + strEval;
        this.sendConsoleMessage(msg);
        return msg;
    }

    @Override
    public String createImage(String fileName, String type, Object text_or_bytes, int quality) {
        return null;
    }

    private void notifyAtomPicked(String info) {
        if (this.display.haveDisplay) {
            this.display.status.setStatus(1, info);
        }
    }

    private void notifyFileLoaded(String fullPathName, String fileName, String modelName, String errorMsg, Boolean isAsync) {
        if (errorMsg != null) {
            return;
        }
        if (!this.display.haveDisplay) {
            return;
        }
        String title = "Jmol";
        if (fileName != null && fileName.startsWith("DROP_")) {
            fileName = fileName.substring(5);
        }
        if (modelName != null && fileName != null) {
            title = (fileName.contains("&") ? "" : fileName + " - ") + modelName;
        } else if (fileName != null) {
            title = fileName;
        } else if (modelName != null) {
            title = modelName;
        }
        this.jmol.notifyFileOpen(fullPathName == null ? null : fullPathName + (isAsync == Boolean.TRUE ? " (*)" : ""), title);
        this.checkJSpecView(fullPathName == null);
    }

    private void sendConsoleMessage(String strStatus) {
        JmolAppConsoleInterface appConsole = (JmolAppConsoleInterface)this.vwr.getProperty("DATA_API", "getAppConsole", null);
        if (appConsole != null) {
            appConsole.sendConsoleMessage(strStatus);
        }
    }

    @Override
    public void showUrl(String url) {
        try {
            Class<?> c = Class.forName("java.awt.Desktop");
            Method getDesktop = c.getMethod("getDesktop", new Class[0]);
            Object deskTop = getDesktop.invoke(null, new Object[0]);
            Method browse = c.getMethod("browse", URI.class);
            Object[] arguments = new Object[]{new URI(url)};
            browse.invoke(deskTop, arguments);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            JmolAppConsoleInterface appConsole = (JmolAppConsoleInterface)this.vwr.getProperty("DATA_API", "getAppConsole", null);
            if (appConsole != null) {
                appConsole.sendConsoleMessage("Java 6 Desktop.browse() capability unavailable. Could not open " + url);
            }
            Logger.error("Java 6 Desktop.browse() capability unavailable. Could not open " + url);
        }
    }

    @Override
    public float[][] functionXY(String functionName, int nX, int nY) {
        nX = Math.abs(nX);
        nY = Math.abs(nY);
        float[][] f = new float[nX][nY];
        int i = nX;
        while (--i >= 0) {
            int j = nY;
            while (--j >= 0) {
                float x = (float)i / 5.0f;
                float y = (float)j / 5.0f;
                f[i][j] = x * x + y;
                if (!Float.isNaN(f[i][j])) continue;
                f[i][j] = -((float)Math.sqrt(-x * x - y));
            }
        }
        return f;
    }

    @Override
    public float[][][] functionXYZ(String functionName, int nX, int nY, int nZ) {
        nX = Math.abs(nX);
        nY = Math.abs(nY);
        nZ = Math.abs(nZ);
        float[][][] f = new float[nX][nY][nZ];
        int i = nX;
        while (--i >= 0) {
            int j = nY;
            while (--j >= 0) {
                int k = nZ;
                while (--k >= 0) {
                    float x = (float)i / ((float)(nX - 1) / 2.0f) - 1.0f;
                    float y = (float)j / ((float)(nY - 1) / 2.0f) - 1.0f;
                    float z = (float)k / ((float)(nZ - 1) / 2.0f) - 1.0f;
                    f[i][j][k] = x * x + y * y - z * z;
                }
            }
        }
        return f;
    }

    @Override
    public Map<String, Object> getRegistryInfo() {
        return null;
    }

    @Override
    public int[] resizeInnerPanel(String data) {
        return this.jmol.resizeInnerPanel(data);
    }

    private void checkJSpecView(boolean closeAll) {
        if (this.jSpecViewFrame != null && this.modificationMode <= 0) {
            this.jSpecViewForceNew = this.jSpecViewFrame.isVisible();
            this.setJSpecView(closeAll ? "none" : "", true, true);
            this.jSpecViewForceNew = true;
        }
    }

    public void setJSpecView(String peaks, boolean doLoadCheck, boolean isFileLoad) {
        if (peaks.startsWith(":")) {
            peaks = peaks.substring(1);
        }
        if (peaks.equals("none") || peaks.equals("NONESimulate:")) {
            if (this.jSpecViewFrame != null) {
                this.jSpecViewFrame.syncScript("close ALL");
                this.jSpecViewFrame.awaken(false);
            }
            return;
        }
        boolean isC13 = peaks.equals("C13Simulate:");
        boolean isSimulation = peaks.equals("H1Simulate:") || isC13;
        boolean isStartup = peaks.length() == 0 || isSimulation;
        boolean newSim = isSimulation && !peaks.equals(this.lastSimulate);
        String data = null;
        if (isSimulation && ((data = this.vwr.extractMolData(null)) == null || data.length() == 0)) {
            return;
        }
        if (this.jSpecViewFrame == null) {
            this.jSpecViewFrame = new MainFrame(this.vwr.getBoolean(603979869) ? (Component)this.vwr.display : null, this);
            this.jSpecViewFrame.setSize(Math.max(1000, this.jmol.frame.getWidth() + 50), 600);
            this.jSpecViewFrame.setLocation(this.jmol.frame.getLocation().x + 10, this.jmol.frame.getLocation().y + 100);
            this.jSpecViewFrame.register("Jmol", this);
            this.vwr.setBooleanProperty("_jspecview", true);
            if (isStartup) {
                doLoadCheck = true;
            }
        }
        if (doLoadCheck || this.jSpecViewForceNew || newSim) {
            String type = "" + this.vwr.getP("_modelType");
            if (type.equalsIgnoreCase("jcampdx")) {
                this.jSpecViewForceNew = false;
                String file = "" + this.vwr.getP("_modelFile");
                if (file.indexOf("/") < 0) {
                    return;
                }
                peaks = "hidden true; load CHECK " + PT.esc(file) + ";hidden false" + (newSim && isC13 ? ";scaleby 0.5" : null);
            } else {
                if (isFileLoad && !this.jSpecViewForceNew && !newSim) {
                    return;
                }
                this.jSpecViewForceNew = false;
                if (newSim) {
                    this.lastSimulate = peaks;
                }
                String model = "" + this.vwr.getP("_modelNumber");
                if (data == null) {
                    peaks = "hidden false";
                } else {
                    data = PT.replaceAllCharacters(data, "&", "_");
                    peaks = "hidden true; load CHECK " + (peaks.equals("H1Simulate:") ? "H1 " : "C13 ") + PT.esc("id='~" + model + "';" + data) + ";hidden false #SYNC_PEAKS";
                }
                isStartup = false;
            }
        }
        if (!this.jSpecViewFrame.isVisible()) {
            if (peaks.contains("<PeakData")) {
                return;
            }
            this.jSpecViewFrame.awaken(true);
            this.display.setViewer(this.vwr);
        }
        if (isStartup) {
            peaks = "HIDDEN false";
        }
        this.jSpecViewFrame.syncScript(peaks);
    }

    @Override
    public void register(String id, JmolSyncInterface jsi) {
    }

    @Override
    public void syncScript(String script) {
        this.jmol.syncScript(script);
    }

    @Override
    public void setProperties(Properties properties) {
        try {
            FileInputStream fileIn = new FileInputStream(propertiesFileName);
            properties.load(fileIn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveProperties(Properties properties) {
        try {
            FileOutputStream fileOut = new FileOutputStream(propertiesFileName);
            properties.store(fileOut, "JSpecView Application Properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitJSpecView(boolean withDialog, Object frame) {
    }

    @Override
    public void runScript(String script) {
        this.jSpecViewFrame.runScriptNow(script);
    }

    @Override
    public void syncToJmol(String msg) {
    }

    @Override
    public Map<String, Object> getJSpecViewProperty(String type) {
        if (type.toLowerCase().startsWith("jspecview")) {
            if ((type = type.substring(9)).startsWith(":")) {
                type = type.substring(1);
            }
            return this.jSpecViewFrame == null ? null : this.jSpecViewFrame.getJSpecViewProperty(type);
        }
        return null;
    }
}

