/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.Lst;
import jspecview.common.Coordinate;
import jspecview.common.ScaleData;
import jspecview.common.Spectrum;

public class ViewData {
    private ScaleData[] scaleData;
    private ScaleData thisScale;
    private int nSpectra;
    private int iThisScale;
    private Lst<Spectrum> spectra;

    public ScaleData[] getScaleData() {
        return this.scaleData;
    }

    public ScaleData getScale() {
        return this.thisScale;
    }

    public ViewData(Lst<Spectrum> spectra, double yPt1, double yPt2, int[] startList, int[] endList, boolean isContinuous, boolean is2D) {
        this.nSpectra = is2D ? 1 : spectra.size();
        this.scaleData = new ScaleData[this.nSpectra];
        for (int j = 0; j < this.nSpectra; ++j) {
            this.scaleData[j] = new ScaleData(startList[j], endList[j]);
        }
        this.init(spectra, yPt1, yPt2, isContinuous);
    }

    public ViewData(Lst<Spectrum> spectra, double yPt1, double yPt2, boolean isContinuous) {
        this.nSpectra = spectra.size();
        int n = ((Spectrum)spectra.get(0)).getXYCoords().length;
        this.scaleData = new ScaleData[1];
        this.scaleData[0] = new ScaleData(0, n - 1);
        this.init(spectra, yPt1, yPt2, isContinuous);
    }

    void init(Lst<Spectrum> spectra, double yPt1, double yPt2, boolean isContinuous) {
        if (spectra == null) {
            spectra = this.spectra;
        } else {
            this.spectra = spectra;
        }
        this.iThisScale = 0;
        this.thisScale = this.scaleData[0];
        for (int i = 0; i < this.scaleData.length; ++i) {
            this.scaleData[i].userYFactor = ((Spectrum)spectra.get(i)).getUserYFactor();
            this.scaleData[i].spectrumYRef = ((Spectrum)spectra.get(i)).getYRef();
        }
        this.resetScaleFactors();
        double minX = Coordinate.getMinX(spectra, this);
        double maxX = Coordinate.getMaxX(spectra, this);
        double minY = Coordinate.getMinYUser(spectra, this);
        double maxY = Coordinate.getMaxYUser(spectra, this);
        if (yPt1 != yPt2 && (minY = yPt1) > (maxY = yPt2)) {
            double t = minY;
            minY = maxY;
            maxY = t;
        }
        boolean isInverted = ((Spectrum)spectra.get(0)).isInverted();
        for (int i = 0; i < this.scaleData.length; ++i) {
            this.scaleData[i].setMinMax(minX, maxX, minY, maxY);
            this.scaleData[i].setScale(isContinuous, isInverted);
        }
    }

    public void newSpectrum(Lst<Spectrum> spectra) {
        this.init(spectra, 0.0, 0.0, false);
    }

    public void setXRangeForSubSpectrum(Coordinate[] xyCoords) {
        this.setXRange(0, xyCoords, this.scaleData[0].minX, this.scaleData[0].maxX, 0, xyCoords.length - 1);
    }

    private int setXRange(int i, Coordinate[] xyCoords, double initX, double finalX, int iStart, int iEnd) {
        double x;
        int index = 0;
        int ptCount = 0;
        for (index = iStart; index <= iEnd; ++index) {
            x = xyCoords[index].getXVal();
            if (!(x >= initX)) continue;
            this.scaleData[i % this.scaleData.length].startDataPointIndex = index;
            break;
        }
        while (index <= iEnd) {
            x = xyCoords[index].getXVal();
            ++ptCount;
            if (x >= finalX) break;
            ++index;
        }
        this.scaleData[i % this.scaleData.length].endDataPointIndex = index - 1;
        return ptCount;
    }

    public int getStartingPointIndex(int i) {
        return this.scaleData[i % this.scaleData.length].startDataPointIndex;
    }

    public int getEndingPointIndex(int i) {
        return this.scaleData[i % this.scaleData.length].endDataPointIndex;
    }

    public boolean areYScalesSame(int i, int j) {
        return this.scaleData[i %= this.scaleData.length].minYOnScale == this.scaleData[j %= this.scaleData.length].minYOnScale && this.scaleData[i].maxYOnScale == this.scaleData[j].maxYOnScale;
    }

    public void setScale(int i, int xPixels, int yPixels, boolean isInverted) {
        this.iThisScale = i % this.scaleData.length;
        this.thisScale = this.scaleData[this.iThisScale];
        this.thisScale.setXYScale(xPixels, yPixels, isInverted);
    }

    public void resetScaleFactors() {
        for (int i = 0; i < this.scaleData.length; ++i) {
            this.scaleData[i].spectrumScaleFactor = 1.0;
        }
    }

    public void scaleSpectrum(int i, double f) {
        if (f <= 0.0 || i >= this.nSpectra) {
            return;
        }
        if (i == -2) {
            this.thisScale.scale2D(f);
            return;
        }
        if (i < 0) {
            for (i = 0; i < this.scaleData.length; ++i) {
                this.scaleData[i].scaleBy(f);
            }
        } else {
            this.scaleData[i % this.scaleData.length].scaleBy(f);
        }
    }

    public ScaleData[] getNewScales(int iSelected, boolean isXOnly, double y1, double y2) {
        int i;
        if (isXOnly) {
            return this.scaleData;
        }
        iSelected %= this.scaleData.length;
        double f1 = (y1 - this.thisScale.minYOnScale) / (this.thisScale.maxYOnScale - this.thisScale.minYOnScale);
        double f2 = (y2 - this.thisScale.minYOnScale) / (this.thisScale.maxYOnScale - this.thisScale.minYOnScale);
        ScaleData[] sd = new ScaleData[this.scaleData.length];
        for (i = 0; i < this.scaleData.length; ++i) {
            sd[i] = iSelected >= 0 && i != iSelected ? this.scaleData[i] : new ScaleData();
        }
        ScaleData.copyScaleFactors(this.scaleData, sd);
        ScaleData.copyYScales(this.scaleData, sd);
        for (i = 0; i < this.scaleData.length; ++i) {
            if (iSelected >= 0 && i != iSelected) continue;
            sd[i].isShiftZoomedY = true;
            sd[i].minYOnScale = this.scaleData[i].minYOnScale * (1.0 - f1) + f1 * this.scaleData[i].maxYOnScale;
            sd[i].maxYOnScale = this.scaleData[i].minYOnScale * (1.0 - f2) + f2 * this.scaleData[i].maxYOnScale;
        }
        return sd;
    }
}

