/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.icons;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import net.sf.sdedit.util.UIUtilities;
import net.sf.sdedit.util.Utilities;

public final class Icons {
    private static Map<String, ImageIcon> cache = new HashMap<String, ImageIcon>();
    private static List<String> bases = new LinkedList<String>();
    private static Set<String> notFound = new HashSet<String>();

    private Icons() {
    }

    public static final ImageIcon getIcon(String name) {
        ImageIcon icon;
        block10: {
            icon = cache.get(name);
            if (icon != null) {
                return icon;
            }
            if (notFound.contains(name)) {
                return null;
            }
            try {
                if (name.indexOf(92) > 0) {
                    for (String subName : name.split("\\\\")) {
                        ImageIcon subIcon = Icons.getIcon(subName);
                        if (subIcon == null) {
                            icon = null;
                            break block10;
                        }
                        if (icon == null) {
                            icon = subIcon;
                            continue;
                        }
                        Image join = UIUtilities.joinImages(icon.getImage(), subIcon.getImage(), 2, 2);
                        icon = new ImageIcon(join);
                    }
                    break block10;
                }
                URL res = Icons.findRes(name);
                if (res == null) {
                    notFound.add(name);
                    return null;
                }
                icon = new ImageIcon(res);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cache.put(name, icon);
        return icon;
    }

    public static void addBase(String base) {
        bases.add(base);
    }

    private static URL findRes(String name) {
        URL res = Utilities.getResource(name + ".png");
        if (res == null) {
            for (String base : bases) {
                res = Icons.class.getResource(base + "/" + name + ".png");
                if (res == null) continue;
                return res;
            }
        }
        return res;
    }

    public static final ImageIcon getEmptyIcon(int width, int height) {
        String code = "EMPTY_" + width + "x" + height;
        ImageIcon icon = cache.get(code);
        if (icon != null) {
            return icon;
        }
        BufferedImage img = new BufferedImage(width, height, 1);
        ((Image)img).getGraphics().setColor(Color.WHITE);
        ((Image)img).getGraphics().fillRect(0, 0, width, height);
        icon = new ImageIcon(img);
        cache.put(code, icon);
        return icon;
    }
}

