/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class MathBg
extends BgChar
implements Expandable {
    private boolean isinline = true;

    public MathBg(boolean bl) {
        this('$', bl);
    }

    public MathBg(char c, boolean bl) {
        this((int)c, bl);
    }

    public MathBg(int n, boolean bl) {
        super(n);
        this.isinline = bl;
    }

    @Override
    public Object clone() {
        return new MathBg(this.getCharCode(), this.isInLine());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList(1);
        teXObjectList.add(this);
        teXParser.startGroup();
        teXParser.getSettings().setMode(this.isInLine() ? 1 : 2);
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public String format() {
        String string = new String(Character.toChars(this.getCharCode()));
        return this.isInLine() ? string : String.format("%s%s", string, string);
    }

    @Override
    public String toString() {
        return String.format("%s[delim=%s]", this.getClass().getName(), this.format());
    }

    @Override
    public String toString(TeXParser teXParser) {
        return teXParser.getMathDelim(this.isInLine());
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.getCharCode()));
        if (!this.isinline) {
            teXObjectList.add(teXParser.getListener().getOther(this.getCharCode()));
        }
        return teXObjectList;
    }

    @Override
    public String show(TeXParser teXParser) throws IOException {
        return String.format("math character %s", new String(Character.toChars(this.getCharCode())));
    }

    public boolean isInLine() {
        return this.isinline;
    }

    @Override
    public Group createGroup(TeXParser teXParser) {
        MathGroup mathGroup = teXParser.getListener().createMathGroup();
        mathGroup.setInLine(this.isInLine());
        return mathGroup;
    }
}

