/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCookie;
import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarCookies {
    private List<HarCookie> cookies = new ArrayList<HarCookie>();

    public HarCookies() {
    }

    public HarCookies(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException("[ missing after \"cookies\" element " + jp.getCurrentName(), jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            this.addCookie(new HarCookie(jp, warnings));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarCookies(HarDatabaseConfig config, long requestId, boolean isRequest) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + HarCookie.TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT cookie_id,name,value,path,domain,expires,http_only,secure,comment,version,maxage FROM " + tableName + " WHERE ref_id=? AND is_request=?");
            ps.setLong(1, requestId);
            ps.setInt(2, isRequest ? 1 : 0);
            rs = ps.executeQuery();
            while (rs.next()) {
                boolean secure;
                boolean httpOnly;
                long cookieId = rs.getLong(1);
                HarCookie cookie = new HarCookie(rs.getString(2), rs.getString(3));
                cookie.setPath(rs.getString(4));
                cookie.setDomain(rs.getString(5));
                cookie.setExpires(rs.getTimestamp(6));
                boolean bl = httpOnly = rs.getInt(7) == 1;
                if (!rs.wasNull()) {
                    cookie.setHttpOnly(httpOnly);
                }
                boolean bl2 = secure = rs.getInt(8) == 1;
                if (!rs.wasNull()) {
                    cookie.setSecure(secure);
                }
                cookie.setComment(rs.getString(9));
                cookie.setVersion(rs.getString(10));
                cookie.setMaxAge(rs.getString(11));
                this.addCookie(cookie);
                cookie.getCustomFields().readCustomFieldsJDBC(config, HarCustomFields.Type.HARCOOKIE, cookieId);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeArrayFieldStart("cookies");
        for (HarCookie cookie : this.cookies) {
            cookie.writeHar(g);
        }
        g.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long requestId, HarDatabaseConfig config, boolean isRequest, long logId) throws SQLException {
        Connection c = config.getConnection();
        String pageTableName = config.getTablePrefix() + HarCookie.TABLE_NAME;
        if (!config.isCreatedTable(pageTableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + pageTableName + " (cookie_id " + config.getDbAutoGeneratedId() + ",name " + config.getStringDbType() + ",value " + config.getStringDbType() + ",path " + config.getStringDbType() + ",domain " + config.getStringDbType() + ",expires " + config.getTimestampDbType() + ",http_only " + config.getSmallIntDbType() + ",secure " + config.getSmallIntDbType() + ",comment " + config.getStringDbType() + ",is_request " + config.getSmallIntDbType() + ",version " + config.getStringDbType() + ",maxage " + config.getStringDbType() + ",ref_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(pageTableName);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        PreparedStatement cookiePs = c.prepareStatement("INSERT INTO " + pageTableName + " (name,value,path,domain,expires,http_only,secure,comment,is_request,version,maxage,ref_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", 1);
        try {
            for (HarCookie cookie : this.cookies) {
                cookie.writeJDBC(config, logId, requestId, cookiePs, isRequest);
            }
        }
        finally {
            try {
                if (cookiePs != null) {
                    cookiePs.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId, boolean isRequest) throws SQLException {
        String cookieTableName = config.getTablePrefix() + HarCookie.TABLE_NAME;
        if (!config.isCreatedTable(cookieTableName)) {
            return;
        }
        Connection c = config.getConnection();
        Statement cookiePs = null;
        try {
            cookiePs = c.prepareStatement("DELETE FROM " + cookieTableName + " WHERE ref_id IN (SELECT id FROM " + config.getTablePrefix() + (isRequest ? "request" : "response") + " WHERE entry_id IN (SELECT entry_id FROM " + config.getTablePrefix() + "entries WHERE log_id=?))");
            cookiePs.setLong(1, logId);
            cookiePs.executeUpdate();
            config.dropTableIfEmpty(c, cookieTableName, config);
        }
        finally {
            try {
                if (cookiePs != null) {
                    cookiePs.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public void addCookie(HarCookie cookie) {
        this.cookies.add(cookie);
    }

    public List<HarCookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<HarCookie> cookies) {
        this.cookies = cookies;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("  \"cookies\": [");
        if (this.cookies != null) {
            boolean first = true;
            for (HarCookie cookie : this.cookies) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(cookie);
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

