/*
 * Decompiled with CFR 0.152.
 */
package naga.packetreader;

import java.nio.ByteBuffer;
import naga.PacketReader;
import naga.exception.ProtocolViolationException;

public class DelimiterPacketReader
implements PacketReader {
    private volatile int m_maxPacketSize;
    private byte m_delimiter;

    public DelimiterPacketReader(byte by) {
        this(by, -1);
    }

    public DelimiterPacketReader(byte by, int n) {
        if (n < 1 && n != -1) {
            throw new IllegalArgumentException("Max packet size must be larger that 1, was: " + n);
        }
        this.m_delimiter = by;
        this.m_maxPacketSize = n;
    }

    public int getMaxPacketSize() {
        return this.m_maxPacketSize;
    }

    public void setMaxPacketSize(int n) {
        this.m_maxPacketSize = n;
    }

    @Override
    public byte[] nextPacket(ByteBuffer byteBuffer) throws ProtocolViolationException {
        byteBuffer.mark();
        int n = 0;
        while (byteBuffer.remaining() > 0) {
            byte by = byteBuffer.get();
            if (by == this.m_delimiter) {
                byte[] byArray = new byte[n];
                byteBuffer.reset();
                byteBuffer.get(byArray);
                byteBuffer.get();
                return byArray;
            }
            if (this.m_maxPacketSize <= 0 || ++n <= this.m_maxPacketSize) continue;
            throw new ProtocolViolationException("Packet exceeds max " + this.m_maxPacketSize);
        }
        byteBuffer.reset();
        return null;
    }
}

