/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import java.util.ArrayList;
import java.util.List;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.V3;
import javax.swing.JOptionPane;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.script.T;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.surfacetool.Slice;
import org.openscience.jmol.app.surfacetool.SurfaceStatus;
import org.openscience.jmol.app.surfacetool.SurfaceToolGUI;

public class SurfaceTool {
    private SurfaceToolGUI gui;
    boolean useGUI;
    protected JmolViewer vwr;
    private final P3 negCorner = new P3();
    private final P3 posCorner = new P3();
    private final P3 center = new P3();
    private final V3 boxVec = new V3();
    private final List<SurfaceStatus> surfaces = new ArrayList<SurfaceStatus>();
    static final int DEGREES = 0;
    static final int RADIANS = 1;
    static final int GRADIANS = 2;
    static final int CIRCLE_FRACTION = 3;
    static final int UNITS_PI = 4;
    private int angleUnits = 0;
    private String[] angleUnitsList = new String[]{GT.$("Degrees"), GT.$("Radians"), GT.$("Gradians"), GT.$("Circle Fraction"), GT.$("Units of Pi")};
    private float angleXY;
    private float anglefromZ;
    private float positionMin;
    private float position;
    private float thickness;
    private float thicknessMax;
    private Slice slice = new Slice();
    private boolean leftOn = false;
    private boolean rightOn = false;
    private boolean ghostOn = false;
    private boolean capOn = false;
    private boolean useMolecular = false;
    private boolean usePercent = false;

    public SurfaceTool(JmolViewer jmolViewer, HistoryFile historyFile, String string, boolean bl) {
        this.vwr = jmolViewer;
        this.useGUI = bl;
        this.updateSurfaceInfo();
        this.chooseBestBoundBox();
        this.setSurfaceToolParam();
        this.initSlice();
        this.gui = bl ? new SurfaceToolGUI(jmolViewer, historyFile, string, this) : null;
    }

    public void toFront() {
        this.gui.toFront();
    }

    void toFrontOrGotFocus() {
        this.updateSurfaceInfo();
        this.chooseBestBoundBox();
        this.setSurfaceToolParam();
    }

    private void chooseBestBoundBox() {
        BoxInfo boxInfo = new BoxInfo();
        this.vwr.calcAtomsMinMax(null, boxInfo);
        this.center.setT(boxInfo.getBoundBoxCenter());
        this.boxVec.setT(boxInfo.getBoundBoxCornerVector());
        this.posCorner.add2(this.center, this.boxVec);
        this.negCorner.sub2(this.center, this.boxVec);
        Shape[] shapeArray = (Shape[])this.vwr.getProperty("DATA_API", "shapeManager", "getShapes");
        boxInfo = this.checkMeshBB(shapeArray, 24, boxInfo);
        boxInfo = this.checkMeshBB(shapeArray, 29, boxInfo);
        boxInfo = this.checkMeshBB(shapeArray, 27, boxInfo);
        if (boxInfo != null) {
            this.center.setT(boxInfo.getBoundBoxCenter());
            this.negCorner.sub2(this.center, boxInfo.getBoundBoxCornerVector());
            this.posCorner.add2(this.center, boxInfo.getBoundBoxCornerVector());
            this.boxVec.setT(boxInfo.getBoundBoxCornerVector());
        }
    }

    BoxInfo checkMeshBB(Shape[] shapeArray, int n, BoxInfo boxInfo) {
        MeshCollection meshCollection = (MeshCollection)shapeArray[n];
        if (meshCollection == null) {
            return boxInfo;
        }
        int n2 = 0;
        while (n2 < meshCollection.meshCount) {
            P3[] p3Array;
            Mesh mesh = meshCollection.meshes[n2];
            if (!(!mesh.isValid || mesh.vc == 0 && mesh.pc == 0 || mesh.thisID.equalsIgnoreCase("_slicerleft") || mesh.thisID.equalsIgnoreCase("_slicerright") || (p3Array = mesh.getBoundingBox()) == null)) {
                boxInfo.addBoundBoxPoint(p3Array[0]);
                boxInfo.addBoundBoxPoint(p3Array[1]);
            }
            ++n2;
        }
        return boxInfo;
    }

    void setSurfaceToolParam() {
        this.thicknessMax = 2.0f * this.boxVec.length();
        float f = this.position - this.positionMin;
        if (this.useMolecular) {
            if (this.negCorner.x < 0.0f && this.negCorner.y < 0.0f && this.negCorner.z < 0.0f) {
                this.positionMin = -1.0f * this.negCorner.length();
            } else {
                this.positionMin = Math.min(this.negCorner.x, this.negCorner.y);
                this.positionMin = Math.min(this.negCorner.z, this.positionMin);
            }
        } else {
            this.positionMin = -1.0f * this.boxVec.length();
        }
        this.position = this.positionMin + f;
    }

    private void updateSurfaceInfo() {
        Shape[] shapeArray = (Shape[])this.vwr.getProperty("DATA_API", "shapeManager", "getShapes");
        this.setSyncStarting();
        this.updateMeshInfo(shapeArray, 24);
        this.updateMeshInfo(shapeArray, 29);
        this.updateMeshInfo(shapeArray, 27);
        this.syncDone();
    }

    private void setSyncStarting() {
        int n = 0;
        while (n < this.surfaces.size()) {
            this.surfaces.get((int)n).foundDuringLastSync = false;
            ++n;
        }
    }

    private void syncDone() {
        int n = this.surfaces.size() - 1;
        while (n >= 0) {
            if (!this.surfaces.get((int)n).foundDuringLastSync) {
                this.surfaces.remove(n);
            }
            --n;
        }
    }

    private void updateMeshInfo(Shape[] shapeArray, int n) {
        MeshCollection meshCollection;
        if (shapeArray != null && (meshCollection = (MeshCollection)shapeArray[n]) != null) {
            int[] nArray = new int[meshCollection.meshCount];
            int n2 = 0;
            while (n2 < meshCollection.meshCount) {
                nArray[n2] = -1;
                ++n2;
            }
            if (!this.surfaces.isEmpty()) {
                int[] nArray2 = new int[this.surfaces.size()];
                int n3 = 0;
                while (n3 < this.surfaces.size()) {
                    nArray2[n3] = -1;
                    ++n3;
                }
                n3 = 0;
                while (n3 < meshCollection.meshCount) {
                    Mesh mesh = meshCollection.meshes[n3];
                    if (!this.checkMesh(mesh)) {
                        nArray[n3] = -2;
                    } else {
                        int n4 = 0;
                        while (n4 < this.surfaces.size()) {
                            if (this.surfaces.get((int)n4).id == mesh.thisID) {
                                nArray2[n4] = n3;
                                nArray[n3] = n4;
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < nArray2.length) {
                    if (nArray2[n3] >= 0) {
                        this.surfaces.get(n3).updateExisting(meshCollection.meshes[nArray2[n3]]);
                    }
                    ++n3;
                }
            } else {
                n2 = 0;
                while (n2 < meshCollection.meshCount) {
                    Mesh mesh = meshCollection.meshes[n2];
                    nArray[n2] = !this.checkMesh(mesh) ? -2 : -1;
                    ++n2;
                }
            }
            int n5 = 0;
            while (n5 < nArray.length) {
                if (nArray[n5] == -1) {
                    this.surfaces.add(new SurfaceStatus(meshCollection.meshes[n5], n));
                }
                ++n5;
            }
        }
    }

    private boolean checkMesh(Mesh mesh) {
        if (!mesh.isValid || mesh.vc == 0 && mesh.pc == 0) {
            return false;
        }
        return !mesh.thisID.equalsIgnoreCase("_slicerleft") && !mesh.thisID.equalsIgnoreCase("_slicerright");
    }

    void setAngleUnits(int n) {
        this.angleUnits = n;
    }

    P3 getNegCorner() {
        return this.negCorner;
    }

    P3 getPosCorner() {
        return this.posCorner;
    }

    private void initSlice() {
        this.angleXY = 0.0f;
        this.anglefromZ = 1.5707964f;
        this.position = 0.0f;
        this.thickness = this.negCorner.distance(this.posCorner) / 5.0f;
        this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
    }

    void showSliceBoundaryPlanes(boolean bl) {
        this.leftOn = this.rightOn = bl;
        SB sB = new SB();
        this.drawSlicePlane(sB, 1073741996, bl);
        this.drawSlicePlane(sB, 1073742126, bl);
        this.vwr.evalStringQuiet(sB.toString());
    }

    void setSlice(float f, float f2, float f3, float f4) {
        if (this.usePercent) {
            JOptionPane.showMessageDialog(null, GT.$("Percentage scaling not implemented yet!"), "Warning", 2);
        }
        this.angleXY = f;
        this.anglefromZ = f2;
        this.position = f3;
        this.thickness = f4;
        this.slice.setSlice(f, f2, f3, f4, this.center, this.boxVec, this.useMolecular);
    }

    void setSliceAngleXY(float f) {
        if (this.angleXY != f) {
            this.angleXY = f;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getSliceAngleXY() {
        return this.angleXY;
    }

    void setSliceAnglefromZ(float f) {
        if (this.anglefromZ != f) {
            this.anglefromZ = f;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getAnglefromZ() {
        return this.anglefromZ;
    }

    void setSlicePosition(float f) {
        if (this.usePercent) {
            JOptionPane.showMessageDialog(null, GT.$("Percentage scaling not implemented yet!"), "Warning", 2);
        }
        if (this.position != f) {
            this.position = f;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getSlicePosition() {
        return this.position;
    }

    void setSliceThickness(float f) {
        if (this.usePercent) {
            JOptionPane.showMessageDialog(null, GT.$("Percentage scaling not implemented yet!"), "Warning", 2);
        }
        if (this.thickness != f) {
            this.thickness = f;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getSliceThickness() {
        return this.thickness;
    }

    void updateSlices() {
        int n = 0;
        while (n < this.surfaces.size()) {
            this.sliceObject(this.surfaces.get((int)n).id, this.surfaces.get((int)n).kind);
            ++n;
        }
    }

    void sliceObject(String string, int n) {
        String string2 = "";
        String string3 = " ID \"" + string + "\"";
        String string4 = this.capOn ? " cap " : " slab ";
        String string5 = this.ghostOn ? "translucent 0.8 mesh " : "";
        switch (n) {
            case 24: {
                string2 = "isosurface";
                break;
            }
            case 29: {
                string2 = "pmesh";
                break;
            }
            case 27: {
                string2 = "mo";
                string3 = "";
                string4 = " slab ";
            }
        }
        SB sB = new SB();
        this.drawSlicePlane(sB, 1073741996, this.leftOn);
        this.drawSlicePlane(sB, 1073742126, this.rightOn);
        sB.append(string2).append(string3).append(" slab none;");
        sB.append(string2).append(string3);
        sB.append(string4).append(string5).append("-").append(Escape.eP4(this.slice.leftPlane));
        sB.append(";").append(string2).append(string3);
        sB.append(string4).append(string5).append(Escape.eP4(this.slice.rightPlane));
        sB.append(";");
        this.vwr.evalStringQuiet(sB.toString());
    }

    private void drawSlicePlane(SB sB, int n, boolean bl) {
        String string;
        P4 p4;
        String string2 = T.nameOf(n);
        switch (n) {
            default: {
                p4 = this.slice.leftPlane;
                string = "magenta";
                break;
            }
            case 1073742126: {
                p4 = this.slice.rightPlane;
                string = "cyan";
            }
        }
        sB.append("isosurface _slicer").append(string2);
        if (bl) {
            sB.append(" plane ").append(Escape.eP4(p4)).append(" translucent 0.7 ").append(string).append(";");
        } else {
            sB.append(" off;");
        }
    }

    int getAngleUnits() {
        return this.angleUnits;
    }

    boolean getGhostOn() {
        return this.ghostOn;
    }

    void setGhostOn(boolean bl) {
        this.ghostOn = bl;
    }

    boolean getUseMolecular() {
        return this.useMolecular;
    }

    void setUseMolecular(boolean bl) {
        this.useMolecular = bl;
    }

    float getPositionMin() {
        return this.positionMin;
    }

    float getThicknessMax() {
        return this.thicknessMax;
    }

    P3 getCenter() {
        return this.center;
    }

    V3 getBoxVec() {
        return this.boxVec;
    }

    P4 getSliceMiddle() {
        return this.slice.getMiddle();
    }

    String[] getAngleUnitsList() {
        return this.angleUnitsList;
    }

    boolean getCapOn() {
        return this.capOn;
    }

    void setCapOn(boolean bl) {
        this.capOn = bl;
    }

    public List<SurfaceStatus> getSurfaces() {
        return this.surfaces;
    }
}

