/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.freecol.common.resources.AudioResource;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.FAFileResource;
import net.sf.freecol.common.resources.FontResource;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.SZAResource;
import net.sf.freecol.common.resources.StringResource;
import net.sf.freecol.common.resources.VideoResource;

public final class ResourceMapping {
    private static final Logger logger = Logger.getLogger(ResourceMapping.class.getName());
    private final HashMap<String, ColorResource> colorResources = new HashMap();
    private final HashMap<String, FontResource> fontResources = new HashMap();
    private final HashMap<String, StringResource> stringResources = new HashMap();
    private final HashMap<String, FAFileResource> fafResources = new HashMap();
    private final HashMap<String, SZAResource> szaResources = new HashMap();
    private final HashMap<String, AudioResource> audioResources = new HashMap();
    private final HashMap<String, VideoResource> videoResources = new HashMap();
    private final HashMap<String, ImageResource> imageResources = new HashMap();

    public boolean add(String key, ColorResource value) {
        if (!key.startsWith("color.")) {
            logger.warning("Rejecting malformed resource key: " + key);
            return false;
        }
        this.colorResources.put(key, value);
        return true;
    }

    public boolean add(String key, FontResource value) {
        if (!key.startsWith("font.")) {
            logger.warning("Rejecting malformed resource key: " + key);
            return false;
        }
        this.fontResources.put(key, value);
        return true;
    }

    public boolean add(String key, StringResource value) {
        this.stringResources.put(key, value);
        return true;
    }

    public boolean add(String key, FAFileResource value) {
        if (!key.startsWith("animatedfont.")) {
            logger.warning("Rejecting malformed resource key: " + key);
            return false;
        }
        this.fafResources.put(key, value);
        return true;
    }

    public boolean add(String key, SZAResource value) {
        if (!key.startsWith("animation.")) {
            logger.warning("Rejecting malformed resource key: " + key);
            return false;
        }
        this.szaResources.put(key, value);
        return true;
    }

    public boolean add(String key, AudioResource value) {
        if (!key.startsWith("sound.")) {
            logger.warning("Rejecting malformed resource key: " + key);
            return false;
        }
        this.audioResources.put(key, value);
        return true;
    }

    public boolean add(String key, VideoResource value) {
        if (!key.startsWith("video.")) {
            logger.warning("Rejecting malformed resource key: " + key);
            return false;
        }
        this.videoResources.put(key, value);
        return true;
    }

    public boolean add(String key, ImageResource value) {
        if (!key.startsWith("image.")) {
            logger.warning("Rejecting malformed resource key: " + key);
            return false;
        }
        this.imageResources.put(key, value);
        return true;
    }

    public boolean duplicateResource(String key, String keyNew) {
        ColorResource cr = this.colorResources.get(key);
        if (cr != null) {
            return this.add(keyNew, cr);
        }
        FontResource fr = this.fontResources.get(key);
        if (fr != null) {
            return this.add(keyNew, fr);
        }
        StringResource sr = this.stringResources.get(key);
        if (sr != null) {
            return this.add(keyNew, sr);
        }
        FAFileResource far = this.fafResources.get(key);
        if (far != null) {
            return this.add(keyNew, far);
        }
        SZAResource szr = this.szaResources.get(key);
        if (szr != null) {
            return this.add(keyNew, szr);
        }
        AudioResource ar = this.audioResources.get(key);
        if (ar != null) {
            return this.add(keyNew, ar);
        }
        VideoResource vr = this.videoResources.get(key);
        if (vr != null) {
            return this.add(keyNew, vr);
        }
        ImageResource ir = this.imageResources.get(key);
        if (ir != null) {
            return this.add(keyNew, ir);
        }
        return false;
    }

    public void addAll(ResourceMapping rc) {
        if (rc != null) {
            this.colorResources.putAll(rc.colorResources);
            this.fontResources.putAll(rc.fontResources);
            this.stringResources.putAll(rc.stringResources);
            this.fafResources.putAll(rc.fafResources);
            this.szaResources.putAll(rc.szaResources);
            this.audioResources.putAll(rc.audioResources);
            this.videoResources.putAll(rc.videoResources);
            this.imageResources.putAll(rc.imageResources);
        }
    }

    public Map<String, Resource> getResources() {
        HashMap<String, Resource> result = new HashMap<String, Resource>();
        result.putAll(this.colorResources);
        result.putAll(this.fontResources);
        result.putAll(this.stringResources);
        result.putAll(this.fafResources);
        result.putAll(this.szaResources);
        result.putAll(this.audioResources);
        result.putAll(this.videoResources);
        result.putAll(this.imageResources);
        return result;
    }

    public Map<String, ImageResource> getImageResources() {
        return new HashMap<String, ImageResource>(this.imageResources);
    }

    public boolean containsKey(String key) {
        return this.colorResources.containsKey(key) || this.fontResources.containsKey(key) || this.stringResources.containsKey(key) || this.fafResources.containsKey(key) || this.szaResources.containsKey(key) || this.audioResources.containsKey(key) || this.videoResources.containsKey(key) || this.imageResources.containsKey(key);
    }

    public boolean containsColorKey(String key) {
        return this.colorResources.containsKey(key);
    }

    public boolean containsImageKey(String key) {
        return this.imageResources.containsKey(key);
    }

    public ColorResource getColorResource(String key) {
        return this.colorResources.get(key);
    }

    public FontResource getFontResource(String key) {
        return this.fontResources.get(key);
    }

    public StringResource getStringResource(String key) {
        return this.stringResources.get(key);
    }

    public FAFileResource getFAFileResource(String key) {
        return this.fafResources.get(key);
    }

    public SZAResource getSZAResource(String key) {
        return this.szaResources.get(key);
    }

    public AudioResource getAudioResource(String key) {
        return this.audioResources.get(key);
    }

    public VideoResource getVideoResource(String key) {
        return this.videoResources.get(key);
    }

    public ImageResource getImageResource(String key) {
        return this.imageResources.get(key);
    }

    public List<String> getImageKeys(String prefix) {
        return this.imageResources.keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toList());
    }

    public Set<String> getImageKeySet(String prefix) {
        return this.imageResources.keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toSet());
    }

    public List<String> getImageKeys(String prefix, String suffix) {
        return this.imageResources.keySet().stream().filter(k -> k.startsWith(prefix) && k.endsWith(suffix)).collect(Collectors.toList());
    }
}

