/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.time;

import accessories.plugins.time.FlatNodeTableFilterModel;
import accessories.plugins.time.TableSorter;
import accessories.plugins.time.TimeManagementOrganizer;
import freemind.controller.MapModuleManager;
import freemind.controller.MenuItemSelectedListener;
import freemind.controller.StructuredMenuHolder;
import freemind.controller.actions.generated.instance.TimeWindowColumnSetting;
import freemind.controller.actions.generated.instance.TimeWindowConfigurationStorage;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.common.plugins.ReminderHookBase;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.hooks.MindMapHookAdapter;
import freemind.view.MapModule;
import freemind.view.mindmapview.MultipleImage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TimeList
extends MindMapHookAdapter
implements MapModuleManager.MapModuleChangeObserver {
    private static final int TYPE_DELAY_TIME = 500;
    private static String COLUMN_MODIFIED = "Modified";
    private static String COLUMN_CREATED = "Created";
    private static String COLUMN_ICONS = "Icons";
    private static String COLUMN_TEXT = "Text";
    private static String COLUMN_DATE = "Date";
    private static String COLUMN_NOTES = "Notes";
    private static final int DATE_COLUMN = 0;
    public static final int NODE_TEXT_COLUMN = 1;
    protected static final int NODE_ICON_COLUMN = 2;
    protected static final int NODE_CREATED_COLUMN = 3;
    protected static final int NODE_MODIFIED_COLUMN = 4;
    protected static final int NODE_NOTES_COLUMN = 5;
    private JDialog dialog;
    private JPanel timePanel;
    private JTable timeTable;
    private DefaultTableModel timeTableModel;
    private TableSorter sorter;
    private DateRenderer dateRenderer;
    private NodeRenderer nodeRenderer;
    private IconsRenderer iconsRenderer;
    private boolean showAllNodes = false;
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = TimeList.class.getName() + "_properties";
    private FlatNodeTableFilterModel mFlatNodeTableFilterModel;
    private JTextField mFilterTextSearchField;
    private JTextField mFilterTextReplaceField;
    private NotesRenderer notesRenderer;
    private JLabel mTreeLabel;
    private MindMapController mMyMindMapController;
    private boolean mViewFoldedNodes = true;

    @Override
    public void startupMapHook() {
        super.startupMapHook();
        this.mMyMindMapController = super.getMindMapController();
        this.getMindMapController().getController().getMapModuleManager().addListener(this);
        COLUMN_MODIFIED = this.getResourceString("plugins/TimeList.xml_Modified");
        COLUMN_CREATED = this.getResourceString("plugins/TimeList.xml_Created");
        COLUMN_ICONS = this.getResourceString("plugins/TimeList.xml_Icons");
        COLUMN_TEXT = this.getResourceString("plugins/TimeList.xml_Text");
        COLUMN_DATE = this.getResourceString("plugins/TimeList.xml_Date");
        COLUMN_NOTES = this.getResourceString("plugins/TimeList.xml_Notes");
        this.showAllNodes = Tools.xmlToBoolean(this.getResourceString("show_all_nodes"));
        this.dialog = new JDialog((Frame)this.getController().getFrame().getJFrame(), false);
        String windowTitle = this.showAllNodes ? "plugins/TimeManagement.xml_WindowTitle_All_Nodes" : "plugins/TimeManagement.xml_WindowTitle";
        this.dialog.setTitle(this.getResourceString(windowTitle));
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                TimeList.this.disposeDialog();
            }
        });
        Tools.addEscapeActionToDialog(this.dialog, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.disposeDialog();
            }
        });
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        contentPane.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_Find")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mFilterTextSearchField = new JTextField();
        this.mFilterTextSearchField.getDocument().addDocumentListener(new FilterTextDocumentListener());
        this.mFilterTextSearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    TimeList.this.logger.info("Set Focus to replace fields");
                    TimeList.this.mFilterTextReplaceField.requestFocusInWindow();
                }
            }
        });
        contentPane.add((Component)this.mFilterTextSearchField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_Replace")), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mFilterTextReplaceField = new JTextField();
        contentPane.add((Component)this.mFilterTextReplaceField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mFilterTextReplaceField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    TimeList.this.logger.info("Set Focus to table");
                    TimeList.this.timeTable.requestFocusInWindow();
                } else if (pEvent.getKeyCode() == 38) {
                    TimeList.this.logger.info("Set Focus to table");
                    TimeList.this.mFilterTextSearchField.requestFocusInWindow();
                }
            }
        });
        this.dateRenderer = new DateRenderer();
        this.nodeRenderer = new NodeRenderer();
        this.notesRenderer = new NotesRenderer();
        this.iconsRenderer = new IconsRenderer(this.getController());
        this.timeTable = new FlatNodeTable();
        this.timeTable.addKeyListener(new FlatNodeTableKeyListener());
        this.timeTable.addMouseListener(new FlatNodeTableMouseAdapter());
        this.timeTable.getTableHeader().setReorderingAllowed(false);
        this.updateModel();
        this.sorter.setTableHeader(this.timeTable.getTableHeader());
        this.sorter.setColumnComparator(Date.class, TableSorter.COMPARABLE_COMAPRATOR);
        this.sorter.setColumnComparator(NodeHolder.class, TableSorter.LEXICAL_COMPARATOR);
        this.sorter.setColumnComparator(NotesHolder.class, TableSorter.LEXICAL_COMPARATOR);
        this.sorter.setColumnComparator(IconsHolder.class, TableSorter.COMPARABLE_COMAPRATOR);
        this.sorter.setSortingStatus(0, 1);
        JScrollPane pane = new JScrollPane(this.timeTable);
        contentPane.add((Component)pane, new GridBagConstraints(0, 4, 1, 1, 1.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mTreeLabel = new JLabel();
        contentPane.add((Component)new JScrollPane(this.mTreeLabel), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        AbstractAction selectAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Select")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.selectSelectedRows();
            }
        };
        AbstractAction exportAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Export")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.exportSelectedRowsAndClose();
            }
        };
        AbstractAction replaceAllAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Replace_All")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.replace(new ReplaceAllInfo());
            }
        };
        AbstractAction replaceSelectedAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Replace_Selected")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.replace(new ReplaceSelectedInfo());
            }
        };
        AbstractAction gotoAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Goto")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.selectSelectedRows();
                TimeList.this.disposeDialog();
            }
        };
        AbstractAction disposeAction = new AbstractAction(this.getResourceString("plugins/TimeManagement.xml_Cancel")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.disposeDialog();
            }
        };
        ToggleViewFoldedNodesAction toggleViewFoldedNodesAction = new ToggleViewFoldedNodesAction(this.getResourceString("plugins/TimeManagement.xml_ToggleViewFoldedNodesAction"));
        StructuredMenuHolder menuHolder = new StructuredMenuHolder();
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(this.getResourceString("plugins/TimeManagement.xml_menu_actions"));
        menuHolder.addMenu(menu, "main/actions/.");
        final JMenuItem selectMenuItem = this.addAccelerator(menuHolder.addAction(selectAction, "main/actions/select"), "keystroke_plugins/TimeList_select");
        final JMenuItem gotoMenuItem = this.addAccelerator(menuHolder.addAction(gotoAction, "main/actions/goto"), "keystroke_plugins/TimeList_goto");
        final JMenuItem replaceSelectedMenuItem = this.addAccelerator(menuHolder.addAction(replaceSelectedAction, "main/actions/replaceSelected"), "keystroke_plugins/TimeList_replaceSelected");
        JMenuItem replaceAllMenuItem = this.addAccelerator(menuHolder.addAction(replaceAllAction, "main/actions/replaceAll"), "keystroke_plugins/TimeList_replaceAll");
        final JMenuItem exportMenuItem = this.addAccelerator(menuHolder.addAction(exportAction, "main/actions/export"), "keystroke_plugins/TimeList_export");
        this.addAccelerator(menuHolder.addAction(disposeAction, "main/actions/dispose"), "keystroke_plugins/TimeList_dispose");
        JMenu viewMenu = new JMenu(this.getResourceString("plugins/TimeManagement.xml_menu_view"));
        menuHolder.addMenu(viewMenu, "main/view/.");
        this.addAccelerator(menuHolder.addAction(toggleViewFoldedNodesAction, "main/view/showFoldedNodes"), "keystroke_plugins/TimeList_showFoldedNodes");
        menuHolder.updateMenus(menuBar, "main/");
        this.dialog.setJMenuBar(menuBar);
        selectMenuItem.setEnabled(false);
        gotoMenuItem.setEnabled(false);
        exportMenuItem.setEnabled(false);
        replaceSelectedMenuItem.setEnabled(false);
        ListSelectionModel rowSM = this.timeTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                boolean enable = !lsm.isSelectionEmpty();
                replaceSelectedMenuItem.setEnabled(enable);
                selectMenuItem.setEnabled(enable);
                gotoMenuItem.setEnabled(enable);
                exportMenuItem.setEnabled(enable);
            }
        });
        rowSM.addListSelectionListener(new ListSelectionListener(){

            String getNodeText(MindMapNode node) {
                return Tools.getNodeTextHierarchy(node, TimeList.this.getMindMapController());
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    TimeList.this.mTreeLabel.setText("");
                    return;
                }
                int selectedRow = lsm.getLeadSelectionIndex();
                MindMapNode mindMapNode = TimeList.this.getMindMapNode(selectedRow);
                TimeList.this.mTreeLabel.setText(this.getNodeText(mindMapNode));
            }
        });
        WindowConfigurationStorage storage = this.getMindMapController().decorateDialog(this.dialog, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        if (storage != null) {
            this.setTableConfiguration(storage);
        }
        this.dialog.setVisible(true);
    }

    protected void setTableConfiguration(WindowConfigurationStorage storage) {
        this.timeTable.setAutoResizeMode(0);
        TimeWindowConfigurationStorage timeStorage = (TimeWindowConfigurationStorage)storage;
        if (this.mViewFoldedNodes != timeStorage.getViewFoldedNodes()) {
            this.toggleViewFoldedNodes();
        }
        int column = 0;
        for (TimeWindowColumnSetting setting : timeStorage.getListTimeWindowColumnSettingList()) {
            this.timeTable.getColumnModel().getColumn(column).setPreferredWidth(setting.getColumnWidth());
            this.sorter.setSortingStatus(column, setting.getColumnSorting());
            ++column;
        }
    }

    protected void toggleViewFoldedNodes() {
        this.mViewFoldedNodes = !this.mViewFoldedNodes;
        this.updateModel();
    }

    protected void decorateButtonAndAction(String stringProperty, AbstractAction selectAction, JButton selectButton) {
        String resourceString = this.getResourceString(stringProperty);
        selectAction.putValue("Name", resourceString.replaceAll("&", ""));
        Tools.setLabelAndMnemonic(selectButton, resourceString);
    }

    protected void exportSelectedRowsAndClose() {
        int[] selectedRows = this.timeTable.getSelectedRows();
        Vector<MindMapNode> selectedNodes = new Vector<MindMapNode>();
        for (int i = 0; i < selectedRows.length; ++i) {
            int row = selectedRows[i];
            selectedNodes.add(this.getMindMapNode(row));
        }
        MindMap newMap = this.getMindMapController().newMap();
        MindMapController newMindMapController = (MindMapController)newMap.getModeController();
        for (MindMapNode node : selectedNodes) {
            MindMapNode copy = node.shallowCopy();
            if (copy == null) continue;
            newMindMapController.insertNodeInto(copy, newMap.getRootNode());
        }
        this.disposeDialog();
    }

    private void replace(IReplaceInputInformation info) {
        try {
            String searchString = this.getText(this.mFilterTextSearchField.getDocument());
            String replaceString = this.getText(this.mFilterTextReplaceField.getDocument());
            TimeList.replace(info, searchString, replaceString);
            this.timeTableModel.fireTableDataChanged();
            this.mFlatNodeTableFilterModel.resetFilter();
            this.mFilterTextSearchField.setText("");
        }
        catch (BadLocationException e) {
            Resources.getInstance().logException(e);
        }
    }

    public static void replace(IReplaceInputInformation info, String searchString, String replaceString) {
        String regExp = "(" + searchString + ")";
        Pattern p = Pattern.compile(regExp, 2);
        String replacement = replaceString;
        int length = info.getLength();
        for (int i = 0; i < length; ++i) {
            String replaceResult;
            NodeHolder nodeHolder = info.getNodeHolderAt(i);
            String text = nodeHolder.node.getText();
            if (Tools.safeEquals(text, replaceResult = HtmlTools.getInstance().getReplaceResult(p, replacement, text))) continue;
            info.changeString(nodeHolder, replaceResult);
        }
    }

    private void selectSelectedRows() {
        this.selectNodes(this.timeTable.getSelectedRow(), this.timeTable.getSelectedRows());
    }

    private void gotoNodesAndClose(int focussedRow, int[] selectedRows) {
        this.selectNodes(focussedRow, selectedRows);
        this.disposeDialog();
    }

    private void selectNodes(int focussedRow, int[] selectedRows) {
        if (focussedRow >= 0) {
            MindMapNode focussedNode = this.getMindMapNode(focussedRow);
            Vector<MindMapNode> selectedNodes = new Vector<MindMapNode>();
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                selectedNodes.add(this.getMindMapNode(row));
            }
            this.getMindMapController().select(focussedNode, selectedNodes);
        }
    }

    private MindMapNode getMindMapNode(int focussedRow) {
        MindMapNode selectedNode = ((NodeHolder)this.timeTable.getModel().getValueAt(focussedRow, 1)).node;
        return selectedNode;
    }

    private DefaultTableModel updateModel() {
        TimeWindowConfigurationStorage storage = null;
        if (this.sorter != null) {
            storage = this.getTableConfiguration();
        }
        MindmapTableModel model = new MindmapTableModel();
        model.addColumn(COLUMN_DATE);
        model.addColumn(COLUMN_TEXT);
        model.addColumn(COLUMN_ICONS);
        model.addColumn(COLUMN_CREATED);
        model.addColumn(COLUMN_MODIFIED);
        model.addColumn(COLUMN_NOTES);
        MindMapNode node = this.getMindMapController().getMap().getRootNode();
        this.updateModel(model, node);
        this.timeTableModel = model;
        this.mFlatNodeTableFilterModel = new FlatNodeTableFilterModel(this.timeTableModel, 1, 5);
        if (this.sorter == null) {
            this.sorter = new TableSorter(this.mFlatNodeTableFilterModel);
            this.timeTable.setModel(this.sorter);
        } else {
            this.sorter.setTableModel(this.mFlatNodeTableFilterModel);
        }
        if (storage != null) {
            this.setTableConfiguration((WindowConfigurationStorage)storage);
        }
        try {
            String text = TimeList.getRegularExpression(this.getText(this.mFilterTextSearchField.getDocument()));
            this.mFlatNodeTableFilterModel.setFilter(text);
        }
        catch (BadLocationException e) {
            Resources.getInstance().logException(e);
        }
        return model;
    }

    private void updateModel(DefaultTableModel model, MindMapNode node) {
        ReminderHookBase hook = TimeManagementOrganizer.getHook(node);
        if (this.showAllNodes || hook != null) {
            Date date = null;
            if (hook != null) {
                date = new Date(hook.getRemindUserAt());
            }
            model.addRow(new Object[]{date, new NodeHolder(node), new IconsHolder(node), node.getHistoryInformation().getCreatedAt(), node.getHistoryInformation().getLastModifiedAt(), new NotesHolder(node)});
        }
        if (!this.mViewFoldedNodes && node.isFolded()) {
            return;
        }
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.updateModel(model, child);
        }
    }

    private JPanel getTimePanel() {
        if (this.timePanel == null) {
            this.timePanel = new JPanel();
            this.timePanel.setLayout(new GridBagLayout());
        }
        return this.timePanel;
    }

    private void disposeDialog() {
        TimeWindowConfigurationStorage storage = this.getTableConfiguration();
        this.getMindMapController().storeDialogPositions(this.dialog, (WindowConfigurationStorage)storage, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        this.getMindMapController().getController().getMapModuleManager().removeListener(this);
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    protected TimeWindowConfigurationStorage getTableConfiguration() {
        TimeWindowConfigurationStorage storage = new TimeWindowConfigurationStorage();
        storage.setViewFoldedNodes(this.mViewFoldedNodes);
        for (int i = 0; i < this.timeTable.getColumnCount(); ++i) {
            TimeWindowColumnSetting setting = new TimeWindowColumnSetting();
            setting.setColumnWidth(this.timeTable.getColumnModel().getColumn(i).getWidth());
            setting.setColumnSorting(this.sorter.getSortingStatus(i));
            storage.addTimeWindowColumnSetting(setting);
        }
        return storage;
    }

    public static String getRegularExpression(String text) throws BadLocationException {
        text = ".*(" + text + ").*";
        return text;
    }

    private String getText(Document document) throws BadLocationException {
        String text = document.getText(0, document.getLength());
        return text;
    }

    public static String getPureRegularExpression(String text) {
        text = text.replaceAll("([().\\[\\]^$|])", "\\\\$1");
        text = text.replaceAll("\\*", ".*");
        return text;
    }

    @Override
    public MindMapController getMindMapController() {
        return this.mMyMindMapController;
    }

    @Override
    public boolean isMapModuleChangeAllowed(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
        return true;
    }

    @Override
    public void beforeMapModuleChange(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
    }

    @Override
    public void afterMapClose(MapModule pOldMapModule, Mode pOldMode) {
        this.disposeDialog();
    }

    @Override
    public void afterMapModuleChange(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
        this.disposeDialog();
    }

    @Override
    public void numberOfOpenMapInformation(int pNumber, int pIndex) {
    }

    static class IconsRenderer
    extends DefaultTableCellRenderer {
        private final ModeController modeController;

        public IconsRenderer(ModeController controller) {
            this.modeController = controller;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof IconsHolder) {
                IconsHolder iconsHolder = (IconsHolder)value;
                MultipleImage iconImages = new MultipleImage(1.0);
                for (MindIcon icon : iconsHolder.getIcons()) {
                    iconImages.addImage(icon.getIcon());
                }
                if (iconImages.getImageCount() > 0) {
                    this.setIcon(iconImages);
                } else {
                    this.setIcon(null);
                }
            }
        }
    }

    static class IconsHolder
    implements Comparable {
        Vector icons = new Vector();
        private Vector iconNames;

        public IconsHolder(MindMapNode node) {
            this.icons.addAll(node.getIcons());
            this.iconNames = new Vector();
            for (MindIcon icon : this.icons) {
                this.iconNames.add(icon.getName());
            }
            Collections.sort(this.iconNames);
        }

        public int compareTo(Object compareToObject) {
            return this.toString().compareTo(compareToObject.toString());
        }

        public Vector getIcons() {
            return this.icons;
        }

        public String toString() {
            String result = "";
            for (String name : this.iconNames) {
                result = result + name + " ";
            }
            return result;
        }
    }

    public static class NotesHolder
    implements Comparable {
        private final MindMapNode node;
        private String untaggedNotesText = null;
        private String originalNotesText = null;

        public NotesHolder(MindMapNode node) {
            this.node = node;
        }

        public int compareTo(Object compareToObject) {
            return this.toString().compareTo(compareToObject.toString());
        }

        public String toString() {
            return this.getUntaggedNotesText();
        }

        public String getUntaggedNotesText() {
            String notesText = this.node.getNoteText();
            if (notesText == null) {
                return "";
            }
            if (this.untaggedNotesText == null || this.originalNotesText != null && !this.originalNotesText.equals(notesText)) {
                this.originalNotesText = notesText;
                this.untaggedNotesText = HtmlTools.removeHtmlTagsFromString(notesText).replaceAll("\\s+", " ");
            }
            return this.untaggedNotesText;
        }
    }

    public static class NodeHolder
    implements Comparable {
        private final MindMapNode node;
        private String untaggedNodeText = null;
        private String originalNodeText = null;

        public NodeHolder(MindMapNode node) {
            this.node = node;
        }

        public int compareTo(Object compareToObject) {
            return this.toString().compareTo(compareToObject.toString());
        }

        public String toString() {
            return this.getUntaggedNodeText();
        }

        public String getUntaggedNodeText() {
            String nodeText = this.node.getText();
            if (this.untaggedNodeText == null || this.originalNodeText != null && !this.originalNodeText.equals(nodeText)) {
                this.originalNodeText = nodeText;
                this.untaggedNodeText = HtmlTools.htmlToPlain(nodeText).replaceAll("\\s+", " ");
            }
            return this.untaggedNodeText;
        }
    }

    static class NotesRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : ((NotesHolder)value).getUntaggedNotesText());
        }
    }

    static class NodeRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : ((NodeHolder)value).getUntaggedNodeText());
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateTimeInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    private final class FlatNodeTable
    extends JTable {
        private FlatNodeTable() {
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            Object object = this.getModel().getValueAt(row, column);
            if (object instanceof Date) {
                return TimeList.this.dateRenderer;
            }
            if (object instanceof NodeHolder) {
                return TimeList.this.nodeRenderer;
            }
            if (object instanceof NotesHolder) {
                return TimeList.this.notesRenderer;
            }
            if (object instanceof IconsHolder) {
                return TimeList.this.iconsRenderer;
            }
            return super.getCellRenderer(row, column);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int vColIndex) {
            return false;
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                EventListener[] el = super.getListeners(KeyListener.class);
                if (e.getID() != 402) {
                    return;
                }
                for (int i = 0; i < el.length; ++i) {
                    KeyListener kl = (KeyListener)el[i];
                    kl.keyReleased(e);
                }
                return;
            }
            super.processKeyEvent(e);
        }
    }

    private final class FlatNodeTableKeyListener
    implements KeyListener {
        private FlatNodeTableKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
            if (arg0.getKeyCode() == 27) {
                TimeList.this.disposeDialog();
            }
            if (arg0.getKeyCode() == 10) {
                TimeList.this.selectSelectedRows();
                TimeList.this.disposeDialog();
            }
        }
    }

    private final class FlatNodeTableMouseAdapter
    extends MouseAdapter {
        private FlatNodeTableMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point p = e.getPoint();
                int row = TimeList.this.timeTable.rowAtPoint(p);
                TimeList.this.gotoNodesAndClose(row, new int[]{row});
            }
        }
    }

    private final class FilterTextDocumentListener
    implements DocumentListener {
        private Timer mTypeDelayTimer = null;

        private FilterTextDocumentListener() {
        }

        private synchronized void change(DocumentEvent event) {
            if (this.mTypeDelayTimer != null) {
                this.mTypeDelayTimer.cancel();
                this.mTypeDelayTimer = null;
            }
            this.mTypeDelayTimer = new Timer();
            this.mTypeDelayTimer.schedule((TimerTask)new DelayedTextEntry(event), 500L);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.change(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.change(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.change(event);
        }

        protected class DelayedTextEntry
        extends TimerTask {
            private final DocumentEvent event;

            DelayedTextEntry(DocumentEvent event) {
                this.event = event;
            }

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document document = DelayedTextEntry.this.event.getDocument();
                            String text = TimeList.getRegularExpression(TimeList.this.getText(document));
                            TimeList.this.mFlatNodeTableFilterModel.setFilter(text);
                        }
                        catch (BadLocationException e) {
                            Resources.getInstance().logException(e);
                            TimeList.this.mFlatNodeTableFilterModel.resetFilter();
                        }
                    }
                });
            }
        }
    }

    private class ReplaceSelectedInfo
    implements IReplaceInputInformation {
        private ReplaceSelectedInfo() {
        }

        @Override
        public int getLength() {
            return TimeList.this.timeTable.getSelectedRowCount();
        }

        @Override
        public NodeHolder getNodeHolderAt(int i) {
            return (NodeHolder)TimeList.this.sorter.getValueAt(TimeList.this.timeTable.getSelectedRows()[i], 1);
        }

        @Override
        public void changeString(NodeHolder nodeHolder, String newText) {
            TimeList.this.getMindMapController().setNodeText(nodeHolder.node, newText);
        }
    }

    private class ReplaceAllInfo
    implements IReplaceInputInformation {
        private ReplaceAllInfo() {
        }

        @Override
        public int getLength() {
            return TimeList.this.mFlatNodeTableFilterModel.getRowCount();
        }

        @Override
        public NodeHolder getNodeHolderAt(int i) {
            return (NodeHolder)TimeList.this.mFlatNodeTableFilterModel.getValueAt(i, 1);
        }

        @Override
        public void changeString(NodeHolder nodeHolder, String newText) {
            TimeList.this.getMindMapController().setNodeText(nodeHolder.node, newText);
        }
    }

    public static interface IReplaceInputInformation {
        public int getLength();

        public NodeHolder getNodeHolderAt(int var1);

        public void changeString(NodeHolder var1, String var2);
    }

    private final class ToggleViewFoldedNodesAction
    extends AbstractAction
    implements MenuItemSelectedListener {
        private ToggleViewFoldedNodesAction(String pName) {
            super(pName);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TimeList.this.toggleViewFoldedNodes();
        }

        @Override
        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return TimeList.this.mViewFoldedNodes;
        }
    }

    private final class MindmapTableModel
    extends DefaultTableModel {
        private MindmapTableModel() {
        }

        public Class getColumnClass(int arg0) {
            switch (arg0) {
                case 0: 
                case 3: 
                case 4: {
                    return Date.class;
                }
                case 1: {
                    return NodeHolder.class;
                }
                case 2: {
                    return IconsHolder.class;
                }
                case 5: {
                    return NotesHolder.class;
                }
            }
            return Object.class;
        }
    }
}

