/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.Controller;
import freemind.controller.actions.generated.instance.NodeColorFormatAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ListIterator;

public class NodeColorAction
extends FreemindAction
implements ActorXml {
    private final MindMapController controller;

    public NodeColorAction(MindMapController controller) {
        super("node_color", (String)null, controller);
        this.controller = controller;
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), this.controller.getText("choose_node_color"), this.controller.getSelected().getColor());
        if (color == null) {
            return;
        }
        ListIterator it = this.controller.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.setNodeColor(selected, color);
        }
    }

    public void setNodeColor(MindMapNode node, Color color) {
        if (Tools.safeEquals(color, node.getColor())) {
            return;
        }
        NodeColorFormatAction doAction = this.createNodeColorFormatAction(node, color);
        NodeColorFormatAction undoAction = this.createNodeColorFormatAction(node, node.getColor());
        this.controller.doTransaction(this.getClass().getName(), new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
    }

    public NodeColorFormatAction createNodeColorFormatAction(MindMapNode node, Color color) {
        NodeColorFormatAction nodeAction = new NodeColorFormatAction();
        nodeAction.setNode(node.getObjectId(this.controller));
        nodeAction.setColor(Tools.colorToXml(color));
        return nodeAction;
    }

    @Override
    public void act(XmlAction action) {
        NodeAdapter node;
        Color oldColor;
        NodeColorFormatAction nodeColorAction;
        Color color;
        if (action instanceof NodeColorFormatAction && !Tools.safeEquals(color = Tools.xmlToColor((nodeColorAction = (NodeColorFormatAction)action).getColor()), oldColor = (node = this.controller.getNodeFromID(nodeColorAction.getNode())).getColor())) {
            node.setColor(color);
            this.controller.nodeChanged(node);
        }
    }

    @Override
    public Class getDoActionClass() {
        return NodeColorFormatAction.class;
    }
}

