/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.schememode;

import freemind.main.FreeMindMain;
import freemind.modes.MindMap;
import freemind.modes.NodeAdapter;
import freemind.modes.schememode.SchemeEdgeModel;
import java.util.LinkedList;
import java.util.ListIterator;

public class SchemeNodeModel
extends NodeAdapter {
    public SchemeNodeModel(FreeMindMain frame, MindMap map) {
        super(frame, map);
        this.children = new LinkedList();
        this.setEdge(new SchemeEdgeModel(this, this.getFrame()));
    }

    @Override
    public String toString() {
        if (this.isRoot()) {
            return "Scheme";
        }
        String ret = super.toString();
        if (ret == "no text") {
            ret = " ";
        }
        return ret;
    }

    public String getCodeMathStyle() {
        String code = "";
        if (this.isRoot()) {
            ListIterator it = this.childrenUnfolded();
            if (it != null) {
                while (it.hasNext()) {
                    code = code + ((SchemeNodeModel)it.next()).getCodeMathStyle();
                }
            }
        } else {
            code = this.toString().trim() + " ";
            if (this.getChildCount() > 0) {
                code = "(" + code;
                ListIterator it = this.childrenUnfolded();
                if (it != null) {
                    while (it.hasNext()) {
                        code = code + ((SchemeNodeModel)it.next()).getCodeMathStyle();
                    }
                }
                code = code + ")";
            }
        }
        return code;
    }

    public String getCodeClassicStyle() {
        String code = "";
        if (this.isRoot()) {
            ListIterator it = this.childrenUnfolded();
            if (it != null) {
                while (it.hasNext()) {
                    code = code + ((SchemeNodeModel)it.next()).getCodeClassicStyle() + ",";
                }
            }
        } else {
            code = this.toString().trim();
            if (code.equals("")) {
                code = "(";
                ListIterator it = this.childrenUnfolded();
                if (it != null) {
                    while (it.hasNext()) {
                        code = code + ((SchemeNodeModel)it.next()).getCodeClassicStyle() + " ";
                    }
                }
                code = code + ")";
            }
        }
        return code;
    }

    @Override
    public boolean isWriteable() {
        return true;
    }
}

