/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import accessories.plugins.NodeNoteRegistration;
import com.inet.jortho.SpellChecker;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.TextResources;
import freemind.main.FreeMindMain;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;

public class EditNodeWYSIWYG
extends EditNodeBase {
    private KeyEvent firstEvent;
    private static HTMLDialog htmlEditorWindow;

    public EditNodeWYSIWYG(NodeView node, String text, KeyEvent firstEvent, ModeController controller, EditNodeBase.EditControl editControl) {
        super(node, text, controller, editControl);
        this.firstEvent = firstEvent;
    }

    public void show() {
        try {
            FreeMindMain frame = this.getFrame();
            if (htmlEditorWindow == null) {
                htmlEditorWindow = new HTMLDialog(this);
            }
            htmlEditorWindow.setBase(this);
            SHTMLPanel htmlEditorPanel = htmlEditorWindow.getHtmlEditorPanel();
            String rule = "BODY {";
            Font font = this.node.getTextFont();
            if (Resources.getInstance().getBoolProperty("experimental_font_sizing_for_long_node_editors")) {
                font = Tools.updateFontSize(font, this.getView().getZoom(), font.getSize());
            }
            Color nodeTextBackground = this.node.getTextBackground();
            rule = rule + "font-family: " + font.getFamily() + ";";
            rule = rule + "font-size: " + font.getSize() + "pt;";
            if (this.node.getModel().isItalic()) {
                rule = rule + "font-style: italic; ";
            }
            if (this.node.getModel().isBold()) {
                rule = rule + "font-weight: bold; ";
            }
            Color nodeTextColor = this.node.getTextColor();
            rule = rule + "color: " + Tools.colorToXml(nodeTextColor) + ";";
            rule = rule + "}\n";
            rule = rule + "p {";
            rule = rule + "margin-top:0;";
            rule = rule + "}\n";
            HTMLDocument document = htmlEditorPanel.getDocument();
            JEditorPane editorPane = htmlEditorPanel.getEditorPane();
            editorPane.setForeground(nodeTextColor);
            editorPane.setBackground(nodeTextBackground);
            editorPane.setCaretColor(nodeTextColor);
            document.getStyleSheet().addRule(rule);
            try {
                document.setBase(this.node.getMap().getModel().getURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            int preferredHeight = (int)((double)this.node.getMainView().getHeight() * 1.2);
            preferredHeight = Math.max(preferredHeight, Integer.parseInt(frame.getProperty("el__min_default_window_height")));
            preferredHeight = Math.min(preferredHeight, Integer.parseInt(frame.getProperty("el__max_default_window_height")));
            int preferredWidth = (int)((double)this.node.getMainView().getWidth() * 1.2);
            preferredWidth = Math.max(preferredWidth, Integer.parseInt(frame.getProperty("el__min_default_window_width")));
            preferredWidth = Math.min(preferredWidth, Integer.parseInt(frame.getProperty("el__max_default_window_width")));
            htmlEditorPanel.setContentPanePreferredSize(new Dimension(preferredWidth, preferredHeight));
            htmlEditorWindow.pack();
            Tools.setDialogLocationRelativeTo(htmlEditorWindow, this.node);
            String content = this.node.getModel().toString();
            if (!HtmlTools.isHtmlNode(content)) {
                content = HtmlTools.plainToHTML(content);
            }
            htmlEditorPanel.setCurrentDocumentContent(content);
            if (this.firstEvent instanceof KeyEvent) {
                KeyEvent firstKeyEvent = this.firstEvent;
                JEditorPane currentPane = htmlEditorPanel.getEditorPane();
                if (currentPane == htmlEditorPanel.getMostRecentFocusOwner()) {
                    this.redispatchKeyEvents(currentPane, firstKeyEvent);
                }
            } else {
                editorPane.setCaretPosition(htmlEditorPanel.getDocument().getLength());
            }
            htmlEditorPanel.getMostRecentFocusOwner().requestFocus();
            htmlEditorWindow.show();
        }
        catch (Exception ex) {
            Resources.getInstance().logException(ex);
            System.err.println("Loading of WYSIWYG HTML editor failed. Use the other editors instead.");
        }
    }

    private static class HTMLDialog
    extends EditNodeBase.EditDialog {
        private static final long serialVersionUID = 2862979626489782521L;
        private SHTMLPanel htmlEditorPanel;

        HTMLDialog(EditNodeBase base) throws Exception {
            super(base);
            this.createEditorPanel();
            this.getContentPane().add((Component)this.htmlEditorPanel, "Center");
            Tools.addEscapeActionToDialog(this, new EditNodeBase.EditDialog.CancelAction());
            JButton okButton = new JButton();
            JButton cancelButton = new JButton();
            JButton splitButton = new JButton();
            Tools.setLabelAndMnemonic(okButton, base.getText("ok"));
            Tools.setLabelAndMnemonic(cancelButton, base.getText("cancel"));
            Tools.setLabelAndMnemonic(splitButton, base.getText("split"));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HTMLDialog.this.submit();
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HTMLDialog.this.cancel();
                }
            });
            splitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HTMLDialog.this.split();
                }
            });
            Tools.addKeyActionToDialog(this, new EditNodeBase.EditDialog.SubmitAction(), "alt ENTER", "submit");
            Tools.addKeyActionToDialog(this, new EditNodeBase.EditDialog.SubmitAction(), "control ENTER", "submit");
            JPanel buttonPane = new JPanel();
            buttonPane.add(okButton);
            buttonPane.add(cancelButton);
            buttonPane.add(splitButton);
            buttonPane.setMaximumSize(new Dimension(1000, 20));
            this.getContentPane().add((Component)buttonPane, "South");
            this.htmlEditorPanel.setOpenHyperlinkHandler(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent pE) {
                    try {
                        HTMLDialog.this.getBase().getController().getFrame().openDocument(new URL(pE.getActionCommand()));
                    }
                    catch (Exception e) {
                        Resources.getInstance().logException(e);
                    }
                }
            });
            if (EditNodeBase.checkSpelling) {
                SpellChecker.register((JTextComponent)this.htmlEditorPanel.getEditorPane());
            }
        }

        private SHTMLPanel createEditorPanel() throws Exception {
            if (this.htmlEditorPanel == null) {
                SHTMLPanel.setResources((TextResources)new NodeNoteRegistration.SimplyHtmlResources());
                this.htmlEditorPanel = SHTMLPanel.createSHTMLPanel();
            }
            return this.htmlEditorPanel;
        }

        public SHTMLPanel getHtmlEditorPanel() {
            return this.htmlEditorPanel;
        }

        @Override
        protected void submit() {
            this.removeBodyStyle();
            if (this.htmlEditorPanel.needsSaving()) {
                this.getBase().getEditControl().ok(HtmlTools.unescapeHTMLUnicodeEntity(this.htmlEditorPanel.getDocumentText()));
            } else {
                this.getBase().getEditControl().cancel();
            }
            super.submit();
        }

        private void removeBodyStyle() {
            this.htmlEditorPanel.getDocument().getStyleSheet().removeStyle("body");
        }

        @Override
        protected void split() {
            this.removeBodyStyle();
            this.getBase().getEditControl().split(HtmlTools.unescapeHTMLUnicodeEntity(this.htmlEditorPanel.getDocumentText()), this.htmlEditorPanel.getCaretPosition());
            super.split();
        }

        @Override
        protected void cancel() {
            this.removeBodyStyle();
            this.getBase().getEditControl().cancel();
            super.cancel();
        }

        @Override
        protected boolean isChanged() {
            return this.htmlEditorPanel.needsSaving();
        }

        @Override
        public Component getMostRecentFocusOwner() {
            if (this.isFocused()) {
                return this.getFocusOwner();
            }
            return this.htmlEditorPanel.getMostRecentFocusOwner();
        }
    }
}

