/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;

public class FopImageConsumer
implements ImageConsumer {
    protected int width = -1;
    protected int height = -1;
    protected Integer imageStatus = new Integer(-1);
    protected int hints = 0;
    protected Hashtable properties = null;
    protected ColorModel cm = null;
    protected ImageProducer ip = null;

    public FopImageConsumer(ImageProducer iprod) {
        this.ip = iprod;
    }

    public void imageComplete(int status) {
        Integer n = this.imageStatus;
        synchronized (n) {
            if (this.imageStatus != 3 && this.imageStatus != 2) {
                this.imageStatus = new Integer(status);
            }
        }
    }

    public void setColorModel(ColorModel model) {
        this.cm = model;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setHints(int hintflags) {
        this.hints = hintflags;
    }

    public void setProperties(Hashtable props) {
        this.properties = props;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
    }

    public boolean isImageReady() throws Exception {
        Integer n = this.imageStatus;
        synchronized (n) {
            if (this.imageStatus == 4) {
                throw new Exception("Image aborted");
            }
            if (this.imageStatus == 1) {
                throw new Exception("Image error");
            }
            if (this.imageStatus == 3 || this.imageStatus == 2) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public int[] getImage() throws Exception {
        int[] tmpMap = new int[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(this.ip, 0, 0, this.width, this.height, tmpMap, 0, this.width);
        pg.setDimensions(this.width, this.height);
        pg.setColorModel(this.cm);
        pg.setHints(this.hints);
        pg.setProperties(this.properties);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException intex) {
            throw new Exception("Image grabbing interrupted : " + intex.getMessage());
        }
        return tmpMap;
    }
}

