/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.fonts.FontType;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFRectangle;

public class PDFFontDescriptor
extends PDFObject {
    private int ascent;
    private int capHeight;
    private int descent;
    private int flags;
    private PDFRectangle fontBBox;
    private String basefont;
    private int italicAngle;
    private int stemV;
    private int stemH = 0;
    private int xHeight = 0;
    private int leading = 0;
    private int avgWidth = 0;
    private int maxWidth = 0;
    private int missingWidth = 0;
    private AbstractPDFStream fontfile;
    private AbstractPDFStream cidSet;
    private FontType subtype;

    public PDFFontDescriptor(String basefont, int ascent, int descent, int capHeight, int flags, PDFRectangle fontBBox, int italicAngle, int stemV) {
        this.basefont = basefont;
        this.ascent = ascent;
        this.descent = descent;
        this.capHeight = capHeight;
        this.flags = flags;
        this.fontBBox = fontBBox;
        this.italicAngle = italicAngle;
        this.stemV = stemV;
    }

    public void setMetrics(int avgWidth, int maxWidth, int missingWidth, int leading, int stemH, int xHeight) {
        this.avgWidth = avgWidth;
        this.maxWidth = maxWidth;
        this.missingWidth = missingWidth;
        this.leading = leading;
        this.stemH = stemH;
        this.xHeight = xHeight;
    }

    public void setFontFile(FontType subtype, AbstractPDFStream fontfile) {
        this.subtype = subtype;
        this.fontfile = fontfile;
    }

    public AbstractPDFStream getFontFile() {
        return this.fontfile;
    }

    public void setCIDSet(AbstractPDFStream cidSet) {
        this.cidSet = cidSet;
    }

    public AbstractPDFStream getCIDSet() {
        return this.cidSet;
    }

    public String toPDFString() {
        StringBuffer p = new StringBuffer(128);
        p.append(this.getObjectID() + "<< /Type /FontDescriptor" + "\n/FontName /" + this.basefont);
        p.append("\n/FontBBox ");
        p.append(this.fontBBox.toPDFString());
        p.append("\n/Flags ");
        p.append(this.flags);
        p.append("\n/CapHeight ");
        p.append(this.capHeight);
        p.append("\n/Ascent ");
        p.append(this.ascent);
        p.append("\n/Descent ");
        p.append(this.descent);
        p.append("\n/ItalicAngle ");
        p.append(this.italicAngle);
        p.append("\n/StemV ");
        p.append(this.stemV);
        if (this.stemH != 0) {
            p.append("\n/StemH ");
            p.append(this.stemH);
        }
        if (this.xHeight != 0) {
            p.append("\n/XHeight ");
            p.append(this.xHeight);
        }
        if (this.avgWidth != 0) {
            p.append("\n/AvgWidth ");
            p.append(this.avgWidth);
        }
        if (this.maxWidth != 0) {
            p.append("\n/MaxWidth ");
            p.append(this.maxWidth);
        }
        if (this.missingWidth != 0) {
            p.append("\n/MissingWidth ");
            p.append(this.missingWidth);
        }
        if (this.leading != 0) {
            p.append("\n/Leading ");
            p.append(this.leading);
        }
        if (this.fontfile != null) {
            if (this.subtype == FontType.TYPE1) {
                p.append("\n/FontFile ");
            } else {
                p.append("\n/FontFile2 ");
            }
            p.append(this.fontfile.referencePDF());
        }
        if (this.getCIDSet() != null) {
            p.append("\n/CIDSet ");
            p.append(this.getCIDSet().referencePDF());
        }
        this.fillInPDF(p);
        p.append(" >>\nendobj\n");
        return p.toString();
    }

    protected void fillInPDF(StringBuffer begin) {
    }
}

