/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.filters.plugin.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gephi.filters.api.Range;
import org.gephi.filters.spi.RangeFilter;
import org.gephi.ui.components.JRangeSliderPanel;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.gephi.ui.filters.plugin.JQuickHistogram;

public class RangePanel
extends JPanel {
    private final JQuickHistogram histogram;
    private Object[] values;
    private RangeFilter filter;
    private JPanel histogramPanel;
    private JPanel rangeSliderPanel;

    public RangePanel() {
        this.initComponents();
        this.histogram = new JQuickHistogram();
        this.histogramPanel.add(this.histogram.getPanel());
        this.histogram.setConstraintHeight(30);
    }

    public void setup(final RangeFilter rangeFilter) {
        this.filter = rangeFilter;
        final Range range = (Range)rangeFilter.getRangeProperty().getValue();
        if (range != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    final JRangeSliderPanel rangeSlider = (JRangeSliderPanel)RangePanel.this.rangeSliderPanel;
                    RangePanel.access$102(RangePanel.this, range.getValues());
                    rangeSlider.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            try {
                                Range newRange;
                                Range oldRange;
                                if (evt.getPropertyName().equals("lowerbound")) {
                                    Range newRange2;
                                    Range oldRange2 = (Range)RangePanel.this.filter.getRangeProperty().getValue();
                                    if (!oldRange2.equals((Object)(newRange2 = new Range(rangeSlider.getRange().getLowerBound(), rangeSlider.getRange().getUpperBound(), oldRange2.getMinimum(), oldRange2.getMaximum(), oldRange2.getValues())))) {
                                        RangePanel.this.filter.getRangeProperty().setValue((Object)newRange2);
                                        new Thread(new Runnable(){

                                            @Override
                                            public void run() {
                                                RangePanel.this.setupHistogram(RangePanel.this.filter, newRange2);
                                            }
                                        }).start();
                                    }
                                } else if (evt.getPropertyName().equals("upperbound") && !(oldRange = (Range)RangePanel.this.filter.getRangeProperty().getValue()).equals((Object)(newRange = new Range(rangeSlider.getRange().getLowerBound(), rangeSlider.getRange().getUpperBound(), oldRange.getMinimum(), oldRange.getMaximum(), oldRange.getValues())))) {
                                    RangePanel.this.filter.getRangeProperty().setValue((Object)newRange);
                                    new Thread(new Runnable(){

                                        @Override
                                        public void run() {
                                            RangePanel.this.setupHistogram(RangePanel.this.filter, newRange);
                                        }
                                    }).start();
                                }
                            }
                            catch (Exception e) {
                                Logger.getLogger("").log(Level.SEVERE, "Error with range slider", e);
                            }
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            rangeSlider.setRange(JRangeSliderPanel.Range.build((JRangeSliderPanel)rangeSlider, (Number)range.getMinimum(), (Number)range.getMaximum(), (Number)range.getLowerBound(), (Number)range.getUpperBound()));
                        }
                    });
                    RangePanel.this.setupHistogram(rangeFilter, range);
                }
            }).start();
        }
    }

    private void setupHistogram(RangeFilter rangeFilter, Range range) {
        this.histogram.clear();
        for (Object value : this.values) {
            this.histogram.addData(value);
        }
        this.histogram.sortData();
        double rangeLowerBound = 0.0;
        double rangeUpperBound = 0.0;
        if (range.getRangeType().equals(Integer.class)) {
            rangeLowerBound = ((Integer)range.getLowerBound()).doubleValue();
            rangeUpperBound = ((Integer)range.getUpperBound()).doubleValue();
        } else if (range.getRangeType().equals(Float.class)) {
            rangeLowerBound = ((Float)range.getLowerBound()).doubleValue();
            rangeUpperBound = ((Float)range.getUpperBound()).doubleValue();
        } else if (range.getRangeType().equals(Double.class)) {
            rangeLowerBound = (Double)range.getLowerBound();
            rangeUpperBound = (Double)range.getUpperBound();
        } else if (range.getRangeType().equals(Long.class)) {
            rangeLowerBound = ((Long)range.getLowerBound()).doubleValue();
            rangeUpperBound = ((Long)range.getUpperBound()).doubleValue();
        }
        this.histogram.setLowerBound(rangeLowerBound);
        this.histogram.setUpperBound(rangeUpperBound);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RangePanel.this.revalidate();
                RangePanel.this.repaint();
            }
        });
    }

    private RichTooltip buildTooltip() {
        if (this.histogram.countValues() == 0) {
            return null;
        }
        NumberFormat formatter = DecimalFormat.getNumberInstance();
        formatter.setMaximumFractionDigits(3);
        String average = formatter.format(this.histogram.getAverage());
        String averageInRange = formatter.format(this.histogram.getAverageInRange());
        RichTooltip richTooltip = new RichTooltip();
        richTooltip.setTitle("Statistics (In-Range)");
        richTooltip.addDescriptionSection("<html><b># of Values:</b> " + this.histogram.countValues() + " (" + this.histogram.countInRange() + ")");
        richTooltip.addDescriptionSection("<html><b>Average:</b> " + average + " (" + averageInRange + ")");
        richTooltip.addDescriptionSection("<html><b>Median:</b> " + this.histogram.getMedian() + " (" + this.histogram.getMedianInRange() + ")");
        return richTooltip;
    }

    private void initComponents() {
        this.rangeSliderPanel = new JRangeSliderPanel();
        this.histogramPanel = new JPanel();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.rangeSliderPanel.setOpaque(false);
        this.add((Component)this.rangeSliderPanel, "Center");
        this.histogramPanel.setOpaque(false);
        this.histogramPanel.setLayout(new BorderLayout());
        this.add((Component)this.histogramPanel, "South");
    }

    static /* synthetic */ Object[] access$102(RangePanel x0, Object[] x1) {
        x0.values = x1;
        return x1;
    }
}

