/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import org.testng.IHookable;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodInvocationHelper;

public class InvokeMethodRunnable
implements Runnable {
    private ITestNGMethod m_method = null;
    private Object m_instance = null;
    private Object[] m_parameters = null;
    private final IHookable m_hookable;
    private final ITestResult m_testResult;

    public InvokeMethodRunnable(ITestNGMethod iTestNGMethod, Object object, Object[] objectArray, IHookable iHookable, ITestResult iTestResult) {
        this.m_method = iTestNGMethod;
        this.m_instance = object;
        this.m_parameters = objectArray;
        this.m_hookable = iHookable;
        this.m_testResult = iTestResult;
    }

    @Override
    public void run() throws TestNGRuntimeException {
        if (this.m_method.getInvocationTimeOut() > 0L) {
            for (int i = 0; i < this.m_method.getInvocationCount(); ++i) {
                this.runOne();
            }
        } else {
            this.runOne();
        }
    }

    private void runOne() {
        try {
            TestNGRuntimeException testNGRuntimeException = null;
            try {
                ConstructorOrMethod constructorOrMethod = this.m_method.getConstructorOrMethod();
                if (this.m_hookable == null) {
                    MethodInvocationHelper.invokeMethod(constructorOrMethod.getMethod(), this.m_instance, this.m_parameters);
                } else {
                    MethodInvocationHelper.invokeHookable(this.m_instance, this.m_parameters, this.m_hookable, constructorOrMethod.getMethod(), this.m_testResult);
                }
            }
            catch (Throwable throwable) {
                testNGRuntimeException = new TestNGRuntimeException(throwable.getCause());
            }
            if (null != testNGRuntimeException) {
                Thread.currentThread().interrupt();
                throw testNGRuntimeException;
            }
        }
        finally {
            this.m_method.incrementCurrentInvocationCount();
        }
    }

    public static class TestNGRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -8619899270785596231L;

        public TestNGRuntimeException(Throwable throwable) {
            super(throwable);
        }
    }
}

