/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.collections;

import org.testng.collections.Objects;

public class Pair<A, B> {
    private final A first;
    private final B second;

    public Pair(A a, B b) {
        this.first = a;
        this.second = b;
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.first == null ? 0 : this.first.hashCode());
        n = 31 * n + (this.second == null ? 0 : this.second.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Pair pair = (Pair)object;
        if (this.first == null ? pair.first != null : !this.first.equals(pair.first)) {
            return false;
        }
        return !(this.second == null ? pair.second != null : !this.second.equals(pair.second));
    }

    public static <A, B> Pair<A, B> create(A a, B b) {
        return Pair.of(a, b);
    }

    public static <A, B> Pair<A, B> of(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("first", this.first()).add("second", this.second()).toString();
    }
}

