/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.user;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Pattern;

public class Orcid {
    private static final Pattern PATTERN = Pattern.compile("[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]");
    public static final String ORCID_URI_PREFIX = "http://orcid.org/";
    private final String value;

    public Orcid(String value) {
        this.value = (String)Preconditions.checkNotNull((Object)value);
        if (!PATTERN.matcher(value).matches()) {
            throw new IllegalArgumentException("Invalid ORCID");
        }
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Orcid)) {
            return false;
        }
        Orcid other = (Orcid)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Orcid").addValue((Object)this.value).toString();
    }

    public URI toUri() {
        return URI.create(ORCID_URI_PREFIX + this.value);
    }
}

