/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.behavior.ColorPickerBehavior;
import com.sun.javafx.scene.control.skin.ColorPalette;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin;
import com.sun.javafx.scene.control.skin.ComboBoxMode;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class ColorPickerSkin
extends ComboBoxPopupControl<Color> {
    private Label displayNode;
    private StackPane icon;
    private Rectangle colorRect;
    private ColorPalette popupContent;
    BooleanProperty colorLabelVisible = new StyleableBooleanProperty(true){

        @Override
        public Object getBean() {
            return ColorPickerSkin.this;
        }

        @Override
        public String getName() {
            return "colorLabelVisible";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.COLOR_LABEL_VISIBLE;
        }
    };
    private static final List<String> colorNames = new ArrayList<String>();

    public ColorPickerSkin(ColorPicker colorPicker) {
        super(colorPicker, new ColorPickerBehavior(colorPicker));
        this.updateComboBoxMode();
        if (this.getMode() == ComboBoxMode.BUTTON || this.getMode() == ComboBoxMode.COMBOBOX) {
            if (this.arrowButton.getOnMouseReleased() == null) {
                this.arrowButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                    @Override
                    public void handle(MouseEvent mouseEvent) {
                        ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, true);
                        mouseEvent.consume();
                    }
                });
            }
        } else if (this.getMode() == ComboBoxMode.SPLITBUTTON && this.arrowButton.getOnMouseReleased() == null) {
            this.arrowButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, true);
                    mouseEvent.consume();
                }
            });
        }
        this.registerChangeListener(colorPicker.valueProperty(), "VALUE");
    }

    private void updateComboBoxMode() {
        if (((ComboBoxBase)this.getSkinnable()).getStyleClass().contains("button")) {
            this.setMode(ComboBoxMode.BUTTON);
        } else if (((ComboBoxBase)this.getSkinnable()).getStyleClass().contains("split-button")) {
            this.setMode(ComboBoxMode.SPLITBUTTON);
        }
    }

    static String colorValueToWeb(Color color) {
        String string = null;
        if (color == null) {
            return null;
        }
        if (colorNames != null) {
            for (String string2 : colorNames) {
                if (!Color.web(string2).equals(color)) continue;
                string = string2;
                break;
            }
        }
        if (string == null) {
            string = String.format((Locale)null, "%02x%02x%02x", Math.round(color.getRed() * 255.0), Math.round(color.getGreen() * 255.0), Math.round(color.getBlue() * 255.0));
        }
        return string;
    }

    @Override
    protected Node getPopupContent() {
        if (this.popupContent == null) {
            this.popupContent = new ColorPalette((Color)((ComboBoxBase)this.getSkinnable()).getValue(), (ColorPicker)this.getSkinnable());
            this.popupContent.setPopupControl(this.getPopup());
        }
        return this.popupContent;
    }

    @Override
    protected void focusLost() {
    }

    @Override
    public void show() {
        super.show();
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        this.popupContent.updateSelection((Color)colorPicker.getValue());
        this.popupContent.clearFocus();
        this.popupContent.setDialogLocation(this.getPopup().getX() + this.getPopup().getWidth(), this.getPopup().getY());
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "SHOWING") {
            if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                this.show();
            } else if (!this.popupContent.isCustomColorDialogShowing()) {
                this.hide();
            }
        } else if (string != "VALUE" || this.popupContent != null) {
            // empty if block
        }
    }

    @Override
    public Node getDisplayNode() {
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        if (this.displayNode == null) {
            this.displayNode = new Label();
            this.displayNode.getStyleClass().add("color-picker-label");
            if (this.getMode() == ComboBoxMode.BUTTON || this.getMode() == ComboBoxMode.COMBOBOX) {
                if (this.displayNode.getOnMouseReleased() == null) {
                    this.displayNode.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                        @Override
                        public void handle(MouseEvent mouseEvent) {
                            ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, true);
                        }
                    });
                }
            } else if (this.displayNode.getOnMouseReleased() == null) {
                this.displayNode.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                    @Override
                    public void handle(MouseEvent mouseEvent) {
                        ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, false);
                        mouseEvent.consume();
                    }
                });
            }
            this.icon = new StackPane();
            this.icon.getStyleClass().add("picker-color");
            this.colorRect = new Rectangle(16.0, 16.0);
            this.colorRect.getStyleClass().add("picker-color-rect");
            this.updateColor();
            colorPicker.addEventHandler(ActionEvent.ACTION, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ColorPickerSkin.this.updateColor();
                }
            });
            this.icon.getChildren().add(this.colorRect);
            this.displayNode.setGraphic(this.icon);
            if (this.displayNode.getOnMouseReleased() == null) {
                this.displayNode.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                    @Override
                    public void handle(MouseEvent mouseEvent) {
                        ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, false);
                        mouseEvent.consume();
                    }
                });
            }
        }
        return this.displayNode;
    }

    private void updateColor() {
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        this.colorRect.setFill((Paint)colorPicker.getValue());
        if (this.colorLabelVisible.get()) {
            this.displayNode.setText(ColorPickerSkin.colorValueToWeb((Color)colorPicker.getValue()));
        } else {
            this.displayNode.setText("");
        }
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup().isShowing() && ((ComboBoxBase)this.getSkinnable()).isShowing()) {
            ((ComboBoxBase)this.getSkinnable()).hide();
        }
    }

    @Override
    protected void layoutChildren() {
        this.updateComboBoxMode();
        super.layoutChildren();
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return ColorPickerSkin.impl_CSS_STYLEABLES();
    }

    static {
        Color.web("white", 1.0);
        for (Field field : Color.class.getDeclaredFields()) {
            int n = field.getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isPublic(n) || !field.getType().equals(Color.class)) continue;
            colorNames.add(field.getName());
        }
        Collections.sort(colorNames);
    }

    private static class StyleableProperties {
        private static final StyleableProperty<ColorPickerSkin, Boolean> COLOR_LABEL_VISIBLE = new StyleableProperty<ColorPickerSkin, Boolean>("-fx-color-label-visible", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public WritableValue<Boolean> getWritableValue(ColorPickerSkin colorPickerSkin) {
                return colorPickerSkin.colorLabelVisible;
            }

            @Override
            public boolean isSettable(ColorPickerSkin colorPickerSkin) {
                return colorPickerSkin.colorLabelVisible == null || !colorPickerSkin.colorLabelVisible.isBound();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(ComboBoxBaseSkin.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, COLOR_LABEL_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

