/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.ldap;

import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.toolkit.url.GenericURLDirContext;
import com.sun.jndi.url.ldap.ldapURLContextFactory;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ResolveResult;

public final class ldapURLContext
extends GenericURLDirContext {
    ldapURLContext(Hashtable<?, ?> env) {
        super(env);
    }

    @Override
    protected ResolveResult getRootURLContext(String name, Hashtable<?, ?> env) throws NamingException {
        return ldapURLContextFactory.getUsingURLIgnoreRootDN(name, env);
    }

    @Override
    protected Name getURLSuffix(String prefix, String url) throws NamingException {
        LdapURL ldapUrl = new LdapURL(url);
        String dn = ldapUrl.getDN() != null ? ldapUrl.getDN() : "";
        CompositeName remaining = new CompositeName();
        if (!"".equals(dn)) {
            remaining.add(dn);
        }
        return remaining;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.lookup(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.lookup(name);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.bind(name, obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.bind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.rebind(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.rebind(name, obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.unbind(name);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.unbind(name);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        if (LdapURL.hasQueryComponents(oldName)) {
            throw new InvalidNameException(oldName);
        }
        if (LdapURL.hasQueryComponents(newName)) {
            throw new InvalidNameException(newName);
        }
        super.rename(oldName, newName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (LdapURL.hasQueryComponents(oldName.get(0))) {
            throw new InvalidNameException(oldName.toString());
        }
        if (LdapURL.hasQueryComponents(newName.get(0))) {
            throw new InvalidNameException(newName.toString());
        }
        super.rename(oldName, newName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.listBindings(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.createSubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.createSubcontext(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.lookupLink(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.lookupLink(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getNameParser(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        if (LdapURL.hasQueryComponents(prefix)) {
            throw new InvalidNameException(prefix);
        }
        return super.composeName(name, prefix);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        if (LdapURL.hasQueryComponents(prefix.get(0))) {
            throw new InvalidNameException(prefix.toString());
        }
        return super.composeName(name, prefix);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getAttributes(name);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getAttributes(name);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getAttributes(name, attrIds);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getAttributes(name, attrIds);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.modifyAttributes(name, mods);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.modifyAttributes(name, mods);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.bind(name, obj, attrs);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.bind(name, obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        super.rebind(name, obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.rebind(name, obj, attrs);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.createSubcontext(name, attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.createSubcontext(name, attrs);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getSchema(name);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getSchema(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            throw new InvalidNameException(name);
        }
        return super.getSchemaClassDefinition(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getSchemaClassDefinition(name);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            return this.searchUsingURL(name);
        }
        return super.search(name, matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), matchingAttributes);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            return this.searchUsingURL(name);
        }
        return super.search(name, matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), matchingAttributes, attributesToReturn);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            return this.searchUsingURL(name);
        }
        return super.search(name, filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), filter, cons);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        if (LdapURL.hasQueryComponents(name)) {
            return this.searchUsingURL(name);
        }
        return super.search(name, filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), filterExpr, filterArgs, cons);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, filterExpr, filterArgs, cons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingEnumeration<SearchResult> searchUsingURL(String name) throws NamingException {
        LdapURL url = new LdapURL(name);
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (DirContext ctx = (DirContext)res.getResolvedObj();){
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search(res.getRemainingName(), ldapURLContext.setFilterUsingURL(url), ldapURLContext.setSearchControlsUsingURL(url));
            return namingEnumeration;
        }
    }

    private static String setFilterUsingURL(LdapURL url) {
        String filter = url.getFilter();
        if (filter == null) {
            filter = "(objectClass=*)";
        }
        return filter;
    }

    private static SearchControls setSearchControlsUsingURL(LdapURL url) {
        SearchControls cons = new SearchControls();
        String scope = url.getScope();
        String attributes = url.getAttributes();
        if (scope == null) {
            cons.setSearchScope(0);
        } else if (scope.equals("sub")) {
            cons.setSearchScope(2);
        } else if (scope.equals("one")) {
            cons.setSearchScope(1);
        } else if (scope.equals("base")) {
            cons.setSearchScope(0);
        }
        if (attributes == null) {
            cons.setReturningAttributes(null);
        } else {
            StringTokenizer tokens = new StringTokenizer(attributes, ",");
            int count = tokens.countTokens();
            String[] attrs = new String[count];
            for (int i = 0; i < count; ++i) {
                attrs[i] = tokens.nextToken();
            }
            cons.setReturningAttributes(attrs);
        }
        return cons;
    }
}

