/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import tim.prune.gui.map.MapTileManager;

public class TileDownloader
implements Runnable {
    private MapTileManager _manager = null;
    private URL _url = null;
    private int _layer = 0;
    private int _x = 0;
    private int _y = 0;
    private int _zoom = 0;
    private static final HashSet<String> BLOCKED_URLS = new HashSet();
    private static final HashSet<String> LOADING_URLS = new HashSet();

    private TileDownloader(MapTileManager mapTileManager, URL uRL, int n, int n2, int n3, int n4) {
        this._manager = mapTileManager;
        this._url = uRL;
        this._layer = n;
        this._x = n2;
        this._y = n3;
        this._zoom = n4;
    }

    public static synchronized void triggerLoad(MapTileManager mapTileManager, URL uRL, int n, int n2, int n3, int n4) {
        String string;
        if (mapTileManager != null && uRL != null && !BLOCKED_URLS.contains(string = uRL.toString()) && !LOADING_URLS.contains(string)) {
            LOADING_URLS.add(string);
            new Thread(new TileDownloader(mapTileManager, uRL, n, n2, n3, n4)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = this._url.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "GpsPrune v19.2");
            inputStream = uRLConnection.getInputStream();
            int n = uRLConnection.getContentLength();
            if (n > 0) {
                byte[] byArray = new byte[n];
                int n2 = 0;
                while (n2 < n) {
                    int n3 = inputStream.read(byArray, n2, n - n2);
                    n2 += n3;
                }
                Image image = Toolkit.getDefaultToolkit().createImage(byArray);
                inputStream.close();
                this._manager.notifyImageLoaded(image, this._layer, this._x, this._y, this._zoom);
            }
        }
        catch (IOException iOException) {
            System.err.println("IOE: " + iOException.getClass().getName() + " - " + iOException.getMessage());
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                BLOCKED_URLS.add(this._url.toString());
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        LOADING_URLS.remove(this._url.toString());
    }
}

