/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.artifacts.transform.PrimaryInput;
import org.gradle.api.artifacts.transform.Workspace;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;

public class DefaultTransformer
implements Transformer {
    private final Class<? extends ArtifactTransform> implementationClass;
    private final Isolatable<Object> config;
    private final boolean requiresDependencies;
    private final Isolatable<Object[]> parameters;
    private final InstanceFactory<? extends ArtifactTransform> instanceFactory;
    private final HashCode inputsHash;
    private final ImmutableAttributes fromAttributes;

    public DefaultTransformer(Class<? extends ArtifactTransform> implementationClass, Isolatable<Object> config, Isolatable<Object[]> parameters, HashCode inputsHash, InstantiatorFactory instantiatorFactory, ImmutableAttributes fromAttributes) {
        this.implementationClass = implementationClass;
        this.config = config;
        this.instanceFactory = instantiatorFactory.injectScheme((Collection)ImmutableSet.of(Workspace.class, PrimaryInput.class)).forType(implementationClass);
        this.requiresDependencies = this.instanceFactory.requiresService(ArtifactTransformDependencies.class);
        this.parameters = parameters;
        this.inputsHash = inputsHash;
        this.fromAttributes = fromAttributes;
    }

    @Override
    public boolean requiresDependencies() {
        return this.requiresDependencies;
    }

    @Override
    public ImmutableAttributes getFromAttributes() {
        return this.fromAttributes;
    }

    @Override
    public List<File> transform(File primaryInput, File outputDir, ArtifactTransformDependencies dependencies) {
        ArtifactTransform transformer = this.newTransformer(primaryInput, outputDir, dependencies);
        transformer.setOutputDirectory(outputDir);
        List outputs = transformer.transform(primaryInput);
        return DefaultTransformer.validateOutputs(primaryInput, outputDir, outputs);
    }

    private static List<File> validateOutputs(File primaryInput, File outputDir, @Nullable List<File> outputs) {
        if (outputs == null) {
            throw new InvalidUserDataException("Transform returned null result.");
        }
        String inputFilePrefix = primaryInput.getPath() + File.separator;
        String outputDirPrefix = outputDir.getPath() + File.separator;
        for (File output : outputs) {
            if (!output.exists()) {
                throw new InvalidUserDataException("Transform output file " + output.getPath() + " does not exist.");
            }
            if (output.equals(primaryInput) || output.equals(outputDir) || output.getPath().startsWith(outputDirPrefix) || output.getPath().startsWith(inputFilePrefix)) continue;
            throw new InvalidUserDataException("Transform output file " + output.getPath() + " is not a child of the transform's input file or output directory.");
        }
        return outputs;
    }

    private ArtifactTransform newTransformer(File inputFile, File outputDir, ArtifactTransformDependencies artifactTransformDependencies) {
        TransformServiceLookup services = new TransformServiceLookup(inputFile, outputDir, this.config.isolate(), (ArtifactTransformDependencies)(this.requiresDependencies ? artifactTransformDependencies : null));
        return (ArtifactTransform)this.instanceFactory.newInstance((ServiceLookup)services, (Object[])this.parameters.isolate());
    }

    @Override
    public HashCode getSecondaryInputHash() {
        return this.inputsHash;
    }

    @Override
    public Class<? extends ArtifactTransform> getImplementationClass() {
        return this.implementationClass;
    }

    public String getDisplayName() {
        return this.implementationClass.getSimpleName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTransformer that = (DefaultTransformer)o;
        return this.inputsHash.equals((Object)that.inputsHash);
    }

    public int hashCode() {
        return this.inputsHash.hashCode();
    }

    private static class TransformServiceLookup
    implements ServiceLookup {
        private final File inputFile;
        private final File outputDir;
        private final Object config;
        private final ArtifactTransformDependencies artifactTransformDependencies;

        public TransformServiceLookup(File inputFile, File outputDir, @Nullable Object config, @Nullable ArtifactTransformDependencies artifactTransformDependencies) {
            this.inputFile = inputFile;
            this.outputDir = outputDir;
            this.config = config;
            this.artifactTransformDependencies = artifactTransformDependencies;
        }

        @Nullable
        private Object find(Type serviceType, @Nullable Class<? extends Annotation> annotatedWith) {
            if (!(serviceType instanceof Class)) {
                return null;
            }
            Class serviceClass = (Class)serviceType;
            if (annotatedWith == Workspace.class && serviceClass.isAssignableFrom(File.class)) {
                return this.outputDir;
            }
            if (annotatedWith == PrimaryInput.class && serviceClass.isAssignableFrom(File.class)) {
                return this.inputFile;
            }
            if (annotatedWith == null && this.artifactTransformDependencies != null && serviceClass.isAssignableFrom(ArtifactTransformDependencies.class)) {
                return this.artifactTransformDependencies;
            }
            if (annotatedWith == null && serviceClass.isInstance(this.config)) {
                return this.config;
            }
            return null;
        }

        @Nullable
        public Object find(Type serviceType) throws ServiceLookupException {
            return this.find(serviceType, null);
        }

        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType);
            if (result == null) {
                throw new UnknownServiceException(serviceType, "No service of type " + serviceType + " available.");
            }
            return result;
        }

        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType, annotatedWith);
            if (result == null) {
                throw new UnknownServiceException(serviceType, "No service of type " + serviceType + " available.");
            }
            return result;
        }
    }
}

