/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.zaproxy.zap.utils.XmlUtils;

public class ZapXmlConfiguration
extends XMLConfiguration {
    private static final long serialVersionUID = -8598525138011232529L;

    public ZapXmlConfiguration() {
        super.setEncoding("UTF-8");
        super.setDelimiterParsingDisabled(true);
    }

    public ZapXmlConfiguration(String fileName) throws ConfigurationException {
        this();
        this.setFileName(fileName);
        this.load();
    }

    public ZapXmlConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        this.load();
    }

    protected DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = XmlUtils.newXxeDisabledDocumentBuilderFactory();
        if (this.isValidating()) {
            factory.setValidating(true);
            if (this.isSchemaValidation()) {
                factory.setNamespaceAware(true);
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
        }
        DocumentBuilder result = factory.newDocumentBuilder();
        result.setEntityResolver(this.getEntityResolver());
        if (this.isValidating()) {
            result.setErrorHandler(new DefaultHandler(){

                @Override
                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }
            });
        }
        return result;
    }

    public ZapXmlConfiguration(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
        this.load();
    }

    public void setEncoding(String encoding) {
    }

    public void setListDelimiter(char listDelimiter) {
    }

    public void setDelimiterParsingDisabled(boolean delimiterParsingDisabled) {
    }
}

